/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.uni_paderborn.fujaba.fsa.swing.EditableComponent;
import de.uni_paderborn.fujaba.fsa.swing.EvenPlainerEditorKit;
import de.uni_paderborn.fujaba.gui.CompletionKeyListener;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class JTextEditor
extends EditableComponent
implements DocumentListener {
    private LineBorder lineBorder = null;
    static /* synthetic */ Class class$0;

    public JTextEditor() {
        JEditorPane pane = new JEditorPane();
        this.add(pane);
        this.setComponent(pane);
        this.getEditorPane().setEditorKit(new EvenPlainerEditorKit());
        this.getEditorPane().setContentType("text/plain");
        this.getEditorPane().setEditable(false);
        this.getEditorPane().getDocument().addDocumentListener(this);
        AscendDescendMouseHandler.registerADMouseInputHandler(this.getEditorPane());
    }

    public void setText(String text) {
        this.getEditorPane().setText(text);
    }

    public String getText() {
        return this.getEditorPane().getText();
    }

    public void setDocument(Document doc) {
        this.getEditorPane().setDocument(doc);
    }

    public Document getDocument() {
        return this.getEditorPane().getDocument();
    }

    public JEditorPane getEditorPane() {
        return (JEditorPane)this.getComponent();
    }

    public Dimension getPreferredSize() {
        if (this.isEditing()) {
            return this.getComponent(0).getPreferredSize();
        }
        return super.getPreferredSize();
    }

    protected void updateEditor(JComponent component) {
    }

    protected void enableEditor(JComponent component) {
        if (component instanceof JEditorPane) {
            if (this.lineBorder == null) {
                this.lineBorder = new LineBorder(ColorsPreferences.get().EDITOR_BORDER, 1);
            }
            JEditorPane editor = this.getEditorPane();
            boolean done = false;
            KeyListener[] keyListeners = this.getKeyListeners();
            int i = 0;
            while (i < keyListeners.length && !done) {
                if (keyListeners[i] instanceof CompletionKeyListener) {
                    KeyListener completionListener = keyListeners[i];
                    KeyListener[] oldKeyListeners = editor.getKeyListeners();
                    int j = 0;
                    while (j < oldKeyListeners.length && !done) {
                        if (oldKeyListeners[j].equals(completionListener)) {
                            done = true;
                        }
                        ++j;
                    }
                    if (!done) {
                        editor.addKeyListener(completionListener);
                    }
                }
                ++i;
            }
            editor.setEditable(true);
            editor.setBorder(this.lineBorder);
            AscendDescendMouseHandler.unregisterADMouseInputHandler(editor);
            if (!editor.hasFocus()) {
                editor.requestFocus();
            }
        }
    }

    protected void disableEditor(JComponent component) {
        if (component instanceof JEditorPane) {
            JEditorPane editor = this.getEditorPane();
            editor.setEditable(false);
            editor.setBorder(null);
            AscendDescendMouseHandler.registerADMouseInputHandler(editor);
            if (editor.hasFocus()) {
                this.requestFocus();
            }
        }
    }

    protected String getEditorClassName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.JEditorPane");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    protected void updateJLabel() {
    }

    public void setVisible(boolean vis) {
        super.setVisible(vis);
        this.getEditorPane().setVisible(vis);
    }

    private void refresh() {
        JComponent parent = (JComponent)this.getParent();
        if (parent != null) {
            while (parent != null && parent.getParent() instanceof JComponent) {
                parent.setPreferredSize(null);
                parent = (JComponent)parent.getParent();
            }
            if (parent != null) {
                parent.setPreferredSize(null);
                parent.validate();
            }
        }
    }

    public void changedUpdate(DocumentEvent event) {
        this.refresh();
    }

    public void insertUpdate(DocumentEvent event) {
        this.refresh();
    }

    public void removeUpdate(DocumentEvent event) {
        this.refresh();
    }
}

