/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JLine;
import de.upb.tools.fca.FEmptyListIterator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class JPolyLine
extends JBendLine {
    private Vector lines;
    private double totalLength = -1.0;
    private boolean adjustingBounds = false;

    public JPolyLine(JBend start, JBend end) {
        super(start, end);
        this.insertInLines(0, new LineSegment(start, end));
    }

    protected void startPointChanged() {
        if (this.sizeOfLines() == 0) {
            super.startPointChanged();
        }
    }

    protected void endPointChanged() {
        if (this.sizeOfLines() == 0) {
            super.endPointChanged();
        }
    }

    public LineSegment getFromLines(int pos) {
        if (this.lines == null) {
            return null;
        }
        return (LineSegment)this.lines.get(pos);
    }

    public int getIndexFromLines(LineSegment line) {
        if (this.lines == null || line == null) {
            return -1;
        }
        return this.lines.indexOf(line);
    }

    boolean insertInLines(int pos, LineSegment value) {
        boolean changed = false;
        if (value != null) {
            int size = this.sizeOfLines();
            if (pos < 0 || pos > size) {
                throw new ArrayIndexOutOfBoundsException(pos);
            }
            if (!this.hasInLines(value)) {
                if (this.lines == null) {
                    this.lines = new Vector();
                }
                this.lines.add(pos, value);
                value.setPolyLine(this);
                if (value.getParent() != null) {
                    value.getParent().remove(value);
                }
                this.add(value);
                value.setUI(this.ui);
                this.revalidate();
                changed = true;
            }
        }
        return changed;
    }

    public boolean hasInLines(LineSegment value) {
        return this.lines != null && value != null && this.lines.contains(value);
    }

    public final ListIterator iteratorOfLines() {
        return this.iteratorOfLines(0);
    }

    public final ListIterator iteratorOfLines(LineSegment line) {
        return this.iteratorOfLines(this.getIndexFromLines(line));
    }

    public ListIterator iteratorOfLines(int start) {
        return this.lines == null ? FEmptyListIterator.get() : this.lines.listIterator(start);
    }

    public int sizeOfLines() {
        return this.lines == null ? 0 : this.lines.size();
    }

    boolean removeFromLines(LineSegment value) {
        boolean changed = false;
        if (this.lines != null && value != null) {
            changed = this.lines.remove(value);
            this.remove(value);
            if (value.getPolyLine() == this) {
                value.setPolyLine(null);
            }
            this.revalidate();
        }
        return changed;
    }

    boolean removeFromLines(int pos) {
        LineSegment line;
        boolean changed = false;
        if (this.lines != null && pos >= 0 && pos < this.sizeOfLines()) {
            line = (LineSegment)this.lines.get(pos);
            this.lines.remove(pos);
            if (line != null && line.getPolyLine() == this) {
                line.setPolyLine(null);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException(pos);
        }
        changed = line != null;
        return changed;
    }

    void removeAllFromLines() {
        if (this.lines == null) {
            return;
        }
        int size = this.lines.size();
        int i = size - 1;
        while (i >= 0) {
            this.removeFromLines(i);
            --i;
        }
    }

    public LineSegment getLineAt(double d) {
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException(String.valueOf(d) + " not in interval [0,1]");
        }
        double seekLength = d * this.getLength();
        double tmpLength = -1.0;
        LineSegment line = null;
        ListIterator lineIter = this.iteratorOfLines();
        if (lineIter.hasNext()) {
            line = (LineSegment)lineIter.next();
            tmpLength = line.getLength();
        }
        while (lineIter.hasNext() && tmpLength < seekLength) {
            line = (LineSegment)lineIter.next();
            tmpLength += line.getLength();
        }
        return line;
    }

    public Point2D getPointAt(double d) {
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException(String.valueOf(d) + " not in interval [0,1]");
        }
        if (this.sizeOfLines() == 0) {
            return super.getPointAt(d);
        }
        double totalLength = this.getLength();
        if (totalLength == 0.0 || d == 0.0) {
            return this.getStartPoint();
        }
        if (d == 1.0) {
            return this.getEndPoint();
        }
        Point2D point = null;
        double seekLength = d * totalLength;
        double tmpLength = -1.0;
        double lineLength = 0.0;
        LineSegment line = null;
        ListIterator lineIter = this.iteratorOfLines();
        if (lineIter.hasNext()) {
            line = (LineSegment)lineIter.next();
            tmpLength = lineLength = line.getLength();
        }
        while (lineIter.hasNext() && tmpLength < seekLength) {
            line = (LineSegment)lineIter.next();
            lineLength = line.getLength();
            tmpLength += lineLength;
        }
        d = (seekLength - tmpLength + lineLength) / lineLength;
        point = d == 0.0 ? line.getStartPoint() : (d == 1.0 ? line.getEndPoint() : line.getPointAt(d));
        return new Point2D.Double(point.getX() + (double)this.getX(), point.getY() + (double)this.getY());
    }

    public LineSegment getClosestLine(Point p) {
        return this.getClosestLine(p.x, p.y);
    }

    public LineSegment getClosestLine(int x, int y) {
        if (this.sizeOfLines() == 0) {
            return null;
        }
        x -= this.getX();
        y -= this.getY();
        LineSegment closestLine = null;
        double minDist = Double.MAX_VALUE;
        ListIterator lineIter = this.iteratorOfLines();
        while (lineIter.hasNext()) {
            LineSegment tmpLine = (LineSegment)lineIter.next();
            double dist = tmpLine.getDistance(x, y);
            if (!(dist < minDist)) continue;
            minDist = dist;
            closestLine = tmpLine;
        }
        return closestLine;
    }

    public boolean contains(int x, int y) {
        if (this.sizeOfLines() == 0) {
            return super.contains(x, y);
        }
        Dimension size = this.getSize();
        if (x >= 0 && x < size.width && y >= 0 && y < size.height) {
            ListIterator iter = this.iteratorOfLines();
            Point loc = null;
            while (iter.hasNext()) {
                LineSegment line = (LineSegment)iter.next();
                loc = line.getLocation(loc);
                if (!line.contains(x - loc.x, y - loc.y)) continue;
                return true;
            }
        }
        return false;
    }

    public double getDistance(int x, int y) {
        if (this.sizeOfLines() == 0) {
            return super.getDistance(x, y);
        }
        LineSegment line = this.getClosestLine(x, y);
        return line != null ? line.getDistance(x - this.getX(), y - this.getY()) : Double.MAX_VALUE;
    }

    public double getPosition(int x, int y) {
        if (this.sizeOfLines() == 0) {
            return super.getPosition(x, y);
        }
        LineSegment closestLine = this.getClosestLine(x, y);
        double tmpLength = 0.0;
        double totalLength = this.getLength();
        LineSegment line = null;
        ListIterator lineIter = this.iteratorOfLines();
        if (lineIter.hasNext()) {
            line = (LineSegment)lineIter.next();
            tmpLength = line.getLength();
        }
        while (lineIter.hasNext() && line != closestLine) {
            line = (LineSegment)lineIter.next();
            tmpLength += line.getLength();
        }
        return (tmpLength -= line.getLength() * (1.0 - line.getPosition(x - this.getX(), y - this.getY()))) / totalLength;
    }

    public Point2D getDirection(double d, Point2D p) {
        LineSegment line = this.getLineAt(d);
        return line.getDirection(p);
    }

    public Point2D getNormal(double d, Point2D p) {
        LineSegment line = this.getLineAt(d);
        return line.getNormal(p);
    }

    public double getAngle(double d) {
        LineSegment line = this.getLineAt(d);
        return line.getAngle();
    }

    public double getLength() {
        if (this.isCoeffsDirty()) {
            this.computeCoeffs();
        }
        return this.totalLength;
    }

    void computeCoeffs() {
        super.computeCoeffs();
        if (this.sizeOfLines() == 0) {
            this.totalLength = this.getStartToEndDistance();
        } else {
            this.totalLength = 0.0;
            ListIterator lineIter = this.iteratorOfLines();
            while (lineIter.hasNext()) {
                LineSegment line = (LineSegment)lineIter.next();
                this.totalLength += line.getLength();
            }
        }
    }

    public boolean setPointAt(int index, int x, int y) {
        boolean changed = false;
        int size = this.sizeOfLines();
        if (index >= 0 && size >= index) {
            Point location = this.getLocation();
            if (index == 0) {
                LineSegment line = this.getFromLines(0);
                changed = line.setStartPoint(x - location.x, y - location.y);
            } else {
                LineSegment line = this.getFromLines(index - 1);
                changed = line.setEndPoint(x - location.x, y - location.y);
            }
            return changed;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public Point getFromPoints(int index) {
        int size = this.sizeOfLines();
        if (size == 0 && index >= 0 && index <= 1) {
            if (index == 0) {
                return this.getStartPoint();
            }
            return this.getEndPoint();
        }
        if (index >= 0 && index < size) {
            Point point = index == 0 ? this.getFromLines(0).getStartPoint() : this.getFromLines(index - 1).getEndPoint();
            Point location = this.getLocation();
            point.x += location.x;
            point.y += location.y;
            return point;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public ListIterator iteratorOfPoints(int start) {
        if (this.sizeOfLines() == 0) {
            return super.iteratorOfPoints(start);
        }
        return new PointIterator(this.iteratorOfLines(start == 0 ? 0 : start - 1), start);
    }

    public int sizeOfPoints() {
        return this.sizeOfBends();
    }

    public boolean setStartBend(JBend value) {
        boolean changed = super.setStartBend(value);
        if (this.sizeOfLines() > 0) {
            changed |= this.setBendAt(0, value);
        }
        return changed;
    }

    public boolean setEndBend(JBend value) {
        boolean changed = super.setEndBend(value);
        int size = this.sizeOfLines();
        if (size > 0) {
            changed |= this.setBendAt(size, value);
        }
        return changed;
    }

    public boolean hasInBends(JBend bend) {
        if (bend == null) {
            return false;
        }
        if (this.lines == null) {
            return this.getStartBend() == bend || this.getEndBend() == bend;
        }
        return super.hasInBends(bend);
    }

    public boolean setBendAt(int index, JBend b) {
        int size = this.sizeOfLines();
        boolean changed = false;
        if (size >= index) {
            if (index == 0) {
                LineSegment line = this.getFromLines(0);
                changed = line.setStartBend(b);
                if (this.getStartBend() != b) {
                    changed |= this.setStartBend(b);
                }
            } else {
                LineSegment line = this.getFromLines(index - 1);
                changed = line.setEndBend(b);
                if (size == index && this.getEndBend() != b) {
                    changed |= this.setEndBend(b);
                } else if (size > index) {
                    line = this.getFromLines(index);
                    changed |= line.setStartBend(b);
                }
            }
            return changed;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public JBend getFromBends(int index) {
        int size = this.sizeOfBends();
        if (index < 0 || index >= size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        JBend bend = index == 0 ? this.getStartBend() : (index == size - 1 ? this.getEndBend() : this.getFromLines(index - 1).getEndBend());
        return bend;
    }

    public int sizeOfBends() {
        int lineSize = this.sizeOfLines();
        return lineSize == 0 ? 2 : lineSize + 1;
    }

    public ListIterator iteratorOfBends(int start) {
        if (this.sizeOfLines() == 0) {
            return super.iteratorOfBends(start);
        }
        return new BendIterator(this.iteratorOfLines(start == 0 ? 0 : start - 1), start);
    }

    public boolean insertInBends(JBend bend) {
        int index = -1;
        if (this.sizeOfBends() == 2) {
            index = 1;
        } else {
            double pos;
            Point point = bend.getPoint();
            if (bend.getParent() != null && this.getParent() != null) {
                point = SwingUtilities.convertPoint(bend.getParent(), point, this.getParent());
            }
            if ((pos = this.getPosition(point)) < 0.0) {
                index = 1;
            } else if (pos > 1.0) {
                index = this.sizeOfBends() - 1;
            } else {
                LineSegment segment = this.getClosestLine(point);
                index = this.getIndexFromBends(segment.getEndBend());
            }
        }
        if (index > -1) {
            return this.insertInBends(index, bend);
        }
        return false;
    }

    public boolean insertInBends(int index, JBend bend) {
        int size = this.sizeOfBends();
        int lineSize = this.sizeOfLines();
        if (index < 0 || index > size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (bend != null && !this.hasInBends(bend)) {
            LineSegment newLine = new LineSegment();
            if (index < lineSize) {
                this.insertInLines(index, newLine);
                newLine.setStartBend(bend);
                newLine.setEndBend(this.getFromLines(index + 1).getStartBend());
                if (index == 0) {
                    this.setStartBend(bend);
                } else {
                    this.getFromLines(index - 1).setEndBend(bend);
                }
            } else {
                this.insertInLines(index - 1, newLine);
                newLine.setEndBend(bend);
                if (index == size) {
                    newLine.setStartBend(this.getFromLines(index - 2).getEndBend());
                    this.setEndBend(bend);
                } else {
                    newLine.setStartBend(this.getFromLines(index).getStartBend());
                    this.getFromLines(index).setStartBend(bend);
                }
            }
            this.revalidate();
            return true;
        }
        return false;
    }

    public int getIndexFromBends(JBend bend) {
        if (this.sizeOfLines() == 0) {
            if (bend == this.getStartBend()) {
                return 0;
            }
            if (bend == this.getEndBend()) {
                return 1;
            }
            return -1;
        }
        return super.getIndexFromBends(bend);
    }

    public boolean removeFromBends(JBend bend) {
        int index = this.getIndexFromBends(bend);
        if (index > -1) {
            return this.removeFromBends(index);
        }
        return false;
    }

    public boolean removeFromBends(int index) {
        int size = this.sizeOfLines();
        if (index < 0 || index > size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        LineSegment incomingLine = index > 0 ? this.getFromLines(index - 1) : null;
        LineSegment outgoingLine = index < size ? this.getFromLines(index) : null;
        JBend removeBend = null;
        boolean changed = false;
        if (outgoingLine != null) {
            JBend bend = outgoingLine.getEndBend();
            removeBend = outgoingLine.getStartBend();
            changed = this.removeFromLines(outgoingLine);
            outgoingLine.removeYou();
            if (incomingLine != null) {
                incomingLine.setEndBend(bend);
            } else {
                this.setStartBend(bend);
            }
        } else if (incomingLine != null) {
            JBend bend = incomingLine.getStartBend();
            removeBend = incomingLine.getEndBend();
            changed = this.removeFromLines(incomingLine);
            incomingLine.removeYou();
            this.setEndBend(bend);
        }
        boolean bl = removeBend != null && removeBend.removeFromLines(this);
        this.revalidate();
        return changed |= bl;
    }

    public void removeAllFromBends() {
        this.removeAllFromLines();
        this.setStartBend(null);
        this.setEndBend(null);
    }

    public void removeYou() {
        this.removeAllFromBends();
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        ListIterator lineIter = this.iteratorOfLines();
        while (lineIter.hasNext()) {
            LineSegment line = (LineSegment)lineIter.next();
            line.setForeground(c);
        }
    }

    public void revalidate() {
        this.invalidateCoeffs();
        super.revalidate();
    }

    public void paintComponent(Graphics g) {
    }

    public void setUI(ComponentUI ui) {
        super.setUI(ui);
        ListIterator lineIter = this.iteratorOfLines();
        while (lineIter.hasNext()) {
            LineSegment line = (LineSegment)lineIter.next();
            line.setUI(ui);
        }
    }

    public Rectangle getPreferredBounds() {
        Rectangle result = super.getPreferredBounds();
        Rectangle tmpRect = null;
        int x = this.getX();
        int y = this.getY();
        Component[] children = this.getComponents();
        int i = 0;
        while (i < children.length) {
            Component comp = children[i];
            if (comp.isVisible()) {
                tmpRect = comp instanceof JLine ? ((JLine)comp).getPreferredBounds() : comp.getBounds(tmpRect);
                tmpRect.translate(x, y);
                result.add(tmpRect);
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean adjustBounds() {
        this.adjustingBounds = true;
        boolean changed = false;
        try {
            Point oldLoc = this.getLocation();
            changed = super.adjustBounds();
            Point newLoc = this.getLocation();
            if (!oldLoc.equals(newLoc)) {
                ListIterator lineIter = this.iteratorOfLines();
                while (lineIter.hasNext()) {
                    LineSegment line = (LineSegment)lineIter.next();
                    if (line.getStartBend() == null || line.getEndBend() == null) continue;
                    line.invalidateStartTransform();
                    line.invalidateEndTransform();
                    line.adjustBounds();
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.adjustingBounds = false;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.adjustingBounds = false;
            return changed;
        }
    }

    void setAdjustingBounds(boolean adjust) {
        this.adjustingBounds = adjust;
    }

    public boolean isAdjustingBounds() {
        return this.adjustingBounds;
    }

    private static class PointIterator
    extends BendIterator {
        public PointIterator(ListIterator lineIter) {
            super(lineIter);
        }

        public PointIterator(ListIterator lineIter, int start) {
            super(lineIter, start);
        }

        public Object next() {
            JBend bend = (JBend)super.next();
            if (bend == null) {
                throw new NoSuchElementException();
            }
            return bend.getPoint();
        }

        public Object previous() {
            JBend bend = (JBend)super.previous();
            if (bend == null) {
                throw new NoSuchElementException();
            }
            return bend.getPoint();
        }
    }

    private static class BendIterator
    implements ListIterator {
        private ListIterator lineIterator = null;
        private LineSegment line = null;
        private boolean forward = true;
        private int nextIndex;

        public BendIterator(ListIterator lineIter) {
            this(lineIter, 0);
        }

        public BendIterator(ListIterator lineIter, int start) {
            this.lineIterator = lineIter;
            this.nextIndex = start;
        }

        public Object next() {
            JBend bend = null;
            if (this.line == null || this.nextIndex > 1 || !this.forward && this.lineIterator.hasNext()) {
                this.line = (LineSegment)this.lineIterator.next();
            }
            bend = this.nextIndex == 0 ? this.line.getStartBend() : this.line.getEndBend();
            ++this.nextIndex;
            this.forward = true;
            return bend;
        }

        public boolean hasNext() {
            return this.line != null && (this.nextIndex <= 1 || !this.forward) || this.lineIterator.hasNext();
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public Object previous() {
            JBend bend = null;
            if (this.nextIndex < 1) {
                throw new NoSuchElementException();
            }
            if (this.nextIndex == 1) {
                if (this.line == null) {
                    this.line = (LineSegment)this.lineIterator.next();
                }
                bend = this.line.getStartBend();
            } else {
                this.line = (LineSegment)this.lineIterator.previous();
                bend = this.line.getEndBend();
            }
            --this.nextIndex;
            this.forward = false;
            return bend;
        }

        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    public static class LineSegment
    extends JBendLine {
        private JPolyLine polyLine;

        LineSegment() {
            this((JBend)null, (JBend)null);
        }

        LineSegment(JBend start, JBend end) {
            super(start, end);
        }

        public Stroke getStroke() {
            JPolyLine pl;
            Stroke result = super.getStroke();
            if (result == null && (pl = this.polyLine) != null) {
                result = pl.getStroke();
            }
            return result;
        }

        boolean setPolyLine(JPolyLine value) {
            if (this.polyLine != value) {
                if (this.polyLine != null) {
                    JPolyLine oldValue = this.polyLine;
                    this.polyLine = null;
                    oldValue.removeFromLines(this);
                }
                this.polyLine = value;
                if (value != null && !value.hasInLines(this)) {
                    this.polyLine = null;
                    throw new RuntimeException("Cannot add Line to PolyLine in LineSegment.setPolyLine.\nPlease use JPolyLine.insertInLines instead");
                }
                return true;
            }
            return false;
        }

        public JPolyLine getPolyLine() {
            return this.polyLine;
        }

        boolean adjustBounds() {
            boolean changed = false;
            if (this.getStartBend() != null && this.getEndBend() != null) {
                Rectangle bounds = this.getPreferredBounds();
                if (this.polyLine != null && !this.polyLine.isAdjustingBounds()) {
                    this.polyLine.adjustBounds();
                    if (bounds.x >= 0 && bounds.y >= 0) {
                        changed = super.adjustBounds();
                    }
                } else {
                    changed = super.adjustBounds();
                }
            }
            return changed;
        }

        void invalidateCoeffs() {
            super.invalidateCoeffs();
            if (this.polyLine != null) {
                this.polyLine.invalidateCoeffs();
            }
        }

        public void removeYou() {
            this.setPolyLine(null);
            super.removeYou();
        }
    }
}

