/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.JCircle;
import java.awt.Color;
import java.awt.Graphics;

public class JOutlinedCircle
extends JCircle {
    private int innerRadius = 0;

    public int getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(int propValue) {
        if (propValue != this.innerRadius) {
            if ((propValue = Math.abs(propValue)) > this.getRadius()) {
                this.setRadius(propValue);
            }
            this.innerRadius = propValue;
        }
    }

    public JOutlinedCircle() {
    }

    public JOutlinedCircle(int radius) {
        super(radius);
    }

    public JOutlinedCircle(int outerRad, int innerRad) {
        this();
        int smaller = Math.min(Math.abs(outerRad), Math.abs(innerRad));
        int bigger = Math.max(Math.abs(outerRad), Math.abs(innerRad));
        this.setInnerRadius(smaller);
        this.setRadius(bigger);
        this.revalidate();
    }

    public void paintComponent(Graphics g) {
        Color oldColor = g.getColor();
        int smaller = Math.min(Math.abs(this.innerRadius), Math.abs(this.getRadius()));
        int bigger = Math.max(Math.abs(this.innerRadius), Math.abs(this.getRadius()));
        g.setColor(this.getBackground());
        g.fillArc(0, 0, bigger * 2, bigger * 2, 0, 360);
        g.setColor(this.getForeground());
        g.fillArc(bigger - smaller, bigger - smaller, smaller * 2, smaller * 2, 0, 360);
        g.drawArc(0, 0, bigger * 2, bigger * 2, 0, 360);
        g.setColor(oldColor);
    }
}

