/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.basic.AbstractListIterator;
import de.uni_paderborn.fujaba.fsa.swing.DecoratorLayout;
import de.uni_paderborn.fujaba.fsa.swing.DefaultLineUI;
import de.uni_paderborn.fujaba.fsa.swing.LineStyle;
import de.uni_paderborn.fujaba.fsa.swing.LineUI;
import java.awt.BasicStroke;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class JLine
extends JComponent {
    private Point startPoint = null;
    private Point endPoint = null;
    private boolean dashedFlag;
    private int thickness = 1;
    private double delta = 3.0;
    private double cx = 0.0;
    private double cy = 0.0;
    private double length = 0.0;
    private boolean coeffsDirty = true;
    private boolean boundsDirty = false;
    private Stroke stroke;

    public JLine() {
        this.setUI(DefaultLineUI.createUI(this));
        this.setLayout(new DecoratorLayout(true, false));
        this.setOpaque(false);
        this.startPoint = new Point(0, 0);
        this.endPoint = new Point(0, 0);
        this.linePointsChanged();
    }

    public JLine(Point start, Point end) {
        this();
        this.setStartPoint(start);
        this.setEndPoint(end);
    }

    public boolean isOptimizedDrawingEnabled() {
        return this.getComponentCount() <= 1;
    }

    public final Point getStartPoint() {
        return this.getStartPoint(null);
    }

    public Point getStartPoint(Point p) {
        if (p == null) {
            if (this.startPoint == null) {
                return null;
            }
            return new Point(this.startPoint);
        }
        p.x = this.startPoint.x;
        p.y = this.startPoint.y;
        return p;
    }

    public final void setStartPoint(Point point) {
        this.setStartPoint(point.x, point.y);
    }

    public boolean setStartPoint(int x, int y) {
        if (this.startPoint == null || this.startPoint.x != x || this.startPoint.y != y) {
            if (this.startPoint == null) {
                this.startPoint = new Point(x, y);
            } else {
                this.startPoint.x = x;
                this.startPoint.y = y;
            }
            this.linePointsChanged();
            this.repaint();
            return true;
        }
        return false;
    }

    public final Point getEndPoint() {
        return this.getEndPoint(null);
    }

    public Point getEndPoint(Point p) {
        if (p == null) {
            if (this.endPoint == null) {
                return null;
            }
            return new Point(this.endPoint);
        }
        p.x = this.endPoint.x;
        p.y = this.endPoint.y;
        return p;
    }

    public final void setEndPoint(Point point) {
        this.setEndPoint(point.x, point.y);
    }

    public boolean setEndPoint(int x, int y) {
        if (this.endPoint == null || this.endPoint.x != x || this.endPoint.y != y) {
            if (this.endPoint == null) {
                this.endPoint = new Point(x, y);
            } else {
                this.endPoint.x = x;
                this.endPoint.y = y;
            }
            this.linePointsChanged();
            this.repaint();
            return true;
        }
        return false;
    }

    public final boolean setPointAt(int index, Point p) {
        return this.setPointAt(index, p.x, p.y);
    }

    public boolean setPointAt(int index, int x, int y) {
        boolean changed = false;
        if (index == 0) {
            changed = this.setStartPoint(x, y);
        } else if (index == 1) {
            changed = this.setEndPoint(x, y);
        } else {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return changed;
    }

    public Point getFromPoints(int index) {
        if (index == 0) {
            return this.getStartPoint();
        }
        if (index == 1) {
            return this.getEndPoint();
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public ListIterator iteratorOfPoints(int start) {
        return new AbstractListIterator(start){

            protected Object get(int index) {
                return JLine.this.getFromPoints(index);
            }

            protected int size() {
                return JLine.this.sizeOfPoints();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                if (o == null) {
                    throw new IllegalArgumentException("Unable to set null-value");
                }
                if (this.currentIndex() < 0 || this.currentIndex() >= this.size()) {
                    throw new NoSuchElementException();
                }
                JLine.this.setPointAt(this.currentIndex(), (Point)o);
            }
        };
    }

    public final ListIterator iteratorOfPoints() {
        return this.iteratorOfPoints(0);
    }

    public final ListIterator iteratorOfPoints(Point pt) {
        return this.iteratorOfPoints(this.getIndexFromPoints(pt));
    }

    public int sizeOfPoints() {
        return 2;
    }

    public final Point getNextFromPoints(Point point) {
        return point == null ? null : this.getNextFromPoints(point.x, point.y);
    }

    public Point getNextFromPoints(int x, int y) {
        Point result = null;
        int index = this.getIndexFromPoints(x, y);
        if (index != -1 && index < this.sizeOfPoints() - 1) {
            result = this.getFromPoints(index + 1);
        }
        return result;
    }

    public final Point getPrevFromPoints(Point point) {
        return point == null ? null : this.getPrevFromPoints(point.x, point.y);
    }

    public Point getPrevFromPoints(int x, int y) {
        Point result = null;
        int index = this.getIndexFromPoints(x, y);
        if (index > 0) {
            result = this.getFromPoints(index - 1);
        }
        return result;
    }

    public final boolean hasInPoints(Point point) {
        if (point == null) {
            return false;
        }
        return this.hasInPoints(point.x, point.y);
    }

    public boolean hasInPoints(int x, int y) {
        return this.getIndexFromPoints(x, y) != -1;
    }

    public final int getIndexFromPoints(Point point) {
        if (point == null) {
            return -1;
        }
        return this.getIndexFromPoints(point.x, point.y);
    }

    public int getIndexFromPoints(int x, int y) {
        int index = -1;
        ListIterator pointIter = this.iteratorOfPoints();
        while (pointIter.hasNext()) {
            ++index;
            Point p = (Point)pointIter.next();
            if (p == null || p.x != x || p.y != y) continue;
            return index;
        }
        return -1;
    }

    public void setLineDashed(boolean dashed) {
        this.dashedFlag = dashed;
        if (dashed) {
            BasicStroke defaultStroke = LineStyle.DASHED;
            BasicStroke stroke = new BasicStroke(this.thickness, defaultStroke.getEndCap(), defaultStroke.getLineJoin(), defaultStroke.getMiterLimit(), defaultStroke.getDashArray(), defaultStroke.getDashPhase());
            this.setStroke(stroke);
        } else {
            this.setStroke(new BasicStroke(this.thickness));
        }
    }

    public boolean isLineDashed() {
        return this.dashedFlag;
    }

    public void setThickness(int newThickness) {
        BasicStroke stroke;
        this.thickness = newThickness;
        if (this.thickness < 0) {
            this.thickness = 0;
        }
        if (this.getStroke() != null) {
            BasicStroke defaultStroke = (BasicStroke)this.getStroke();
            stroke = new BasicStroke(this.thickness, defaultStroke.getEndCap(), defaultStroke.getLineJoin(), defaultStroke.getMiterLimit(), defaultStroke.getDashArray(), defaultStroke.getDashPhase());
        } else {
            stroke = new BasicStroke(this.thickness);
        }
        this.setStroke(stroke);
    }

    public int getThickness() {
        return this.thickness;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        if (this.delta != (delta = Math.abs(delta))) {
            this.delta = delta;
            this.linePointsChanged();
        }
    }

    void computeCoeffs() {
        Point start = this.getStartPoint();
        Point end = this.getEndPoint();
        int dx = end.x - start.x;
        int dy = end.y - start.y;
        int div = dx * dx + dy * dy;
        this.cx = (double)dx / (double)div;
        this.cy = (double)dy / (double)div;
        this.length = Math.sqrt(div);
        this.coeffsDirty = false;
    }

    void invalidateCoeffs() {
        this.coeffsDirty = true;
    }

    boolean isCoeffsDirty() {
        return this.coeffsDirty;
    }

    protected double getCx() {
        if (this.coeffsDirty) {
            this.computeCoeffs();
        }
        return this.cx;
    }

    protected double getCy() {
        if (this.coeffsDirty) {
            this.computeCoeffs();
        }
        return this.cy;
    }

    public double getStartToEndDistance() {
        if (this.coeffsDirty) {
            this.computeCoeffs();
        }
        return this.length;
    }

    public double getLength() {
        return this.getStartToEndDistance();
    }

    public final Point2D getDirection(double d) {
        return this.getDirection(d, null);
    }

    public Point2D getDirection(double d, Point2D p) {
        return this.getDirection(p);
    }

    public Point2D getDirection() {
        return this.getDirection(null);
    }

    public Point2D getDirection(Point2D p) {
        double len;
        if (p == null) {
            p = new Point2D.Double();
        }
        Point start = this.getStartPoint();
        Point end = this.getEndPoint();
        if (this.coeffsDirty) {
            this.computeCoeffs();
        }
        if ((len = this.getStartToEndDistance()) != 0.0) {
            p.setLocation((double)(end.x - start.x) / len, (double)(end.y - start.y) / len);
        } else {
            p.setLocation(1.0, 0.0);
        }
        return p;
    }

    public final Point2D getNormal(double d) {
        return this.getNormal(d, null);
    }

    public Point2D getNormal(double d, Point2D p) {
        return this.getNormal(p);
    }

    public Point2D getNormal() {
        return this.getNormal(null);
    }

    public Point2D getNormal(Point2D p) {
        if (p == null) {
            p = new Point2D.Double();
        }
        p = this.getDirection(p);
        double x = p.getX();
        double y = p.getY();
        p.setLocation(-y, x);
        return p;
    }

    public double getAngle(double d) {
        return this.getAngle();
    }

    public double getAngle() {
        double result;
        Point start = this.getStartPoint();
        Point end = this.getEndPoint();
        int dx = end.x - start.x;
        int dy = end.y - start.y;
        if (dx == 0) {
            result = dy >= 0 ? 1.5707963267948966 : 4.71238898038469;
        } else {
            result = Math.atan((double)dy / (double)dx);
            if (dx < 0) {
                result += Math.PI;
            } else if (result < 0.0) {
                result += Math.PI * 2;
            }
        }
        return result;
    }

    public final double getPosition(Point p) {
        return this.getPosition(p.x, p.y);
    }

    public double getPosition(int x, int y) {
        Point startPoint = this.getStartPoint();
        Point endPoint = this.getEndPoint();
        double cx = this.getCx();
        double cy = this.getCy();
        double dx = x - startPoint.x;
        double dy = y - startPoint.y;
        double s = startPoint.x != endPoint.x ? dx * cx + dy * cy : (startPoint.y != endPoint.y ? dx * cx - dy * cy : 0.0);
        return s;
    }

    public Point2D getPointAt(double d) {
        Point start = this.getStartPoint();
        Point end = this.getEndPoint();
        return new Point2D.Double((double)start.x + d * (double)(end.x - start.x), (double)start.y + d * (double)(end.y - start.y));
    }

    void linePointsChanged() {
        this.boundsDirty = true;
        this.revalidate();
    }

    boolean adjustBounds() {
        Rectangle bounds = this.getPreferredBounds();
        Rectangle oldBounds = this.getBounds();
        if (!oldBounds.equals(bounds)) {
            this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            this.revalidate();
            if (this.boundsDirty) {
                this.repaint();
            }
        }
        boolean oldDirty = this.boundsDirty;
        this.boundsDirty = false;
        return oldDirty ^ this.boundsDirty;
    }

    public void doLayout() {
        if (this.boundsDirty) {
            boolean done = this.adjustBounds();
            if (done) {
                super.doLayout();
            }
        } else {
            super.doLayout();
        }
    }

    public Rectangle getPreferredBounds() {
        return ((LineUI)this.ui).getPreferredBounds(this);
    }

    public void setBounds(int x, int y, int w, int h) {
        Rectangle bounds = this.getBounds();
        if (bounds.x != x || bounds.y != y || bounds.width != w || bounds.height != h) {
            this.invalidateCoeffs();
            super.setBounds(x, y, w, h);
        }
    }

    public Dimension getPreferredSize() {
        return this.getPreferredBounds().getSize();
    }

    public boolean contains(int x, int y) {
        return super.contains(x, y) && this.getDistance(x + this.getX(), y + this.getY()) < this.getDelta();
    }

    public final boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public final double getDistance(Point p) {
        return this.getDistance(p.x, p.y);
    }

    public double getDistance(int x, int y) {
        Point startPoint = this.getStartPoint();
        Point endPoint = this.getEndPoint();
        double cx = this.getCx();
        double cy = this.getCy();
        double dx = x - startPoint.x;
        double dy = y - startPoint.y;
        if (startPoint.x != endPoint.x) {
            double s = dx * cx + dy * cy;
            if (s < 0.0) {
                return startPoint.distance(x, y);
            }
            if (s > 1.0) {
                return endPoint.distance(x, y);
            }
            double t = dy * cx - dx * cy;
            return Math.abs(t * this.getStartToEndDistance());
        }
        if (startPoint.y != endPoint.y) {
            double s = dy * cy - dx * cx;
            if (s < 0.0) {
                return startPoint.distance(x, y);
            }
            if (s > 1.0) {
                return endPoint.distance(x, y);
            }
            double t = dx * cy - dy * cx;
            return Math.abs(t * this.getStartToEndDistance());
        }
        return startPoint.distance(x, y);
    }

    public void setUI(ComponentUI ui) {
        super.setUI(ui);
    }

    public LineUI getUI() {
        return (LineUI)this.ui;
    }

    public void setStroke(Stroke value) {
        if (this.stroke != value) {
            this.stroke = value;
            this.repaint();
        }
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public String toString() {
        String result = String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode()) + "\n";
        result = String.valueOf(result) + "\tBounds: " + this.getBounds() + "\n";
        result = String.valueOf(result) + "\tPoints: [" + this.getStartPoint().x + ":" + this.getStartPoint().y + "],[" + this.getEndPoint().x + ":" + this.getEndPoint().y + "]";
        return result;
    }

    public void removeYou() {
        Container parent = this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
        this.invalidateCoeffs();
    }
}

