/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.fsa.FSALayeredPane;
import de.uni_paderborn.fujaba.fsa.swing.JLine;
import de.uni_paderborn.lib.basic.ImageResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;

public class JEgg
extends JComponent
implements Runnable {
    private static int instanceCount = 0;
    private static ImageIcon[][] icons;
    private static ImageIcon deadIcon;
    private static int width;
    private static int height;
    private int direction = 0;
    private int directionDelta = 1;
    private int moveState = 0;
    private static final int[] DIRECTION_X_DIFF;
    private static final int[] DIRECTION_Y_DIFF;
    boolean alive = true;
    private static final int NOT_CONCEALED = 0;
    private static final int CONCEALED = 1;
    private static final int COLLISION_WITH_JEGG = 2;

    static {
        width = 0;
        height = 0;
        DIRECTION_X_DIFF = new int[]{5, 10, 10, 5, -5, -10, -10, -5};
        DIRECTION_Y_DIFF = new int[]{-10, -5, 5, 10, 10, 5, -5, -10};
    }

    private JEgg() {
        this.getIcons();
        this.setSize(width, height);
        this.addMouseListener(new EggDeathMouseListener());
        this.direction = (int)(Math.random() * 8.0);
        this.moveState = (int)(Math.random() * 3.0);
        if (Math.random() < 0.5) {
            this.directionDelta = -this.directionDelta;
        }
    }

    private void getIcons() {
        if (icons == null) {
            ImageIcon[][] myIcons = new ImageIcon[8][3];
            ImageResourceManager manager = ImageResourceManager.get();
            int i = 0;
            while (i < 8) {
                int k = 0;
                while (k < 3) {
                    URL url = ClassLoader.getSystemClassLoader().getResource("de/uni_paderborn/fujaba/app/images/jegg-" + i + "-" + k + ".gif");
                    if (url != null) {
                        myIcons[i][k] = manager.getImageIcon(url);
                        if (myIcons[i][k] != null) {
                            if (width < myIcons[i][k].getIconWidth()) {
                                width = myIcons[i][k].getIconWidth();
                            }
                            if (height < myIcons[i][k].getIconHeight()) {
                                height = myIcons[i][k].getIconHeight();
                            }
                        }
                    }
                    if (myIcons[i][k] == null) {
                        throw new RuntimeException("Could not find egg icon " + i + "-" + k);
                    }
                    ++k;
                }
                ++i;
            }
            URL url = ClassLoader.getSystemClassLoader().getResource("de/uni_paderborn/fujaba/app/images/jegg-x-x.gif");
            if (url != null) {
                deadIcon = manager.getImageIcon(url);
            }
            if (deadIcon == null) {
                throw new RuntimeException("Could not find egg icon x-x");
            }
            icons = myIcons;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(width, height);
    }

    public void paintComponent(Graphics g) {
        if (this.alive) {
            icons[this.direction][Math.abs(this.moveState)].paintIcon(this, g, 0, 0);
        } else {
            deadIcon.paintIcon(this, g, 0, 0);
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Container container = this.getParent();
        synchronized (container) {
            ++instanceCount;
        }
        Cursor oldCursor = this.getCursor();
        this.setCursor(new Cursor(1));
        while (this.alive) {
            int concealed;
            try {
                Thread.sleep(80L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.moveState;
            if (this.moveState < 0) {
                this.moveState = 2;
            }
            if ((concealed = this.isConcealed()) == 1 || concealed == 2 || Math.random() < 0.05) {
                this.changeDirection();
                continue;
            }
            int newX = this.getX() + DIRECTION_X_DIFF[this.direction];
            int newY = this.getY() + DIRECTION_Y_DIFF[this.direction];
            if (newX < 0 || newX + this.getWidth() > this.getContainerWidth() || newY < 0 || newY + this.getHeight() > this.getContainerHeight()) {
                this.changeDirection();
                continue;
            }
            this.setLocation(newX, newY);
        }
        this.setCursor(oldCursor);
        this.toBack();
        this.repaint();
        Container container2 = this.getParent();
        synchronized (container2) {
            if (--instanceCount == 0) {
                JOptionPane.showMessageDialog(this.getParent(), "Your diagram is bug free", "Congratulations!", 1);
            }
        }
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeYou();
    }

    private int getContainerWidth() {
        Container parent = this.getParent();
        if (parent != null) {
            return parent.getWidth();
        }
        return -1;
    }

    private int getContainerHeight() {
        Container parent = this.getParent();
        if (parent != null) {
            return parent.getHeight();
        }
        return -1;
    }

    private int isConcealed() {
        Container parent = this.getParent();
        if (parent != null) {
            Component component = parent.getComponentAt(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2);
            if (component instanceof JEgg && component != this && ((JEgg)component).isAlive()) {
                return 2;
            }
            if (component != parent && component != this && component != null && !(component instanceof JLine)) {
                if (component.getX() <= this.getX() && component.getY() <= this.getY() && component.getX() + component.getWidth() > this.getX() + this.getWidth() && component.getY() + component.getHeight() > this.getY() + this.getHeight()) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    private void changeDirection() {
        int newDirection;
        if (Math.random() < 0.3) {
            this.directionDelta = -this.directionDelta;
        }
        if ((newDirection = (this.direction + this.directionDelta) % 8) < 0) {
            newDirection += 8;
        }
        this.direction = newDirection;
        this.repaint();
    }

    private void removeYou() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
            c.repaint();
        }
    }

    private void toBack() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
            c.add(this);
        }
    }

    public static void start() {
        FSALayeredPane fsaPane = FrameMain.get().getCurrentInternalFrame().getDiagramRoot();
        if (fsaPane != null) {
            JLayeredPane pane = (JLayeredPane)fsaPane.getJComponent();
            int i = 0;
            while (i < 10) {
                JEgg jegg = new JEgg();
                pane.add(jegg);
                jegg.setLocation((int)(Math.random() * (double)(pane.getWidth() - jegg.getWidth())), (int)(Math.random() * (double)(pane.getHeight() - jegg.getHeight())));
                new Thread(jegg).start();
                ++i;
            }
        }
    }

    public static class EggMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 3) {
                JEgg.start();
            }
        }
    }

    private class EggDeathMouseListener
    extends MouseAdapter {
        EggDeathMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            JEgg.this.alive = false;
        }
    }
}

