/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.JTriangleHead;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class JDirectionIndicator
extends JTriangleHead
implements PropertyChangeListener {
    private JComponent source = null;
    private JComponent target = null;

    public JDirectionIndicator() {
        super(7, 7, true);
    }

    public JDirectionIndicator(JComponent target, JComponent source) {
        this();
        this.setTarget(target);
        this.setSource(source);
    }

    public void setTarget(JComponent target) {
        if (this.target != target) {
            if (this.target != null) {
                this.target.removePropertyChangeListener("bounds", this);
            }
            this.target = target;
            if (target != null) {
                target.addPropertyChangeListener("bounds", this);
                this.propertyChange(null);
            }
        }
    }

    public void setSource(JComponent source) {
        if (this.source != source) {
            if (this.source != null) {
                this.source.removePropertyChangeListener("bounds", this);
            }
            this.source = source;
            if (source != null) {
                source.addPropertyChangeListener("bounds", this);
                this.propertyChange(null);
            }
        }
    }

    public JComponent getTarget() {
        return this.target;
    }

    public JComponent getSource() {
        return this.source;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (this.target == null || this.source == null) {
            return;
        }
        int targetX = this.target.getX();
        int targetY = this.target.getY();
        int width = this.target.getWidth();
        int height = this.target.getHeight();
        float m = 0.5f;
        if (width != 0) {
            m = (float)height / (float)width;
        }
        int b1 = targetY - (int)(m * (float)targetX);
        int b2 = targetY + (int)(m * (float)(targetX + width));
        int parentX = this.source.getX() + this.source.getWidth() / 2;
        int parentY = this.source.getY() + this.source.getHeight() / 2;
        int line1Y = (int)(m * (float)parentX + (float)b1);
        int line2Y = (int)(-m * (float)parentX + (float)b2);
        if (parentY > line1Y) {
            if (parentY > line2Y) {
                this.setDirection(Direction.TOP);
            } else {
                this.setDirection(Direction.RIGHT);
            }
        } else if (parentY < line2Y) {
            this.setDirection(Direction.BOTTOM);
        } else {
            this.setDirection(Direction.LEFT);
        }
        this.revalidate();
    }

    public void reshape(int x, int y, int width, int height) {
        Rectangle bounds = this.getBounds();
        if (x != bounds.x || y != bounds.y || width != bounds.width || height != bounds.height) {
            super.reshape(x, y, width, height);
            if (x != bounds.x || y != bounds.y) {
                this.firePropertyChange("location", bounds.getLocation(), new Point(x, y));
            }
            if (width != bounds.width || height != bounds.height) {
                this.firePropertyChange("size", bounds.getSize(), new Dimension(width, height));
            }
            this.firePropertyChange("bounds", bounds, new Rectangle(x, y, width, height));
        }
    }
}

