/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.uni_paderborn.fujaba.fsa.listener.CollapsableMouseListener;
import de.uni_paderborn.fujaba.fsa.swing.ColumnRowLayout;
import de.uni_paderborn.fujaba.fsa.swing.SortedLayout;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class JCollapsable
extends JScrollPane {
    private static int COLLAPSABLE_WIDTH = 150;
    private static int COLLAPSABLE_HEIGHT = 60;
    private Dimension minSize = null;
    private JPanel viewPanel = new JPanel();
    private int insetWidth = 0;
    private boolean collapsed = false;

    public JCollapsable() {
        this.viewPanel.setLayout(new ColumnRowLayout(0, 1));
        this.setViewportView(this.viewPanel);
        this.setBorder(null);
        JScrollBar bar = this.getHorizontalScrollBar();
        Dimension dim = bar.getPreferredSize();
        dim.height = 9;
        bar.setPreferredSize(dim);
        JScrollBar bar2 = this.getVerticalScrollBar();
        dim = bar.getPreferredSize();
        dim.width = 9;
        bar2.setPreferredSize(dim);
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(30);
        AscendDescendMouseHandler.addMouseListener(this, CollapsableMouseListener.get());
        AscendDescendMouseHandler.registerADMouseInputHandler(this);
    }

    public Comparator getLayoutComparator() {
        LayoutManager layout;
        Comparator result = null;
        LayoutManager layoutManager = layout = this.viewPanel == null ? null : this.viewPanel.getLayout();
        if (layout instanceof SortedLayout) {
            result = ((SortedLayout)layout).getComparator();
        }
        return result;
    }

    public void setLayoutComparator(Comparator comp) {
        LayoutManager layout;
        LayoutManager layoutManager = layout = this.viewPanel == null ? null : this.viewPanel.getLayout();
        if (!(layout instanceof SortedLayout)) {
            throw new IllegalStateException("LayoutManager is no SortedLayout");
        }
        ((SortedLayout)layout).setComparator(comp);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.viewPanel != null) {
            this.viewPanel.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.viewPanel != null) {
            this.viewPanel.setForeground(color);
        }
    }

    public void setLayout(LayoutManager layout) {
        if (this.viewPanel == null) {
            super.setLayout(layout);
        } else {
            this.viewPanel.setLayout(layout);
        }
    }

    public int getInsetWidth() {
        return this.insetWidth;
    }

    public void setInsetWidth(int value) {
        if (this.insetWidth != value) {
            this.insetWidth = value;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        Rectangle bounds = this.getBounds();
        int x = bounds.width - 9 - this.getInsetWidth();
        int y = bounds.height - 9;
        int width = 9;
        int height = 9;
        Color oldColor = g.getColor();
        g.setColor(FSAObject.COLOR_BACKGROUND);
        g.fill3DRect(x, y, width, height, true);
        g.setColor(ColorsPreferences.get().COLLAPSE_ANCHOR);
        g.draw3DRect(x, y, width, height, true);
        int[] xCoordsCollapse = new int[]{x + 2, x + 6};
        int[] yCoordsCollapse = new int[]{y + 4, y + 4};
        g.drawPolygon(xCoordsCollapse, yCoordsCollapse, 2);
        if (this.isCollapsed()) {
            int[] xCoordsCollapse2 = new int[]{x + 4, x + 4};
            int[] yCoordsCollapse2 = new int[]{y + 2, y + 6};
            g.drawPolygon(xCoordsCollapse2, yCoordsCollapse2, 2);
            String collapsed = "collapsed";
            Font currentFont = g.getFont();
            Font italicFont = currentFont.deriveFont(2);
            g.setColor(Color.BLACK);
            g.setFont(italicFont);
            Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(collapsed, g);
            g.drawString(collapsed, (int)(((double)bounds.width - stringBounds.getWidth()) / 2.0), (int)((double)(bounds.height / 2) + stringBounds.getHeight() / 2.0));
            g.setFont(currentFont);
        }
        g.setColor(oldColor);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        if (this.collapsed != collapsed) {
            boolean oldValue = this.collapsed;
            this.collapsed = collapsed;
            this.firePropertyChange("collapsed", oldValue, collapsed);
            this.viewPanel.setVisible(!collapsed);
            this.getViewport().setVisible(!collapsed);
            if (collapsed) {
                this.setHorizontalScrollBarPolicy(31);
                this.setVerticalScrollBarPolicy(21);
            } else {
                this.setHorizontalScrollBarPolicy(30);
                this.setVerticalScrollBarPolicy(20);
            }
        }
    }

    public void toggleCollapsed() {
        this.setCollapsed(!this.isCollapsed());
    }

    public Component add(Component comp) {
        if (this.viewPanel == null) {
            return super.add(comp);
        }
        return this.viewPanel.add(comp);
    }

    public Component add(String name, Component comp) {
        if (this.viewPanel == null) {
            return super.add(name, comp);
        }
        return this.viewPanel.add(name, comp);
    }

    public Component add(Component comp, int index) {
        if (this.viewPanel == null) {
            return super.add(comp, index);
        }
        return this.viewPanel.add(comp, index);
    }

    public void add(Component comp, Object constraints) {
        if (this.viewPanel == null) {
            super.add(comp, constraints);
        } else {
            this.viewPanel.add(comp, constraints);
        }
    }

    public void add(Component comp, Object constraints, int index) {
        if (this.viewPanel == null) {
            super.add(comp, constraints, index);
        } else {
            this.viewPanel.add(comp, constraints, index);
        }
    }

    public void addImpl(Component comp, Object constraints, int index) {
        if (this.viewPanel == null) {
            super.addImpl(comp, constraints, index);
        } else {
            this.viewPanel.add(comp, constraints, index);
        }
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (this.viewPanel != null) {
            result = (Dimension)this.viewPanel.getPreferredSize().clone();
            result.width += 12;
        }
        if (this.isCollapsed()) {
            result.height = 15;
            result.width = 9;
        }
        return result;
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension();
        }
        this.minSize.width = COLLAPSABLE_WIDTH;
        this.minSize.height = COLLAPSABLE_HEIGHT;
        Dimension maxDim = this.getMaximumSize();
        this.minSize.width = Math.min(this.minSize.width, maxDim.width);
        this.minSize.height = Math.min(this.minSize.height, maxDim.height);
        if (this.isCollapsed()) {
            this.minSize.height = 15;
            this.minSize.width = 9;
        }
        return this.minSize;
    }

    public Dimension getMaximumSize() {
        Dimension tmpDim = null;
        tmpDim = this.isCollapsed() ? this.getPreferredSize() : this.viewPanel.getPreferredSize();
        return tmpDim;
    }
}

