/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.basic.AbstractListIterator;
import de.uni_paderborn.fujaba.fsa.listener.AncestorNotifier;
import de.uni_paderborn.fujaba.fsa.swing.GrabManager;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import de.uni_paderborn.fujaba.fsa.swing.JLine;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;

public class JBendLine
extends JLine
implements PropertyChangeListener {
    private AncestorManager ancestorListener = null;
    private JBend startBend;
    private JBend endBend;
    Point startTransform = null;
    Point endTransform = null;

    public JBendLine() {
        this(new Point(0, 0), new Point(0, 0));
    }

    public JBendLine(Point start, Point end) {
        this(new JBend(start), new JBend(end));
    }

    public JBendLine(JBend start, JBend end) {
        this.setOpaque(false);
        this.setStartBend(start);
        this.setEndBend(end);
    }

    public AncestorManager getAncestorListener() {
        if (this.ancestorListener == null) {
            this.ancestorListener = new AncestorManager();
            this.addHierarchyListener(this.ancestorListener);
            this.addHierarchyBoundsListener(this.ancestorListener);
        }
        return this.ancestorListener;
    }

    public boolean setStartBend(JBend value) {
        if (this.startBend != value) {
            if (this.startBend != null) {
                JBend oldValue = this.startBend;
                this.startBend = null;
                this.unregisterStartBend(oldValue);
            }
            this.startBend = value;
            if (value != null) {
                this.registerStartBend(value);
                this.getAncestorListener().invalidate();
                this.invalidateStartTransform();
                this.setStartPointFromBend(value.getPoint());
            }
            return true;
        }
        return false;
    }

    protected void registerStartBend(JBend bend) {
        bend.addToOutgoingLines(this);
        bend.addPropertyChangeListener("point", this);
        bend.addHierarchyListener(this.getAncestorListener());
        bend.addHierarchyBoundsListener(this.getAncestorListener());
    }

    protected void unregisterStartBend(JBend bend) {
        bend.removePropertyChangeListener("point", this);
        bend.removeHierarchyListener(this.getAncestorListener());
        bend.removeHierarchyBoundsListener(this.getAncestorListener());
        bend.removeFromOutgoingLines(this);
    }

    public JBend getStartBend() {
        return this.startBend;
    }

    public boolean setEndBend(JBend value) {
        if (this.endBend != value) {
            if (this.endBend != null) {
                JBend oldValue = this.endBend;
                this.endBend = null;
                this.unregisterEndBend(oldValue);
            }
            this.endBend = value;
            if (value != null) {
                this.registerEndBend(value);
                this.getAncestorListener().invalidate();
                this.invalidateEndTransform();
                this.setEndPointFromBend(this.endBend.getPoint());
            }
            return true;
        }
        return false;
    }

    protected void registerEndBend(JBend bend) {
        bend.addToIncomingLines(this);
        bend.addPropertyChangeListener("point", this);
        bend.addHierarchyListener(this.getAncestorListener());
        bend.addHierarchyBoundsListener(this.getAncestorListener());
    }

    protected void unregisterEndBend(JBend bend) {
        bend.removePropertyChangeListener("point", this);
        bend.removeHierarchyListener(this.getAncestorListener());
        bend.removeHierarchyBoundsListener(this.getAncestorListener());
        bend.removeFromIncomingLines(this);
    }

    public JBend getEndBend() {
        return this.endBend;
    }

    public boolean setBendAt(int index, JBend bend) {
        boolean changed = false;
        if (index == 0) {
            changed = this.setStartBend(bend);
        } else if (index == 1) {
            changed = this.setEndBend(bend);
        } else {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return changed;
    }

    public JBend getFromBends(int index) {
        if (index == 0) {
            return this.getStartBend();
        }
        if (index == 1) {
            return this.getEndBend();
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public final ListIterator iteratorOfBends() {
        return this.iteratorOfBends(0);
    }

    public final ListIterator iteratorOfBends(JBend bend) {
        return this.iteratorOfBends(this.getIndexFromBends(bend));
    }

    public ListIterator iteratorOfBends(int start) {
        return new BendIterator(start);
    }

    public int sizeOfBends() {
        return 2;
    }

    public boolean hasInBends(JBend bend) {
        if (bend == null) {
            return false;
        }
        return this.getIndexFromBends(bend) > -1;
    }

    public int getIndexFromBends(JBend bend) {
        int index = -1;
        ListIterator bendIter = this.iteratorOfBends();
        while (bendIter.hasNext()) {
            ++index;
            if (bend != bendIter.next()) continue;
            return index;
        }
        return -1;
    }

    public JBend getNextFromBends(JBend bend) {
        int index;
        JBend result = null;
        if (bend != null && (index = this.getIndexFromBends(bend)) > -1 && index < this.sizeOfBends() - 1) {
            result = this.getFromBends(index + 1);
        }
        return result;
    }

    public JBend getPrevFromBends(JBend bend) {
        int index;
        JBend result = null;
        if (bend != null && (index = this.getIndexFromBends(bend)) > 0) {
            result = this.getFromBends(index - 1);
        }
        return result;
    }

    public JBend getOtherBend(JBend bend) {
        JBend startBend = this.getStartBend();
        JBend endBend = this.getEndBend();
        if (bend == startBend) {
            return endBend;
        }
        if (bend == endBend) {
            return startBend;
        }
        return null;
    }

    public boolean setStartPoint(int x, int y) {
        Point startPoint = this.getStartPoint();
        if (x != startPoint.x || y != startPoint.y) {
            super.setStartPoint(x, y);
            JBend bend = this.getStartBend();
            if (bend != null) {
                Point transform = this.getStartTransform();
                bend.setPoint(x - transform.x, y - this.startTransform.y);
            }
            this.startPointChanged();
            return true;
        }
        return false;
    }

    private final void setStartPointFromBend(Point p) {
        this.setStartPointFromBend(p.x, p.y);
    }

    private void setStartPointFromBend(int x, int y) {
        Point transform = this.getStartTransform();
        this.setStartPoint(x + transform.x, y + transform.y);
    }

    protected void startPointChanged() {
        JGrab grab;
        GrabManager manager;
        JBend bend = this.getEndBend();
        if (bend != null && bend instanceof JGrab && (manager = (grab = (JGrab)bend).getManager()) != null) {
            manager.revalidate();
        }
    }

    protected void invalidateStartTransform() {
        this.startTransform = null;
    }

    protected Point getStartTransform() {
        if (this.startTransform == null) {
            if (this.startBend == null) {
                this.startTransform = new Point(0, 0);
            } else {
                Container bendParent = this.startBend.getParent();
                Container lineParent = this.getParent();
                this.startTransform = bendParent == null || lineParent == null ? new Point(0, 0) : SwingUtilities.convertPoint(bendParent, 0, 0, lineParent);
            }
        }
        return this.startTransform;
    }

    private void calculateStartPoint() {
        this.setStartPointFromBend(this.getStartBend().getPoint());
    }

    public Point getStartPoint(Point p) {
        if (this.startTransform == null && this.getStartBend() != null) {
            this.calculateStartPoint();
        }
        return super.getStartPoint(p);
    }

    public boolean setEndPoint(int x, int y) {
        Point endPoint = this.getEndPoint();
        if (x != endPoint.x || y != endPoint.y) {
            super.setEndPoint(x, y);
            JBend bend = this.getEndBend();
            if (bend != null) {
                Point transform = this.getEndTransform();
                bend.setPoint(x - transform.x, y - this.endTransform.y);
            }
            this.endPointChanged();
            return true;
        }
        return false;
    }

    protected void endPointChanged() {
        JGrab grab;
        GrabManager manager;
        JBend bend = this.getStartBend();
        if (bend != null && bend instanceof JGrab && (manager = (grab = (JGrab)bend).getManager()) != null) {
            manager.revalidate();
        }
    }

    protected void invalidateEndTransform() {
        this.endTransform = null;
    }

    protected Point getEndTransform() {
        if (this.endTransform == null) {
            if (this.endBend == null) {
                this.endTransform = new Point(0, 0);
            } else {
                Container bendParent = this.endBend.getParent();
                Container lineParent = this.getParent();
                this.endTransform = bendParent == null || lineParent == null ? new Point(0, 0) : SwingUtilities.convertPoint(bendParent, 0, 0, lineParent);
            }
        }
        return this.endTransform;
    }

    private final void setEndPointFromBend(Point p) {
        this.setEndPointFromBend(p.x, p.y);
    }

    private void setEndPointFromBend(int x, int y) {
        Point transform = this.getEndTransform();
        this.setEndPoint(x + transform.x, y + transform.y);
    }

    private void calculateEndPoint() {
        this.setEndPointFromBend(this.getEndBend().getPoint());
    }

    public Point getEndPoint(Point p) {
        if (this.endTransform == null && this.getEndBend() != null) {
            this.calculateEndPoint();
        }
        return super.getEndPoint(p);
    }

    public boolean contains(int x, int y) {
        if (super.contains(x, y)) {
            int tmpY;
            int tmpX;
            Point transform;
            boolean result = true;
            if (this.startBend != null) {
                transform = this.getStartTransform();
                tmpX = x + this.getX() - transform.x - this.startBend.getX();
                boolean bl = result = !this.startBend.contains(tmpX, tmpY = y + this.getY() - transform.y - this.startBend.getY());
            }
            if (result && this.endBend != null) {
                transform = this.getEndTransform();
                tmpX = x + this.getX() - transform.x - this.endBend.getX();
                result = !this.endBend.contains(tmpX, tmpY = y + this.getY() - transform.y - this.endBend.getY());
            }
            return result;
        }
        return false;
    }

    public void removeYou() {
        this.setStartBend(null);
        this.setEndBend(null);
        if (this.getClientProperty(AncestorNotifier.KEY) != null && this.getClientProperty(AncestorNotifier.KEY) instanceof AncestorNotifier) {
            ((AncestorNotifier)this.getClientProperty(AncestorNotifier.KEY)).removeYou();
            this.putClientProperty(AncestorNotifier.KEY, null);
        }
        super.removeYou();
    }

    public void propertyChange(PropertyChangeEvent e) {
        Point newPoint = (Point)e.getNewValue();
        if (e.getSource() == this.startBend) {
            this.setStartPointFromBend(newPoint);
        } else {
            this.setEndPointFromBend(newPoint);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Container getClosestCommonAncestor(Container c1, Container c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        if (c1 == c2) {
            return c1;
        }
        if (!SwingUtilities.isDescendingFrom(c2, c1)) ** GOTO lbl8
        return c1;
lbl-1000:
        // 1 sources

        {
            c2 = c2.getParent();
lbl8:
            // 2 sources

            ** while (!SwingUtilities.isDescendingFrom((Component)c1, (Component)c2) && c2 != null)
        }
lbl9:
        // 1 sources

        return c2;
    }

    private class AncestorManager
    implements HierarchyListener,
    HierarchyBoundsListener {
        private Container closestCommonAncestorStart = null;
        private Container closestCommonAncestorEnd = null;

        AncestorManager() {
        }

        public void invalidate() {
            this.closestCommonAncestorStart = null;
            this.closestCommonAncestorEnd = null;
        }

        public void hierarchyChanged(HierarchyEvent e) {
            long flags = e.getChangeFlags();
            if ((flags & 1L) != 0L) {
                Object source = e.getSource();
                Container parent = e.getChangedParent();
                if (e.getChanged().getParent() == null) {
                    if (this.closestCommonAncestorStart != null && (source == JBendLine.this.getStartBend() || source == JBendLine.this) && SwingUtilities.isDescendingFrom(parent, this.closestCommonAncestorStart)) {
                        this.closestCommonAncestorStart = null;
                    }
                    if (this.closestCommonAncestorEnd != null && (source == JBendLine.this.getEndBend() || source == JBendLine.this) && SwingUtilities.isDescendingFrom(parent, this.closestCommonAncestorEnd)) {
                        this.closestCommonAncestorEnd = null;
                    }
                } else if (source == JBendLine.this.getStartBend()) {
                    if (this.closestCommonAncestorStart == null) {
                        this.closestCommonAncestorStart = JBendLine.getClosestCommonAncestor(JBendLine.this, parent);
                        if (this.closestCommonAncestorStart != null) {
                            JBendLine.this.invalidateStartTransform();
                        }
                    }
                } else if (source == JBendLine.this.getEndBend()) {
                    if (this.closestCommonAncestorEnd == null) {
                        this.closestCommonAncestorEnd = JBendLine.getClosestCommonAncestor(JBendLine.this, parent);
                        if (this.closestCommonAncestorEnd != null) {
                            JBendLine.this.invalidateEndTransform();
                        }
                    }
                } else if (source == JBendLine.this) {
                    if (this.closestCommonAncestorStart == null) {
                        this.closestCommonAncestorStart = JBendLine.getClosestCommonAncestor(parent, JBendLine.this.getStartBend());
                        if (this.closestCommonAncestorStart != null) {
                            JBendLine.this.invalidateStartTransform();
                        }
                    }
                    if (this.closestCommonAncestorEnd == null) {
                        this.closestCommonAncestorStart = JBendLine.getClosestCommonAncestor(parent, JBendLine.this.getEndBend());
                        if (this.closestCommonAncestorEnd != null) {
                            JBendLine.this.invalidateEndTransform();
                        }
                    }
                }
            }
        }

        public void ancestorMoved(HierarchyEvent e) {
            Object source = e.getSource();
            Component changed = e.getChanged();
            if (changed == source) {
                return;
            }
            if ((source == JBendLine.this.getStartBend() || source == JBendLine.this) && this.closestCommonAncestorStart != null && JBendLine.this.startTransform != null && SwingUtilities.isDescendingFrom(changed, this.closestCommonAncestorStart)) {
                JBendLine.this.invalidateStartTransform();
            }
            if ((source == JBendLine.this.getEndBend() || source == JBendLine.this) && this.closestCommonAncestorEnd != null && JBendLine.this.endTransform != null && SwingUtilities.isDescendingFrom(changed, this.closestCommonAncestorEnd)) {
                JBendLine.this.invalidateEndTransform();
            }
        }

        public void ancestorResized(HierarchyEvent e) {
        }
    }

    private class BendIterator
    extends AbstractListIterator {
        public BendIterator(int start) {
            super(start);
        }

        protected Object get(int index) {
            return JBendLine.this.getFromBends(index);
        }

        protected int size() {
            return JBendLine.this.sizeOfBends();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            if (this.currentIndex() < 0 || this.currentIndex() >= this.size()) {
                throw new NoSuchElementException();
            }
            JBendLine.this.setBendAt(this.currentIndex(), (JBend)o);
        }
    }
}

