/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.Direction;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import javax.swing.JComponent;

public abstract class JArrowHead
extends JComponent
implements Cloneable {
    private ArrayList shapeList = new ArrayList(2);
    private boolean filled;
    private Direction direction = Direction.TOP;
    protected AffineTransform at = new AffineTransform();
    private int style = 0;
    public static final int BIG = 1;
    public static final int SMALL = 0;
    public static final int FILLED = 2;
    public static final int HOLLOW = 0;
    public static final int OPEN_ARROW = 0;
    public static final int TRIANGLE = 0;
    public static final int DOUBLE_LINE = 8;

    JArrowHead() {
    }

    JArrowHead(int style) {
        this.setStyle(style);
    }

    public Point getBasePoint() {
        return (Point)this.at.transform(new Point((this.getHeight() - 1) / 2, this.getHeight() - 1), new Point());
    }

    public Point getHeadPoint() {
        return (Point)this.at.transform(new Point((this.getHeight() - 1) / 2, -1), new Point());
    }

    public ArrayList getShapeList() {
        return this.shapeList;
    }

    protected void setFilled(boolean filled) {
        this.filled = filled;
    }

    public boolean getFilled() {
        return this.filled;
    }

    public boolean setDirection(Direction direction) {
        if (direction == Direction.UNDEFINED) {
            throw new IllegalArgumentException("Direction is undefined");
        }
        if (direction != this.direction) {
            this.direction = direction;
            if (direction == Direction.TOP) {
                this.at.setToIdentity();
            } else if (direction == Direction.LEFT) {
                this.at.setToIdentity();
                this.at.translate(this.getHeight() / 2, this.getHeight() / 2);
                this.at.rotate(Math.toRadians(-90.0));
                this.at.translate(-this.getHeight() / 2, -this.getHeight() / 2);
            } else if (direction == Direction.BOTTOM) {
                this.at.setToIdentity();
                this.at.setToIdentity();
                this.at.translate(this.getHeight() / 2, this.getHeight() / 2);
                this.at.rotate(Math.toRadians(180.0));
                this.at.translate(-this.getHeight() / 2, -this.getHeight() / 2);
            } else {
                this.at.setToIdentity();
                this.at.translate(this.getHeight() / 2, this.getHeight() / 2);
                this.at.rotate(Math.toRadians(90.0));
                this.at.translate(-this.getHeight() / 2, -this.getHeight() / 2);
            }
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintArrow(g);
    }

    public abstract void paintArrow(Graphics var1);

    public abstract Object clone();

    public void setStyle(int style) {
        switch (style) {
            case 0: 
            case 8: {
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 12: {
                break;
            }
        }
        this.style = style;
    }

    int getStyle() {
        return this.style;
    }
}

