/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.JArrowHead;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.Iterator;

public class JArrowDoubleLineHead
extends JArrowHead {
    private static final int DEFAULT_WIDTH = 13;
    private static final int DEFAULT_HEIGHT = 19;

    public JArrowDoubleLineHead() {
        this(19);
    }

    public JArrowDoubleLineHead(int size) {
        this(size * 13 / 19, size);
    }

    public JArrowDoubleLineHead(int width, int height) {
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(height, height));
        this.setFilled(false);
        GeneralPath shape = new GeneralPath();
        shape.moveTo((height - width) / 2, height - 1);
        shape.lineTo((height - 1) / 2, 0.0f);
        shape.lineTo((height + width - 2) / 2, height - 1);
        shape.moveTo((height - 1) / 2 - 1, 1 + 2 * height / width);
        shape.lineTo((height - 1) / 2 - 1, height - 1);
        shape.moveTo((height - 1) / 2 + 1, 1 + 2 * height / width);
        shape.lineTo((height - 1) / 2 + 1, height - 1);
        this.getShapeList().add(shape);
    }

    public void paintArrow(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(this.getForeground());
        Iterator iter = this.getShapeList().iterator();
        while (iter.hasNext()) {
            GeneralPath shape = (GeneralPath)iter.next();
            Graphics2D g2d = (Graphics2D)g;
            g2d.draw(this.at.createTransformedShape(shape));
        }
        g.setColor(oldColor);
    }

    public Object clone() {
        return new JArrowDoubleLineHead(this.getWidth(), this.getHeight());
    }
}

