/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.GrabLayouter;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class GrabManager
extends ComponentAdapter
implements PropertyChangeListener,
HierarchyListener,
HierarchyBoundsListener {
    public static final String TARGET_PROPERTY = "GrabManager";
    private static int recursionDepth = 0;
    private static boolean postPoneing = false;
    private static HashSet postPonedManagers = null;
    private JComponent target = null;
    private FHashSet grabs = null;
    private Container commonAncestorOfGrabs = null;
    private boolean revalidating = false;

    public static void postPoneGrabLayout() {
        if (!postPoneing) {
            postPoneing = true;
            postPonedManagers = new HashSet();
        }
    }

    public static void doPostPonedGrabLayout() {
        if (postPoneing) {
            postPoneing = false;
            GrabManager tmpMan = null;
            Iterator iter = postPonedManagers.iterator();
            while (iter.hasNext()) {
                tmpMan = (GrabManager)iter.next();
                tmpMan.revalidate(2);
            }
        }
    }

    public GrabManager() {
    }

    public GrabManager(JComponent target) {
        this();
        this.setTarget(target);
    }

    public boolean setTarget(JComponent value) {
        boolean changed = false;
        if (this.target != value) {
            GrabManager oldManager = null;
            JComponent oldValue = this.target;
            if (this.target != null) {
                this.unregisterTarget();
                if (value == null) {
                    this.unregisterGrabs();
                }
                this.target = null;
                oldManager = (GrabManager)oldValue.getClientProperty(TARGET_PROPERTY);
                if (oldManager == this) {
                    oldValue.putClientProperty(TARGET_PROPERTY, null);
                }
                oldValue.removePropertyChangeListener(TARGET_PROPERTY, this);
            }
            this.target = value;
            if (value != null) {
                oldManager = (GrabManager)value.getClientProperty(TARGET_PROPERTY);
                if (oldManager != null) {
                    oldManager.setTarget(null);
                }
                value.putClientProperty(TARGET_PROPERTY, this);
                value.addPropertyChangeListener(TARGET_PROPERTY, this);
                if (this.sizeOfGrabs() != 0) {
                    this.registerTarget();
                    if (oldValue == null) {
                        this.registerGrabs();
                    }
                }
            }
            this.revalidate();
            changed = true;
        }
        return changed;
    }

    private void unregisterTarget() {
        this.target.removeComponentListener(this);
        this.target.removePropertyChangeListener("GrabLayouter", this);
        this.target.removeHierarchyListener(this);
        this.target.removeHierarchyBoundsListener(this);
    }

    private void registerTarget() {
        if (this.target != null) {
            this.target.addPropertyChangeListener("GrabLayouter", this);
            this.target.addComponentListener(this);
            this.target.addHierarchyListener(this);
            this.target.addHierarchyBoundsListener(this);
        }
    }

    private void registerGrabs() {
        Iterator grabIter = this.iteratorOfGrabs();
        while (grabIter.hasNext()) {
            JGrab grab = (JGrab)grabIter.next();
            this.registerGrab(grab);
        }
    }

    private void unregisterGrabs() {
        Iterator grabIter = this.iteratorOfGrabs();
        while (grabIter.hasNext()) {
            JGrab grab = (JGrab)grabIter.next();
            this.unregisterGrab(grab);
        }
    }

    private void registerGrab(JGrab grab) {
        grab.addHierarchyListener(this);
        grab.addComponentListener(this);
    }

    private void unregisterGrab(JGrab grab) {
        grab.removeComponentListener(this);
        grab.removeHierarchyListener(this);
    }

    public JComponent getTarget() {
        return this.target;
    }

    public boolean addToGrabs(JGrab value) {
        boolean changed = false;
        if (value != null) {
            if (this.grabs == null) {
                this.grabs = new FHashSet();
            }
            if (changed = this.grabs.add(value)) {
                value.setManager(this);
                if (this.grabs.size() == 1) {
                    this.registerTarget();
                }
                this.updateCommonAncestorOfGrabs(value.getParent(), false);
                this.registerGrab(value);
                this.revalidate();
            }
        }
        return changed;
    }

    public boolean hasInGrabs(JGrab value) {
        return this.grabs != null && value != null && this.grabs.contains(value);
    }

    public Iterator iteratorOfGrabs() {
        return this.grabs == null ? FEmptyIterator.get() : this.grabs.iterator();
    }

    public int sizeOfGrabs() {
        return this.grabs == null ? 0 : this.grabs.size();
    }

    public boolean removeFromGrabs(JGrab value) {
        boolean changed = false;
        if (this.grabs != null && value != null && (changed = this.grabs.remove(value))) {
            value.setManager(null);
            this.unregisterGrab(value);
            this.updateCommonAncestorOfGrabs(value.getParent(), true);
            if (this.grabs.size() == 0 && this.target != null) {
                this.unregisterTarget();
            }
            this.revalidate();
        }
        return changed;
    }

    public void removeAllFromGrabs() {
        Iterator iter = this.iteratorOfGrabs();
        this.commonAncestorOfGrabs = null;
        while (iter.hasNext()) {
            JGrab tmpValue = (JGrab)iter.next();
            this.removeFromGrabs(tmpValue);
        }
    }

    private void updateCommonAncestorOfGrabs(Container hint) {
        this.commonAncestorOfGrabs = null;
        Iterator grabIter = this.iteratorOfGrabs();
        while (grabIter.hasNext()) {
            this.updateCommonAncestorOfGrabs(((JGrab)grabIter.next()).getParent(), false);
            if (hint != null && this.commonAncestorOfGrabs == hint) break;
        }
    }

    private void updateCommonAncestorOfGrabs(Container parent, boolean removed) {
        if (parent == null) {
            return;
        }
        if (!removed) {
            this.commonAncestorOfGrabs = this.commonAncestorOfGrabs == null ? parent : JBendLine.getClosestCommonAncestor(parent, this.commonAncestorOfGrabs);
        } else if (this.commonAncestorOfGrabs != null && SwingUtilities.isDescendingFrom(parent, this.commonAncestorOfGrabs)) {
            this.updateCommonAncestorOfGrabs(this.commonAncestorOfGrabs);
        }
    }

    public void revalidate() {
        this.revalidate(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void revalidate(int depthIncrease) {
        if (this.revalidating) return;
        if (postPoneing) {
            postPonedManagers.add(this);
            return;
        }
        if (recursionDepth >= 2) return;
        recursionDepth += depthIncrease;
        this.revalidating = true;
        try {
            try {
                JComponent target = this.getTarget();
                if (target == null) {
                    Object var4_4 = null;
                    this.revalidating = false;
                    recursionDepth -= depthIncrease;
                    return;
                }
                GrabLayouter layouter = GrabLayouter.getLayouter(target);
                layouter.layout(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.revalidating = false;
            recursionDepth -= depthIncrease;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.revalidating = false;
            recursionDepth -= depthIncrease;
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (TARGET_PROPERTY.equals(e.getPropertyName()) && e.getOldValue() == this && e.getNewValue() != this) {
            this.setTarget(null);
        }
        this.revalidate();
    }

    public void componentMoved(ComponentEvent e) {
        if (e.getComponent() == this.getTarget()) {
            this.revalidate();
        }
    }

    public void componentResized(ComponentEvent e) {
        Component source = e.getComponent();
        if (source == this.getTarget() || source instanceof JGrab) {
            this.revalidate();
        }
    }

    public void hierarchyChanged(HierarchyEvent e) {
        long flags = e.getChangeFlags();
        if ((flags & 1L) != 0L) {
            Object source = e.getSource();
            Container parent = e.getChangedParent();
            if (e.getChanged().getParent() == null) {
                if (source != this.target) {
                    this.updateCommonAncestorOfGrabs(parent, false);
                }
            } else if (source == this.target) {
                if (this.commonAncestorOfGrabs != null && SwingUtilities.isDescendingFrom(parent, this.commonAncestorOfGrabs)) {
                    this.revalidate();
                }
            } else {
                Container oldValue = this.commonAncestorOfGrabs;
                this.updateCommonAncestorOfGrabs(parent, false);
                if (oldValue != this.commonAncestorOfGrabs) {
                    this.revalidate();
                }
            }
        }
    }

    public void ancestorMoved(HierarchyEvent e) {
        if (this.commonAncestorOfGrabs == null) {
            return;
        }
        Component ancestor = e.getChanged();
        if (!SwingUtilities.isDescendingFrom(this.commonAncestorOfGrabs, ancestor)) {
            this.revalidate();
        }
    }

    public void ancestorResized(HierarchyEvent e) {
    }
}

