/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.DecoratorLayout;
import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class GrabDecoratorConstraints
implements DecoratorLayout.Constraints {
    public static final byte CENTERED = 0;
    public static final byte ABOVE = 1;
    public static final byte BELOW = 2;
    private byte alignment = 1;
    private int gapX = 0;
    private int gapY = 0;
    private Component target = null;

    public GrabDecoratorConstraints(JGrab target, int gapX, int gapY, byte align) {
        this.setAlignment(align);
        this.setGapX(gapX);
        this.setGapY(gapY);
        this.setTarget(target);
    }

    public GrabDecoratorConstraints(JGrab target, byte align) {
        this(target, 0, 0, align);
    }

    public Component getTarget() {
        return this.target;
    }

    public Component setTarget(Component target) {
        if (this.target != target) {
            if (!(target instanceof JGrab)) {
                throw new IllegalArgumentException("Target must be a JGrab");
            }
            this.target = target;
        }
        return this.target;
    }

    public Point getLocation(Component comp) {
        JGrab grab = (JGrab)this.getTarget();
        if (grab == null) {
            return comp.getLocation();
        }
        Point pos = grab.getPoint();
        pos = SwingUtilities.convertPoint(grab.getParent(), pos, comp.getParent());
        Dimension compDim = comp.getPreferredSize();
        if (grab.getOrientation() == Direction.TOP || grab.getOrientation() == Direction.BOTTOM) {
            pos.y = pos.y + (grab.getOrientation() == Direction.TOP ? -1 : 1) * (compDim.height + this.gapY);
            pos.x = this.alignment == 1 ? (pos.x -= this.gapX + compDim.width) : (this.alignment == 2 ? (pos.x += this.gapX) : (pos.x -= compDim.width / 2));
        } else {
            pos.x = pos.x + (grab.getOrientation() == Direction.LEFT ? -1 : 1) * (compDim.width + this.gapX);
            pos.y = this.alignment == 1 ? (pos.y -= this.gapY + compDim.height) : (this.alignment == 2 ? (pos.y += this.gapY) : (pos.y -= compDim.height / 2));
        }
        return pos;
    }

    public byte getAlignment() {
        return this.alignment;
    }

    public byte setAlignment(byte alignment) {
        if (this.alignment != alignment) {
            if (alignment != 0 && alignment != 1 && alignment != 2) {
                throw new IllegalArgumentException("Target alignment must be one of CENTERED, ABOVE or BELOW");
            }
            this.alignment = alignment;
        }
        return this.alignment;
    }

    public int getGapX() {
        return this.gapX;
    }

    public int setGapX(int gap) {
        if (this.gapX != gap) {
            this.gapX = gap;
        }
        return this.gapX;
    }

    public int getGapY() {
        return this.gapY;
    }

    public int setGapY(int gap) {
        if (this.gapY != gap) {
            this.gapY = gap;
        }
        return this.gapY;
    }

    public void removeYou() {
        this.setTarget(null);
    }
}

