/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.JDelimiter;
import de.uni_paderborn.fujaba.fsa.swing.SortedLayout;
import de.upb.tools.fca.FTreeMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JSeparator;

public class ColumnRowLayout
implements SortedLayout {
    protected int gap;
    protected int mode;
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    protected FTreeMap alignments = new FTreeMap();
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    private String delimiter = null;
    private JDelimiter swingDelim = null;
    private Comparator comparator = null;

    public void setComparator(Comparator comp) {
        if (this.comparator == null && comp != null || this.comparator != null && !this.comparator.equals(comp)) {
            this.comparator = comp;
        }
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setDelimiter(String delim) {
        if (this.delimiter == null && delim != null || this.delimiter != null && !this.delimiter.equals(delim)) {
            this.delimiter = delim;
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public ColumnRowLayout() {
    }

    public ColumnRowLayout(int aGap, int aMode) {
        this.gap = aGap;
        this.mode = aMode;
    }

    public void setAlignment(int pos, int align) {
        this.alignments.put(new Integer(pos), new Integer(align));
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (this.delimiter != null && this.swingDelim == null) {
            this.swingDelim = new JDelimiter(this.getDelimiter());
        } else if (this.delimiter == null) {
            this.swingDelim = null;
        }
        Vector<Component> toBeRemoved = new Vector<Component>();
        Vector<Integer> toBeAdded = new Vector<Integer>();
        Component[] comp = parent.getComponents();
        Insets insets = parent.getInsets();
        int height = 0;
        int width = 0;
        int compCount = 0;
        int i = 0;
        while (i < comp.length) {
            if (comp[i].isVisible()) {
                if (comp[i] instanceof JDelimiter) {
                    if (this.delimiter == null) {
                        toBeRemoved.add(comp[i]);
                    }
                } else {
                    if (this.delimiter != null && i + 1 < comp.length && !(comp[i + 1] instanceof JDelimiter)) {
                        toBeAdded.add(new Integer(i + 1));
                    }
                    ++compCount;
                    Dimension tempDim = comp[i].getPreferredSize();
                    if (tempDim != null) {
                        Dimension hlpDim;
                        if (this.mode == 1) {
                            if (tempDim.width > width) {
                                width = tempDim.width;
                            }
                            if (this.delimiter != null && this.swingDelim != null) {
                                hlpDim = this.swingDelim.getPreferredSize();
                                height += hlpDim.height;
                            }
                            height += tempDim.height;
                        } else {
                            if (tempDim.height > height) {
                                height = tempDim.height;
                            }
                            if (this.delimiter != null && this.swingDelim != null) {
                                hlpDim = this.swingDelim.getPreferredSize();
                                width += hlpDim.width;
                            }
                            width += tempDim.width;
                        }
                    }
                }
            }
            ++i;
        }
        Iterator iter = toBeRemoved.iterator();
        while (iter.hasNext()) {
            Component hlpComp = (Component)iter.next();
            parent.remove(hlpComp);
        }
        toBeRemoved.clear();
        int hlpCount = 0;
        iter = toBeAdded.iterator();
        while (iter.hasNext()) {
            Integer indexObj = (Integer)iter.next();
            int index = indexObj + hlpCount;
            JDelimiter delim = new JDelimiter(this.getDelimiter());
            delim.setFont(parent.getFont());
            parent.add((Component)delim, index);
            ++hlpCount;
        }
        toBeAdded.clear();
        if (compCount > 0) {
            if (this.mode == 1) {
                height += (compCount + 1) * this.gap;
                width += 2 * this.gap;
            } else {
                width += (compCount + 1) * this.gap;
                height += 2 * this.gap;
            }
        }
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Dimension dim = null;
        Rectangle rect = parent.getBounds();
        dim = rect == null ? this.preferredLayoutSize(parent) : new Dimension(rect.width, rect.height);
        Component[] comp = parent.getComponents();
        Insets insets = parent.getInsets();
        int x = this.gap + insets.left;
        int y = this.gap + insets.top;
        int maxWidth = dim.width - insets.left - insets.right - 2 * this.gap;
        int maxHeight = dim.height - insets.top - insets.bottom - 2 * this.gap;
        Integer pos = null;
        if (this.comparator != null) {
            Arrays.sort(comp, this.comparator);
        }
        int i = 0;
        while (i < comp.length) {
            int align = 0;
            int tmpX = x;
            if (comp[i].isVisible()) {
                Dimension tempDim = comp[i].getPreferredSize();
                if (comp[i] instanceof JSeparator) {
                    comp[i].setLocation(x - this.gap, y - this.gap / 2);
                    y -= this.gap / 2;
                } else {
                    Integer alignment;
                    pos = new Integer(i);
                    if (this.mode == 1 && this.alignments.get(pos) != null && (align = (alignment = (Integer)this.alignments.get(pos)).intValue()) == 2) {
                        tmpX = (int)(dim.getWidth() - tempDim.getWidth()) / 2;
                    }
                    comp[i].setLocation(tmpX, y);
                }
                if (this.mode == 1) {
                    if (comp[i] instanceof JSeparator) {
                        comp[i].setSize(maxWidth + 2 * this.gap, tempDim.height);
                    } else if (align != 2) {
                        comp[i].setSize(maxWidth, tempDim.height);
                    } else {
                        comp[i].setSize(tempDim.width, tempDim.height);
                    }
                    y = y + tempDim.height + this.gap;
                } else {
                    comp[i].setSize(tempDim.width, maxHeight);
                    x = x + tempDim.width + this.gap;
                }
            }
            ++i;
        }
    }
}

