/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.listener;

import de.uni_paderborn.fujaba.fsa.listener.SelectionEvent;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListener;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FLinkedList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JComponent;

public abstract class SelectionListenerHelper {
    private static final transient Integer UNSELECTED = null;
    private static final transient Integer SELECTED = new Integer(1);
    private static final transient Integer FOCUSED = new Integer(2);
    private static final transient Integer FOCUSED_SELECTED = new Integer(3);
    private static final transient String LISTENER_CLIENT_PROPERTY;
    static final transient String STATE_CLIENT_PROPERTY;
    private static transient PropertyChangeListener selectionStateListener;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.fsa.listener.SelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LISTENER_CLIENT_PROPERTY = String.valueOf(clazz.getName()) + "::listeners";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.uni_paderborn.fujaba.fsa.listener.SelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        STATE_CLIENT_PROPERTY = String.valueOf(clazz2.getName()) + "::state";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addSelectionListener(JComponent comp, SelectionListener listener) {
        Object o = comp.getClientProperty(LISTENER_CLIENT_PROPERTY);
        FLinkedList listeners = null;
        if (o != null) {
            if (!(o instanceof FLinkedList)) throw new IllegalStateException("The component has a conflicting client property with name \"" + LISTENER_CLIENT_PROPERTY + "\": " + o);
            listeners = (FLinkedList)o;
        } else {
            listeners = new FLinkedList();
            comp.putClientProperty(LISTENER_CLIENT_PROPERTY, listeners);
        }
        listeners.add(listener);
        if (listeners.size() != 1) return;
        comp.addPropertyChangeListener(STATE_CLIENT_PROPERTY, SelectionListenerHelper.getSelectionStateListener());
    }

    public static boolean removeSelectionListener(JComponent comp, SelectionListener listener) {
        Object o = comp.getClientProperty(LISTENER_CLIENT_PROPERTY);
        FLinkedList listeners = null;
        boolean result = false;
        if (o != null && o instanceof FLinkedList && (result = (listeners = (FLinkedList)o).remove(listener)) && listeners.size() == 0) {
            comp.putClientProperty(LISTENER_CLIENT_PROPERTY, null);
            comp.removePropertyChangeListener(STATE_CLIENT_PROPERTY, SelectionListenerHelper.getSelectionStateListener());
        }
        return result;
    }

    public static Iterator iteratorOfSelectionListeners(JComponent comp) {
        Object o = comp.getClientProperty(LISTENER_CLIENT_PROPERTY);
        if (o != null && o instanceof FLinkedList) {
            FLinkedList listeners = (FLinkedList)o;
            return listeners.iterator();
        }
        return FEmptyIterator.get();
    }

    public static int getSelection(JComponent comp) {
        Object o = comp.getClientProperty(STATE_CLIENT_PROPERTY);
        if (o != null) {
            if (o instanceof Integer) {
                return (Integer)o;
            }
            throw new IllegalStateException("The component has a conflicting client property with name \"" + STATE_CLIENT_PROPERTY + "\": " + o);
        }
        return 0;
    }

    public static void setSelection(JComponent comp, int selection) {
        switch (selection) {
            case 0: {
                SelectionListenerHelper.setSelection(comp, UNSELECTED);
                break;
            }
            case 1: {
                SelectionListenerHelper.setSelection(comp, SELECTED);
                break;
            }
            case 2: {
                SelectionListenerHelper.setSelection(comp, FOCUSED);
                break;
            }
            case 3: {
                SelectionListenerHelper.setSelection(comp, FOCUSED_SELECTED);
                break;
            }
            default: {
                throw new IllegalArgumentException("Selection Parameter must be in [0..3], is " + selection);
            }
        }
    }

    protected static void setSelection(JComponent comp, Integer selection) {
        Object o = comp.getClientProperty(STATE_CLIENT_PROPERTY);
        if (o != null && !(o instanceof Integer)) {
            throw new IllegalStateException("The component has a conflicting client property with name \"" + STATE_CLIENT_PROPERTY + "\": " + o);
        }
        comp.putClientProperty(STATE_CLIENT_PROPERTY, selection);
    }

    public static boolean isSelected(JComponent comp) {
        return comp != null && (SelectionListenerHelper.getSelection(comp) & 1) != 0;
    }

    public static void setSelected(JComponent comp, boolean flag) {
        int state = SelectionListenerHelper.getSelection(comp);
        if (flag != ((state & 1) != 0)) {
            SelectionListenerHelper.setSelection(comp, state ^= 1);
        }
    }

    public static boolean isFocused(JComponent comp) {
        return comp != null && (SelectionListenerHelper.getSelection(comp) & 2) != 0;
    }

    public static void setFocused(JComponent comp, boolean flag) {
        int state = SelectionListenerHelper.getSelection(comp);
        if (flag != ((state & 2) != 0)) {
            SelectionListenerHelper.setSelection(comp, state ^= 2);
        }
    }

    protected static void fireSelectionChanged(SelectionEvent event) {
        JComponent source = (JComponent)event.getSource();
        Iterator iter = SelectionListenerHelper.iteratorOfSelectionListeners(source);
        while (iter.hasNext()) {
            SelectionListener l = (SelectionListener)iter.next();
            l.selectionChanged(event);
        }
    }

    protected static void fireSelectionChanged(JComponent source, Integer old, Integer selection) {
        int oldSel = old == null ? 0 : old;
        int newSel = selection == null ? 0 : selection;
        SelectionEvent event = new SelectionEvent(source, oldSel, newSel);
        SelectionListenerHelper.fireSelectionChanged(event);
    }

    protected static PropertyChangeListener getSelectionStateListener() {
        if (selectionStateListener == null) {
            selectionStateListener = new SelectionStateListener();
        }
        return selectionStateListener;
    }

    private static final class SelectionStateListener
    implements PropertyChangeListener {
        SelectionStateListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (STATE_CLIENT_PROPERTY.equals(evt.getPropertyName())) {
                Integer oldValue = (Integer)evt.getOldValue();
                Integer newValue = (Integer)evt.getNewValue();
                JComponent source = (JComponent)evt.getSource();
                if (oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue)) {
                    SelectionListenerHelper.fireSelectionChanged(source, oldValue, newValue);
                }
            }
        }
    }
}

