/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.listener;

import de.uni_paderborn.fujaba.fsa.FSAContainer;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.swing.LayerManager;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputAdapter;

public class RectangularSelectionListener
extends MouseInputAdapter {
    private static final int LAYER = JLayeredPane.DRAG_LAYER + 100;
    private static final String LAYER_NAME = "RectangularSelectionLayer";
    private static RectangularSelectionListener singleton;
    private Point relativePositionOnPress;
    private JPanel panel;
    private HashSet selected;
    private HashSet unselected;
    private FSAContainer target;
    private LinkedList changed = null;

    static {
        LayerManager.get().addToLayerPositions(LAYER_NAME, new Integer(LAYER));
        singleton = null;
    }

    private RectangularSelectionListener() {
    }

    public static RectangularSelectionListener get() {
        if (singleton == null) {
            singleton = new RectangularSelectionListener();
        }
        return singleton;
    }

    public void mousePressed(MouseEvent e) {
        if ((e.getModifiers() & 2) == 0 && (e.getModifiers() & 1) == 0) {
            SelectionManager.get().clear();
        }
        this.relativePositionOnPress = e.getPoint();
        JComponent jtarget = (JComponent)e.getSource();
        FSAObject fsa = FSAObject.getFSAObjectFromJComponent(jtarget);
        if (fsa instanceof FSAContainer) {
            e.consume();
            this.target = (FSAContainer)fsa;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.panel != null) {
            Container parent = this.panel.getParent();
            if (parent != null) {
                parent.remove(this.panel);
                parent.repaint();
            }
            this.panel = null;
        }
        if (this.target != null) {
            e.consume();
        }
        this.target = null;
        this.relativePositionOnPress = null;
        this.unselected = null;
        this.selected = null;
        this.changed = null;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.target != null) {
            e.consume();
            SelectionManager manager = SelectionManager.get();
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setOpaque(false);
                this.panel.setBorder(new LineBorder(ColorsPreferences.get().SELECTION_RECT));
                LayerManager.setLayerType(this.panel, LAYER_NAME);
                this.target.getJComponent().add(this.panel);
            }
            if (this.selected == null || this.unselected == null) {
                int maxSize = 100;
                if (this.target.getChildConnector() != null) {
                    maxSize = this.target.getChildConnector().getComponentCount();
                }
                this.unselected = new HashSet(maxSize);
                this.selected = new HashSet(maxSize);
                Iterator childIter = this.target.iteratorOfChildren();
                while (childIter.hasNext()) {
                    FSAObject child = (FSAObject)childIter.next();
                    if (child.isSelected()) {
                        this.selected.add(child);
                        continue;
                    }
                    this.unselected.add(child);
                }
            }
            Point newLocation = e.getPoint();
            if (this.relativePositionOnPress == null) {
                this.relativePositionOnPress = newLocation;
            }
            Rectangle bounds = new Rectangle(Math.min(newLocation.x, this.relativePositionOnPress.x), Math.min(newLocation.y, this.relativePositionOnPress.y), Math.abs(newLocation.x - this.relativePositionOnPress.x), Math.abs(newLocation.y - this.relativePositionOnPress.y));
            Rectangle oldBounds = this.panel.getBounds();
            this.panel.setBounds(bounds);
            if (!bounds.contains(oldBounds)) {
                if (this.changed == null) {
                    this.changed = new LinkedList();
                }
                Rectangle[] removedAreas = SwingUtilities.computeDifference(oldBounds, bounds);
                Iterator selIter = this.selected.iterator();
                block1: while (selIter.hasNext()) {
                    FSAObject selObject = (FSAObject)selIter.next();
                    JComponent selComp = selObject.getJComponent();
                    if (selComp == null) continue;
                    Rectangle selBounds = selComp.getBounds();
                    int i = 0;
                    while (i < removedAreas.length) {
                        if (removedAreas[i].intersects(selBounds)) {
                            manager.setSelected(selObject, false, true);
                            selIter.remove();
                            this.changed.add(selObject);
                            continue block1;
                        }
                        ++i;
                    }
                }
            }
            if (!oldBounds.contains(bounds)) {
                Iterator unselIter = this.unselected.iterator();
                while (unselIter.hasNext()) {
                    Rectangle unselBounds;
                    FSAObject unselObject = (FSAObject)unselIter.next();
                    JComponent unselComp = unselObject.getJComponent();
                    if (unselComp == null || !bounds.contains(unselBounds = unselComp.getBounds())) continue;
                    manager.setSelected(unselObject, true, true);
                    unselIter.remove();
                    this.selected.add(unselObject);
                    break;
                }
            }
            if (this.changed != null) {
                this.unselected.addAll(this.changed);
                this.changed.clear();
            }
        }
    }
}

