/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.listener;

import de.uni_paderborn.fujaba.fsa.FSAGrab;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class GrabMouseListener
extends MouseInputAdapter
implements AscendDescendMouseHandler.Descend {
    private static GrabMouseListener singleton = null;

    public static GrabMouseListener get() {
        if (singleton == null) {
            singleton = new GrabMouseListener();
        }
        return singleton;
    }

    private GrabMouseListener() {
    }

    public void mouseDragged(MouseEvent event) {
        JComponent source = (JComponent)event.getSource();
        JGrab jGrab = this.findGrab(source);
        JComponent target = jGrab.getTarget();
        if (target != null) {
            Point eventPoint = SwingUtilities.convertPoint(source, event.getPoint(), target);
            Rectangle bounds = target.getBounds();
            Direction orient = jGrab.getOrientation();
            double align = 0.5;
            Direction tmpOrient = GrabMouseListener.getOrientation(eventPoint.x, eventPoint.y, bounds);
            if (tmpOrient != Direction.UNDEFINED) {
                orient = tmpOrient;
            }
            if (orient == Direction.TOP || orient == Direction.BOTTOM) {
                if (bounds.width != 0) {
                    align = (double)eventPoint.x / (double)bounds.width;
                }
            } else if (bounds.height != 0) {
                align = (double)eventPoint.y / (double)bounds.height;
            }
            if (align < 0.0) {
                align = 0.0;
            } else if (align > 1.0) {
                align = 1.0;
            }
            jGrab.setOrientation(orient);
            jGrab.setAlignment(align);
            FSAGrab grab = (FSAGrab)FSAObject.getFSAObjectFromJComponent(jGrab);
            if (grab != null) {
                grab.setTransientProperties(false);
                grab.saveOrientation();
                grab.saveAlignment();
            }
            event.consume();
        }
    }

    private JGrab findGrab(JComponent source) {
        Container comp = source;
        while (comp != null && !(comp instanceof JGrab)) {
            comp = comp.getParent();
        }
        if (comp == null) {
            throw new RuntimeException("No JGrab found!");
        }
        return (JGrab)comp;
    }

    public static Direction getOrientation(int x, int y, Rectangle bounds) {
        int dx;
        Direction yAlign = Direction.UNDEFINED;
        Direction xAlign = Direction.UNDEFINED;
        if (y < bounds.height / 2) {
            yAlign = Direction.TOP;
        } else if (y > bounds.height / 2) {
            yAlign = Direction.BOTTOM;
        }
        if (x < bounds.width / 2) {
            xAlign = Direction.LEFT;
        } else if (x > bounds.width / 2) {
            xAlign = Direction.RIGHT;
        }
        if (xAlign == Direction.UNDEFINED) {
            return yAlign;
        }
        if (yAlign == Direction.UNDEFINED) {
            return xAlign;
        }
        int dy = yAlign == Direction.TOP ? y : -1 * (y - bounds.height);
        if (dy < (dx = xAlign == Direction.LEFT ? x : -1 * (x - bounds.width))) {
            return yAlign;
        }
        return xAlign;
    }
}

