/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.listener;

import de.uni_paderborn.fujaba.basic.FujabaPropertyChangeSupport;
import de.uni_paderborn.fujaba.fsa.update.ListenerHelper;
import de.upb.tools.sdm.Path;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class CascadedPropertyChangeSupport
extends FujabaPropertyChangeSupport {
    private String[] path = null;
    private String joinedPath = null;

    public CascadedPropertyChangeSupport(String path, Object start) {
        this(CascadedPropertyChangeSupport.split(path), start);
        this.joinedPath = path;
    }

    public CascadedPropertyChangeSupport(String[] path, Object start) {
        super(start);
        if (start == null || !ListenerHelper.get().isPropertyChangeListenerSupported(start)) {
            throw new IllegalArgumentException("Start object must be non-null and must support propertychange-listeners");
        }
        this.path = path;
        this.initialize();
    }

    private static String[] split(String str) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(str, ".");
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens() && i < result.length) {
            String token;
            result[i] = token = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    private static String join(String[] path) {
        return CascadedPropertyChangeSupport.join(path, 0, path.length);
    }

    static String join(String[] path, int from, int to) {
        StringBuffer buffer = new StringBuffer();
        int i = from;
        while (path != null && i < to) {
            buffer.append(path[i]);
            if (i < path.length - 1) {
                buffer.append(".");
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getPath() {
        if (this.joinedPath == null) {
            this.joinedPath = CascadedPropertyChangeSupport.join(this.path);
        }
        return this.joinedPath;
    }

    void initialize() {
        CascadedPCL pcl = new CascadedPCL(this.path, 0, this);
        Vector<Object> start = new Vector<Object>();
        start.add(this.getSource());
        this.initialize(0, start.iterator(), pcl);
    }

    void initialize(int index, Iterator iter, CascadedPCL pcl) {
        CascadedPCL child = null;
        while (iter.hasNext()) {
            Path childIter;
            Object source = iter.next();
            ListenerHelper.get().addPropertyChangeListener(source, this.path[index], pcl);
            if (index >= this.path.length - 1 || !(childIter = new Path(source, this.path[index])).hasNext()) continue;
            if (child == null) {
                child = pcl.getChild();
            }
            this.initialize(index + 1, childIter, child);
        }
    }

    public boolean setSource(Object source) {
        if (this.getSource() == null) {
            return super.setSource(source);
        }
        throw new UnsupportedOperationException("Event source cannot be changed");
    }

    private static class CascadedPCL
    implements PropertyChangeListener {
        private CascadedPCL child = null;
        private CascadedPropertyChangeSupport master = null;
        private String[] path = null;
        private int index = 0;
        private String pathString = null;

        CascadedPCL(String[] path, int index, CascadedPropertyChangeSupport master) {
            this.path = path;
            this.index = index;
            this.master = master;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (this.path[this.index].equals(name)) {
                if (this.index != this.path.length - 1) {
                    Object oldValue = e.getOldValue();
                    Object newValue = e.getNewValue();
                    if (oldValue != null && this.child != null) {
                        ListenerHelper.get().removePropertyChangeListener(oldValue, this.path[this.index + 1], this.child);
                    }
                    if (newValue != null) {
                        ListenerHelper.get().addPropertyChangeListener(newValue, this.path[this.index + 1], this.getChild());
                    }
                }
                name = this.master.getPath();
                e = new PropertyChangeEvent(this.master.getSource(), this.getPathString(), e.getOldValue(), e.getNewValue());
                this.master.firePropertyChange(e);
            }
        }

        private String getPathString() {
            if (this.pathString == null) {
                this.pathString = CascadedPropertyChangeSupport.join(this.path, 0, this.index + 1);
            }
            return this.pathString;
        }

        CascadedPCL getChild() {
            if (this.child == null) {
                this.child = new CascadedPCL(this.path, this.index + 1, this.master);
            }
            return this.child;
        }
    }
}

