/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa;

import de.uni_paderborn.fujaba.fsa.FSAPanel;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import java.awt.Dimension;
import javax.swing.JComponent;

public class FSAResizeable
extends FSAPanel {
    private Dimension userSize = null;

    public FSAResizeable(LogicUnparseInterface incr) {
        super(incr, null, null);
    }

    public FSAResizeable(LogicUnparseInterface incr, JComponent parent) {
        super(incr, null, parent);
    }

    public FSAResizeable(LogicUnparseInterface incr, String propName, JComponent parent) {
        super(incr, propName, parent);
    }

    public FSAResizeable(LogicUnparseInterface incr, String propName, JComponent parent, boolean transientProperties) {
        super(incr, propName, parent, transientProperties);
    }

    public void setMinimumSize(Dimension size) {
        JComponent comp = this.getJComponent();
        if (comp != null) {
            comp.setMinimumSize(size);
        }
    }

    public Dimension getMinimumSize() {
        Dimension size = null;
        JComponent comp = this.getJComponent();
        if (comp != null) {
            size = comp.getMinimumSize();
        }
        return size;
    }

    public void setMaximumSize(Dimension size) {
        JComponent comp = this.getJComponent();
        if (comp != null) {
            comp.setMaximumSize(size);
        }
    }

    public Dimension getMaximumSize() {
        Dimension size = null;
        JComponent comp = this.getJComponent();
        if (comp != null) {
            size = comp.getMaximumSize();
        }
        return size;
    }

    public void setSize(Dimension size) {
        JComponent comp = this.getJComponent();
        if (comp != null) {
            comp.setSize(size);
            comp.setPreferredSize(size);
            comp.invalidate();
            comp.revalidate();
            comp.repaint();
        }
    }

    public Dimension getSize() {
        return this.getJComponent().getSize();
    }

    public void setUserSize(Dimension size) {
        if (this.userSize == null || !this.userSize.equals(size)) {
            this.userSize = size;
        }
        this.setSize(this.userSize);
    }

    public Dimension getUserSize() {
        Dimension size = this.userSize == null ? this.getPreferredSize() : this.userSize;
        return size;
    }

    public void setPreferredSize(Dimension size) {
        JComponent comp = this.getJComponent();
        if (comp != null) {
            comp.setPreferredSize(size);
        }
    }

    public Dimension getPreferredSize() {
        return this.getJComponent().getPreferredSize();
    }

    public void resize(int dx, int dy) {
        JComponent comp = this.getJComponent();
        if (comp != null) {
            Dimension min = this.getMinimumSize();
            Dimension max = this.getMaximumSize();
            int width = comp.getWidth() + dx;
            int height = comp.getHeight() + dy;
            if (width < min.width || width > max.width) {
                width = width < min.width ? min.width : max.width;
            }
            if (height < min.height || height > max.height) {
                height = height < min.height ? min.height : max.height;
            }
            this.setUserSize(new Dimension(width, height));
        }
    }
}

