/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.FSABend;
import de.uni_paderborn.fujaba.fsa.FSABendLine;
import de.uni_paderborn.fujaba.fsa.FSAGrab;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.actions.AddBendAction;
import de.uni_paderborn.fujaba.fsa.swing.DecoratorLayout;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JPolyLine;
import de.uni_paderborn.fujaba.fsa.swing.LineDecoratorConstraints;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import java.awt.Container;
import java.awt.Point;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.border.BevelBorder;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class FSAPolyLine
extends FSABendLine {
    public static final String ARRANGE_LOOP_BEND = "arrangeLoopBend";
    private static Logger logger;
    private int numberOfAdditionalBends;
    public static final String LAYOUT_MANAGER_LOCATION = "ldc_";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.fsa.FSAPolyLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public FSAPolyLine(LogicUnparseInterface incr, String propName) {
        super(incr, propName);
    }

    public FSAPolyLine(LogicUnparseInterface incr, String propName, JComponent parent, JComponent myJComponent) {
        super(incr, propName, parent, myJComponent);
    }

    public FSAPolyLine(LogicUnparseInterface incr, String propName, JComponent parent) {
        super(incr, propName, parent);
        if (incr instanceof UMLAssoc && "items".equals(((UMLAssoc)incr).getName())) {
            this.getJComponent().setBorder(new BevelBorder(0));
        }
    }

    protected JComponent createJComponent() {
        JPolyLine line = new JPolyLine(new JBend(new Point(0, 0)), new JBend(new Point(0, 0)));
        line.setBackground(FSAObject.COLOR_BACKGROUND);
        line.setForeground(FSAObject.COLOR_FOREGROUND);
        return line;
    }

    public void arrangeLoopBends() {
        JPolyLine polyLine = (JPolyLine)this.getJComponent();
        FSABend start = this.getStartBend();
        FSABend end = this.getEndBend();
        if (start instanceof FSAGrab && end instanceof FSAGrab) {
            FSAObject startObj = ((FSAGrab)start).getTarget();
            FSAObject endObj = ((FSAGrab)end).getTarget();
            if (startObj != null && startObj.equals(endObj)) {
                Point point = new Point(startObj.getLocation());
                point.translate(-30, 10);
                FSABend bend = AddBendAction.newBend(this, point);
                bend.addUnparseInformation(ARRANGE_LOOP_BEND, "true");
                polyLine.insertInBends(1, (JBend)bend.getJComponent());
                point.translate(0, -40);
                bend = AddBendAction.newBend(this, point);
                bend.addUnparseInformation(ARRANGE_LOOP_BEND, "true");
                polyLine.insertInBends(2, (JBend)bend.getJComponent());
                point.translate(40, 0);
                bend = AddBendAction.newBend(this, point);
                bend.addUnparseInformation(ARRANGE_LOOP_BEND, "true");
                polyLine.insertInBends(3, (JBend)bend.getJComponent());
            } else {
                JBendLine line = (JBendLine)this.getJComponent();
                if (line != null) {
                    ListIterator iter = line.iteratorOfBends();
                    while (iter.hasNext()) {
                        JBend bend = (JBend)iter.next();
                        FSABend fsaBend = (FSABend)FSAObject.getFSAObjectFromJComponent(bend);
                        if (fsaBend.getUnparseInformation(ARRANGE_LOOP_BEND) == null) continue;
                        this.removeBend(bend);
                    }
                }
            }
        }
    }

    public void setStartBend(FSABend bend) {
        super.setStartBend(bend);
        if (((JPolyLine)this.getJComponent()).sizeOfBends() == 2) {
            this.arrangeLoopBends();
        }
    }

    public void setEndBend(FSABend bend) {
        super.setEndBend(bend);
        if (((JPolyLine)this.getJComponent()).sizeOfBends() == 2) {
            this.arrangeLoopBends();
        }
    }

    public void removeYou() {
        JBendLine line = (JBendLine)this.getJComponent();
        line.removeYou();
        super.removeYou();
    }

    public void removeYouWithBends(boolean force) {
        JBendLine line = (JBendLine)this.getJComponent();
        if (line != null) {
            JBend bend;
            LinkedList<JBend> bends = null;
            Iterator iter = line.iteratorOfBends();
            while (iter.hasNext()) {
                bend = (JBend)iter.next();
                if (bend == null) continue;
                if (bends == null) {
                    bends = new LinkedList<JBend>();
                }
                bends.add(bend);
            }
            this.removeYou();
            if (bends != null) {
                iter = bends.iterator();
                while (iter.hasNext()) {
                    bend = (JBend)iter.next();
                    if (!force && bend.sizeOfLines() != 0) continue;
                    this.removeBend(bend);
                }
            }
        } else {
            this.removeYou();
        }
    }

    protected void removeBend(JBend bend) {
        FSAObject fsa = FSAObject.getFSAObjectFromJComponent(bend);
        if (fsa != null) {
            fsa.removeYou();
        }
        bend.removeAllFromLines();
        Container parent = bend.getParent();
        if (parent != null) {
            parent.remove(bend);
        }
    }

    protected void oldInitLocation() {
        LogicUnparseInterface incr = this.getLogic();
        if (incr instanceof ASGElement) {
            ASGElement asgElement = (ASGElement)incr;
            int i = 1;
            ASGElement asgParent = this.getFSAQualifier();
            Point point = asgElement.getPointFromUnparseInformation(asgParent, "bend" + i);
            if (point == null) {
                point = asgElement.getPointFromUnparseInformation(asgElement, "bend" + i);
            }
            while (point != null) {
                FSABend bend = AddBendAction.newBend(this, point);
                ((JPolyLine)this.getJComponent()).insertInBends(i, (JBend)bend.getJComponent());
                point = asgElement.getPointFromUnparseInformation(asgParent, "bend" + ++i);
                if (point != null) continue;
                point = asgElement.getPointFromUnparseInformation(asgElement, "bend" + i);
            }
        }
    }

    protected void applyProperties() {
        super.applyProperties();
        int i = 1;
        Point bendLocation = this.getPointFromUnparseInformation("bendLocation_" + i);
        while (bendLocation != null) {
            FSABend bend = AddBendAction.newBend(this, bendLocation);
            ((JPolyLine)this.getJComponent()).insertInBends(i, (JBend)bend.getJComponent());
            if (logger.isEnabledFor(Priority.DEBUG)) {
                logger.debug((Object)("Bend #" + i + " (" + bendLocation.x + "/" + bendLocation.y + ") restored from unparse-information " + "of polyline with ID " + this.getID()));
            }
            bendLocation = this.getPointFromUnparseInformation("bendLocation_" + ++i);
        }
        if (i == 1) {
            this.oldInitLocation();
        }
        this.numberOfAdditionalBends = ((JPolyLine)this.getJComponent()).sizeOfBends() - 2;
    }

    protected void saveAdditionalFSAProperties() {
        this.saveAdditionalBendLocation();
        this.saveLayoutManagerLocations();
    }

    public void saveAdditionalBendLocation() {
        JPolyLine jPolyLine = (JPolyLine)this.getJComponent();
        this.numberOfAdditionalBends = jPolyLine.sizeOfBends() - 2;
        int i = 1;
        while (i <= this.numberOfAdditionalBends) {
            JBend bend = jPolyLine.getFromBends(i);
            Point bendLocation = bend.getLocation();
            this.addPointToUnparseInformation("bendLocation_" + i, bendLocation);
            if (logger.isEnabledFor(Priority.DEBUG)) {
                logger.debug((Object)("Bend #" + i + " (" + bendLocation.x + "/" + bendLocation.y + ") added to unparse-information " + "of polyline with ID " + this.getID()));
            }
            ++i;
        }
    }

    public void saveLayoutManagerLocations() {
        JPolyLine jPolyLine = (JPolyLine)this.getJComponent();
        if (jPolyLine.getLayout() instanceof DecoratorLayout) {
            DecoratorLayout layout = (DecoratorLayout)jPolyLine.getLayout();
            Iterator iter = this.iteratorOfChildren();
            while (iter.hasNext()) {
                FSAObject fsa = (FSAObject)iter.next();
                LogicUnparseInterface lui = this.getLogic();
                ASGElement incr = (ASGElement)lui;
                DecoratorLayout.Constraints constraints = layout.getConstraintsFromLayoutComponents(fsa.getJComponent());
                if (!(constraints instanceof LineDecoratorConstraints)) continue;
                LineDecoratorConstraints ldc = (LineDecoratorConstraints)constraints;
                Point ldcPosition = new Point((int)(1000.0 * ldc.getPosition()), (int)(1000.0 * ldc.getGap()));
                this.addPointToUnparseInformation(LAYOUT_MANAGER_LOCATION + incr.getName() + "_" + fsa.getPropertyName(), ldcPosition);
            }
        }
    }

    public void clearAdditionalBendLocation() {
        int i = 1;
        while (i <= this.numberOfAdditionalBends) {
            if (this.removePointFromUnparseInformation("bendLocation_" + i) && logger.isEnabledFor(Priority.DEBUG)) {
                logger.debug((Object)("Bend #" + i + " removed from unparse-information " + "of polyline with ID " + this.getID()));
            }
            ++i;
        }
        this.numberOfAdditionalBends = 0;
    }
}

