/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGInformation;
import de.uni_paderborn.fujaba.asg.ASGUnparseInformation;
import de.uni_paderborn.fujaba.basic.BasicIncrement;
import de.uni_paderborn.fujaba.basic.FujabaPropertyChangeSupport;
import de.uni_paderborn.fujaba.fsa.FSAContainer;
import de.uni_paderborn.fujaba.fsa.FSALayeredPane;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.listener.ForegroundHighlighter;
import de.uni_paderborn.fujaba.fsa.listener.ParentEvent;
import de.uni_paderborn.fujaba.fsa.listener.ParentListener;
import de.uni_paderborn.fujaba.fsa.listener.ParentNotifier;
import de.uni_paderborn.fujaba.fsa.unparse.FSAInterface;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.AbstractUpdater;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.upb.lib.userinterface.UserInterfaceManager;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.AncestorListener;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class FSAObject
extends BasicIncrement
implements PropertyChangeListener,
ParentListener {
    private static final transient Logger log;
    public static final String JCOMPONENT_CLIENT_PROPERTY = "FSAObject:revJComponent";
    public static final Color COLOR_FOREGROUND;
    public static final Color COLOR_BACKGROUND;
    public static final Color COLOR_FOCUSED;
    public static final Color COLOR_SELECTED;
    public static final String LOCATION = "location";
    public static final String DIMENSION = "dimension";
    private String propertyName = null;
    private final JComponent jComponent;
    private PropertyChangeListener asgInformationListener = new ASGInformationListener(this);
    boolean writingASGInformation = false;
    public static transient boolean TRANSIENT_PROPERTIES_DEFAULT;
    private transient boolean transientProperties = TRANSIENT_PROPERTIES_DEFAULT;
    static final Logger logger;
    private FSAInterface fsaInterface;
    private FHashSet updater;
    private transient ParentNotifier parentNotifier = null;
    private transient FSAContainer currentParent = null;
    private transient String currentQualifiedName = null;
    private transient FujabaPropertyChangeSupport propertyChangeSupport = null;
    private boolean underlined;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.fsa.FSAObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        COLOR_FOREGROUND = ColorsPreferences.get().DEFAULT_FOREGROUND;
        COLOR_BACKGROUND = ColorsPreferences.get().DEFAULT_BACKGROUND;
        COLOR_FOCUSED = ColorsPreferences.get().DEFAULT_FOCUSED;
        COLOR_SELECTED = ColorsPreferences.get().DEFAULT_SELECTED;
        TRANSIENT_PROPERTIES_DEFAULT = true;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.uni_paderborn.fujaba.fsa.FSAObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz2);
    }

    public FSAObject() {
        this(null, null);
    }

    public FSAObject(LogicUnparseInterface incr, String propName) {
        this(incr, propName, null);
    }

    public FSAObject(LogicUnparseInterface incr, String propName, JComponent parent) {
        this.jComponent = this.createJComponent();
        FSAObject.setFSAObjectFromJComponent(this.jComponent, this);
        this.setParentOfJComponent(parent);
        this.init(incr, propName, TRANSIENT_PROPERTIES_DEFAULT);
    }

    public FSAObject(LogicUnparseInterface incr, String propName, JComponent parent, boolean transientProperties) {
        this.jComponent = this.createJComponent();
        FSAObject.setFSAObjectFromJComponent(this.jComponent, this);
        this.setParentOfJComponent(parent);
        this.init(incr, propName, transientProperties);
    }

    public FSAObject(LogicUnparseInterface incr, String propName, JComponent parent, JComponent myJComponent) {
        this.jComponent = this.retrieveJComponent(myJComponent);
        FSAObject.setFSAObjectFromJComponent(this.jComponent, this);
        this.setParentOfJComponent(parent);
        this.init(incr, propName, TRANSIENT_PROPERTIES_DEFAULT);
    }

    private JComponent retrieveJComponent(JComponent myJComponent) {
        JComponent tmpComp = null;
        if (myJComponent != null) {
            if (FSAObject.getFSAObjectFromJComponent(myJComponent) != null) {
                throw new IllegalArgumentException("JComponent already has a FSAObject");
            }
            tmpComp = myJComponent;
        } else {
            tmpComp = this.createJComponent();
        }
        return tmpComp;
    }

    private void init(LogicUnparseInterface incr, String propName, boolean transientProperties) {
        this.addParentListener(this);
        this.setPropertyName(propName);
        this.setLogic(incr);
        this.transientProperties = transientProperties;
        this.initFSAProperties();
    }

    public ASGElement getFSAQualifier() {
        FSAContainer fsa = this.getParent();
        LogicUnparseInterface diag = null;
        ASGElement firstElement = null;
        while (fsa != null && !(diag instanceof ASGDiagram)) {
            diag = fsa.getLogic();
            if (firstElement == null && diag instanceof ASGElement) {
                firstElement = (ASGElement)diag;
            }
            fsa = fsa.getParent();
        }
        if (diag instanceof ASGDiagram) {
            return (ASGDiagram)diag;
        }
        return firstElement;
    }

    public ASGInformation getASGInformation() {
        return this.getASGInformation(false);
    }

    public ASGInformation getASGInformation(boolean create) {
        LogicUnparseInterface incr = this.getLogic();
        if (incr instanceof ASGElement) {
            ASGElement asgElement = (ASGElement)incr;
            ASGElement asgParent = this.getFSAQualifier();
            ASGUnparseInformation unparseInfo = asgElement.getFromUnparseInformations(asgParent);
            if (create && unparseInfo == null) {
                unparseInfo = new ASGUnparseInformation();
                asgElement.addToUnparseInformations(asgParent, unparseInfo);
            }
            if (unparseInfo != null) {
                ASGInformation info = unparseInfo.getFromASGInformation(this.getPropertyName());
                if (create && info == null) {
                    info = new ASGInformation();
                    unparseInfo.addToASGInformation(this.getPropertyName(), info);
                }
                if (info != null) {
                    info.addPropertyChangeListener(this.asgInformationListener);
                }
                return info;
            }
        }
        return null;
    }

    public String getUnparseInformation(String property) {
        ASGInformation info = this.getASGInformation();
        if (info != null) {
            return info.getFromInformation(property);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addUnparseInformation(String property, String value) {
        this.writingASGInformation = true;
        try {
            this.getASGInformation(true).addToInformation(property, value);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.writingASGInformation = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.writingASGInformation = false;
            return;
        }
    }

    public boolean removeFromUnparseInformation(String property) {
        this.writingASGInformation = true;
        boolean success = false;
        ASGInformation info = this.getASGInformation();
        if (info != null) {
            success = info.removeKeyFromInformation(property);
        }
        this.writingASGInformation = false;
        return success;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAllUnparseInformation() {
        ASGInformation info = this.getASGInformation();
        if (info == null) return;
        this.writingASGInformation = true;
        try {
            ASGUnparseInformation parent = info.getParent();
            info.removeYou();
            if (parent != null && parent.sizeOfASGInformation() == 0) {
                parent.removeYou();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.writingASGInformation = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.writingASGInformation = false;
            return;
        }
    }

    public void addPointToUnparseInformation(String property, Point value) {
        if (value == null) {
            return;
        }
        this.addUnparseInformation(String.valueOf(property) + "_X", Integer.toString(value.x));
        this.addUnparseInformation(String.valueOf(property) + "_Y", Integer.toString(value.y));
    }

    public boolean removePointFromUnparseInformation(String property) {
        boolean success = this.removeFromUnparseInformation(String.valueOf(property) + "_X");
        return success |= this.removeFromUnparseInformation(String.valueOf(property) + "_Y");
    }

    public Point getPointFromUnparseInformation(String property) {
        Point p = null;
        String xValue = this.getUnparseInformation(String.valueOf(property) + "_X");
        String yValue = this.getUnparseInformation(String.valueOf(property) + "_Y");
        if (xValue != null && yValue != null) {
            try {
                p = new Point(Integer.parseInt(xValue), Integer.parseInt(yValue));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return p;
    }

    public void addDimensionToUnparseInformation(String property, Dimension value) {
        this.addUnparseInformation(String.valueOf(property) + "_Width", Integer.toString(value.width));
        this.addUnparseInformation(String.valueOf(property) + "_Height", Integer.toString(value.height));
    }

    public Dimension getDimensionFromUnparseInformation(String property) {
        Dimension dim = null;
        String width = this.getUnparseInformation(String.valueOf(property) + "_Width");
        String height = this.getUnparseInformation(String.valueOf(property) + "_Height");
        if (width != null && height != null) {
            try {
                dim = new Dimension(Integer.parseInt(width), Integer.parseInt(height));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return dim;
    }

    protected void initFSAProperties() {
        if (this.jComponent == null) {
            return;
        }
        int iPropertyInfoSize = 0;
        ASGInformation info = this.getASGInformation();
        if (info != null) {
            iPropertyInfoSize = info.sizeOfInformation();
        }
        if (iPropertyInfoSize > 0) {
            this.applyProperties();
            this.setTransientProperties(false);
        } else {
            this.setDefaultProperties();
        }
    }

    protected void setDefaultProperties() {
        if (this.jComponent.getX() == 0 && this.jComponent.getY() == 0) {
            this.initLocation();
            if (!this.isTransientProperties()) {
                this.saveLocation();
            }
        }
    }

    protected void initLocation() {
        Point cursorPosition = UserInterfaceManager.get().getLastPointerPosition();
        if (cursorPosition != null) {
            this.jComponent.setLocation(cursorPosition);
            UserInterfaceManager.get().setLastPointerPosition(null);
        } else {
            this.jComponent.setLocation((int)(Math.random() * 400.0), (int)(Math.random() * 200.0));
        }
    }

    protected void applyProperties() {
        Dimension dimension;
        Point location = this.getPointFromUnparseInformation(LOCATION);
        if (location != null) {
            this.jComponent.setLocation(location);
        }
        if ((dimension = this.getDimensionFromUnparseInformation(DIMENSION)) != null) {
            this.jComponent.setPreferredSize(dimension);
        }
    }

    public boolean isTransientProperties() {
        return this.transientProperties;
    }

    public void setTransientProperties(boolean enabled) {
        if (this.transientProperties == enabled) {
            return;
        }
        this.transientProperties = enabled;
        if (enabled) {
            this.removeAllUnparseInformation();
        }
    }

    public void saveFSAProperties() {
        if (!this.isTransientProperties()) {
            this.saveLocation();
            this.saveAdditionalFSAProperties();
            if (this.getID().equals(this.getPropertyName()) || this.getPropertyName() == null) {
                logger.warn((Object)"do not use null propertyName for persistent FSAs - loss of layout may be the result!");
            }
        } else {
            this.removeAllUnparseInformation();
        }
    }

    public void saveLocation() {
        this.addPointToUnparseInformation(LOCATION, this.getLocation());
    }

    public void saveDimension() {
        if (this.getJComponent() != null) {
            this.addDimensionToUnparseInformation(DIMENSION, this.getJComponent().getSize());
        }
    }

    protected void saveAdditionalFSAProperties() {
    }

    public Class getDefaultUpdaterClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("de.uni_paderborn.fujaba.fsa.update.LogicAndFsaUpdater");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public AbstractUpdater createDefaultUpdater() {
        Class updaterClass = this.getDefaultUpdaterClass();
        AbstractUpdater result = null;
        if (updaterClass != null) {
            try {
                result = (AbstractUpdater)updaterClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception in " + this + ".createDefaultUpdater: " + e.getMessage());
            }
            result.setLogicObject(this.getLogic());
            result.setLogicAttrName(this.propertyName);
            result.setFsaAttrName(this.getDefaultAttrName());
            try {
                result.setListenerActive(true);
            }
            catch (Exception e) {
                log.error((Object)("Listener not added for " + result));
            }
        }
        return result;
    }

    public String getDefaultAttrName() {
        return null;
    }

    public String getPropertyName() {
        if (this.propertyName == null) {
            this.setPropertyName(this.getID());
        }
        return this.propertyName;
    }

    public String setPropertyName(String propertyName) {
        if (propertyName == null) {
            if (logger.isEnabledFor(Priority.WARN) && !this.isTransientProperties()) {
                logger.warn((Object)"do not use null propertyName for FSAs - loss of layout may be the result!");
            }
            propertyName = this.getID();
        }
        if (this.propertyName == null || !this.propertyName.equals(propertyName)) {
            FSAInterface iface = this.getFSAInterface();
            if (iface != null) {
                iface.removeFromFsaObjects(this);
            }
            this.propertyName = propertyName;
            if (iface != null) {
                iface.addToFsaObjects(this);
            }
        }
        return this.propertyName;
    }

    public String getParentID() {
        return FSAObject.getID(this.getParent());
    }

    public static String getID(FSAObject object) {
        String id = "@__null";
        if (object != null) {
            id = object.getID();
        }
        return id;
    }

    public String getQualifiedName() {
        String name = FSAObject.getQualifiedName(this.getParent(), this.getPropertyName());
        if (!name.equals(this.currentQualifiedName)) {
            this.currentQualifiedName = name;
        }
        return name;
    }

    public static String getQualifiedName(FSAObject parent, String name) {
        return String.valueOf(FSAObject.getID(parent)) + "." + name;
    }

    protected abstract JComponent createJComponent();

    public JComponent getJComponent() {
        return this.jComponent;
    }

    public static JComponent getJComponent(FSAObject object) {
        if (object == null) {
            return null;
        }
        return object.getJComponent();
    }

    public Container getParentOfJComponent() {
        return this.jComponent == null ? null : this.jComponent.getParent();
    }

    public void setParentOfJComponent(Container comp) {
        Container parent = this.jComponent.getParent();
        if (parent != null && parent != comp) {
            parent.remove(this.jComponent);
        }
        if (comp != null && parent != comp) {
            comp.add(this.jComponent);
        }
    }

    public static LogicUnparseInterface getLogicFromJComponent(JComponent comp) {
        FSAObject fsa = FSAObject.getFSAObjectFromJComponent(comp);
        if (fsa != null) {
            return fsa.getLogic();
        }
        return null;
    }

    public static FSAObject findFSAObjectFromJComponent(JComponent comp) {
        FSAObject result = null;
        while (comp != null && result == null) {
            result = FSAObject.getFSAObjectFromJComponent(comp);
            if (result != null) continue;
            Container parent = comp.getParent();
            comp = parent instanceof JComponent ? (JComponent)parent : null;
        }
        return result;
    }

    public static FSAObject getFSAObjectFromJComponent(JComponent comp) {
        if (comp != null) {
            return (FSAObject)comp.getClientProperty(JCOMPONENT_CLIENT_PROPERTY);
        }
        return null;
    }

    protected static void setFSAObjectFromJComponent(JComponent jComp, FSAObject fsaComp) {
        if (jComp != null) {
            jComp.putClientProperty(JCOMPONENT_CLIENT_PROPERTY, fsaComp);
        }
    }

    public FSAObject findChildForProperty(String property) {
        FSAObject obj = this;
        FSAObject result = null;
        while (result == null && obj != null) {
            String objProp = obj.getPropertyName();
            if (property == null && objProp == null || property != null && property.equals(objProp)) {
                result = obj;
                continue;
            }
            obj = obj.getParent();
        }
        return result;
    }

    public FSALayeredPane getDiagramRoot() {
        FSAObject current = this;
        FSAContainer parent = this.getParent();
        while (parent != null) {
            current = parent;
            parent = current.getParent();
        }
        if (current instanceof FSALayeredPane) {
            return (FSALayeredPane)current;
        }
        return null;
    }

    public FSAContainer getParent() {
        Container parentComponent = this.getParentOfJComponent();
        FSAObject parent = null;
        while (parentComponent != null && parent == null) {
            Object parentCandidate;
            if (parentComponent instanceof JComponent && (parentCandidate = ((JComponent)parentComponent).getClientProperty(JCOMPONENT_CLIENT_PROPERTY)) != null && parentCandidate instanceof FSAObject) {
                if (parentCandidate instanceof FSAContainer) {
                    parent = (FSAObject)parentCandidate;
                } else {
                    throw new RuntimeException("FSAObject " + parentCandidate + " should not have children, as it is no FSAContainer!");
                }
            }
            parentComponent = parentComponent.getParent();
        }
        return (FSAContainer)parent;
    }

    public Dimension getPreferredSize() {
        if (this.jComponent == null) {
            return null;
        }
        return this.jComponent.getPreferredSize();
    }

    public void setPreferredSize(Dimension newDimension) {
        if (this.getJComponent() != null) {
            this.getJComponent().setPreferredSize(newDimension);
        }
    }

    public Dimension getMinimumSize() {
        if (this.jComponent == null) {
            return null;
        }
        return this.jComponent.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        if (this.jComponent == null) {
            return null;
        }
        return this.jComponent.getMaximumSize();
    }

    public void setSelected(boolean selected) {
        this.firePropertyChange("selected", !selected, selected);
    }

    public boolean isSelected() {
        return SelectionManager.get().hasInSelectedComponents(this.getJComponent());
    }

    public void setFocused(boolean focus) {
        this.firePropertyChange("focused", !focus, focus);
    }

    public boolean isFocused() {
        return SelectionManager.get().getFocusedComponent() == this.getJComponent();
    }

    public void setFSAInterface(FSAInterface elem) {
        if (this.fsaInterface != elem) {
            FSAInterface oldFSAInterface = this.fsaInterface;
            if (this.fsaInterface != null) {
                this.fsaInterface = null;
                oldFSAInterface.removeFromFsaObjects(this);
            }
            this.fsaInterface = elem;
            if (elem != null) {
                elem.addToFsaObjects(this);
            }
        }
    }

    public FSAInterface getFSAInterface() {
        return this.fsaInterface;
    }

    public void setLogic(LogicUnparseInterface elem) {
        if (this.getLogic() != elem) {
            FSAInterface iface = null;
            if (elem != null && (iface = elem.getFSAInterface()) == null) {
                throw new UnsupportedOperationException("The element does not support the FSA interface");
            }
            this.setFSAInterface(iface);
        }
    }

    public LogicUnparseInterface getLogic() {
        if (this.fsaInterface == null) {
            return null;
        }
        return this.fsaInterface.getLogic();
    }

    public LogicUnparseInterface getLogic(boolean recursive) {
        FSAContainer container = null;
        LogicUnparseInterface result = this.getLogic();
        if (result == null && (container = this.getParent()) != null) {
            result = container.getLogic();
        }
        return result;
    }

    public boolean addToUpdater(AbstractUpdater value) {
        boolean changed = false;
        if (value != null) {
            if (this.updater == null) {
                this.updater = new FHashSet();
            }
            try {
                changed = this.updater.add(value);
                if (changed) {
                    value.setFsaObject(this);
                }
            }
            catch (Exception e) {
                log.error((Object)("Problem during initialization of updater. Removing updater: " + value));
                e.printStackTrace();
                this.updater.remove(value);
            }
        }
        return changed;
    }

    public boolean hasInUpdater(AbstractUpdater value) {
        return this.updater != null && value != null && this.updater.contains(value);
    }

    public Iterator iteratorOfUpdater() {
        return this.updater == null ? FEmptyIterator.get() : this.updater.iterator();
    }

    public int sizeOfUpdater() {
        return this.updater == null ? 0 : this.updater.size();
    }

    public boolean removeFromUpdater(AbstractUpdater value) {
        boolean changed = false;
        if (this.updater != null && value != null && (changed = this.updater.remove(value))) {
            value.setFsaObject(null);
        }
        return changed;
    }

    public void removeAllFromUpdater() {
        Iterator iter = this.iteratorOfUpdater();
        while (iter.hasNext()) {
            AbstractUpdater tmpValue = (AbstractUpdater)iter.next();
            this.removeFromUpdater(tmpValue);
        }
    }

    public void removeYou() {
        ASGInformation info;
        if (this.asgInformationListener != null && (info = this.getASGInformation(false)) != null) {
            info.removePropertyChangeListener(this.asgInformationListener);
        }
        this.setParentOfJComponent(null);
        this.removeAllFromUpdater();
        this.setFSAInterface(null);
        this.setSelected(false);
        super.removeYou();
    }

    public boolean isDelegated() {
        return false;
    }

    public void addParentListener(ParentListener listener) {
        if (listener != null) {
            if (this.parentNotifier == null) {
                this.parentNotifier = new ParentNotifier(this);
            }
            this.parentNotifier.addListener(listener);
        }
    }

    public void removeParentListener(ParentListener listener) {
        if (listener != null && this.parentNotifier != null) {
            this.parentNotifier.removeListener(listener);
        }
    }

    public void parentChanged(ParentEvent evt) {
        FSAContainer newParent = evt.getNewParent();
        String oldName = this.currentQualifiedName;
        this.currentQualifiedName = null;
        if (this.currentParent != newParent) {
            if (this.fsaInterface != null) {
                this.fsaInterface.updateKeyInFsaObjects(oldName, this);
            }
            this.currentParent = newParent;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new FujabaPropertyChangeSupport(this);
        }
        if (this.jComponent != null) {
            Iterator iter = this.propertyChangeSupport.keysOfChildren();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                this.jComponent.removePropertyChangeListener(key, this);
            }
            if (this.propertyChangeSupport.sizeOfListeners() == 0) {
                this.jComponent.addPropertyChangeListener(this);
            }
        }
        this.propertyChangeSupport.addToListeners(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new FujabaPropertyChangeSupport(this);
        }
        if (this.jComponent != null && !this.propertyChangeSupport.hasListeners(propertyName)) {
            this.jComponent.addPropertyChangeListener(propertyName, this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        block5: {
            if (this.propertyChangeSupport == null) break block5;
            boolean globalListener = this.propertyChangeSupport.hasInListeners(listener);
            this.propertyChangeSupport.removePropertyChangeListener(listener);
            if (this.jComponent != null) {
                if (globalListener && this.propertyChangeSupport.sizeOfListeners() == 0) {
                    this.jComponent.removePropertyChangeListener(this);
                    Iterator iter = this.propertyChangeSupport.entriesOfChildren();
                    while (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        if (((FujabaPropertyChangeSupport)entry.getValue()).sizeOfListeners() <= 0) continue;
                        this.jComponent.addPropertyChangeListener((String)entry.getKey(), this);
                    }
                } else {
                    Iterator iter = this.propertyChangeSupport.entriesOfChildren();
                    while (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        if (((FujabaPropertyChangeSupport)entry.getValue()).sizeOfListeners() != 0) continue;
                        this.jComponent.removePropertyChangeListener((String)entry.getKey(), this);
                    }
                }
            }
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
            if (this.jComponent != null && !this.propertyChangeSupport.hasListeners(propertyName)) {
                this.jComponent.removePropertyChangeListener(propertyName, this);
            }
        }
    }

    public Iterator iteratorOfPropertyChangeListeners() {
        return this.propertyChangeSupport == null ? FEmptyIterator.get() : this.propertyChangeSupport.iteratorOfListeners();
    }

    public Iterator iteratorOfPropertyChangeListeners(String property) {
        return this.propertyChangeSupport == null ? FEmptyIterator.get() : this.propertyChangeSupport.iteratorOfListeners(property);
    }

    protected void firePropertyChange(PropertyChangeEvent e) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(e);
        }
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (oldValue == newValue || this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(name, oldValue, newValue);
    }

    protected void firePropertyChange(String name, boolean oldValue, boolean newValue) {
        if (oldValue == newValue || this.propertyChangeSupport == null) {
            return;
        }
        this.firePropertyChange(name, (Object)oldValue, (Object)newValue);
    }

    protected void firePropertyChange(String name, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(name, new Integer(oldValue), new Integer(newValue));
    }

    protected void firePropertyChange(String name, double oldValue, double newValue) {
        if (oldValue == newValue || this.propertyChangeSupport == null) {
            return;
        }
        this.firePropertyChange(name, new Double(oldValue), new Double(newValue));
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.jComponent && this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(event);
        }
    }

    public void addAncestorListener(AncestorListener listener) {
        this.jComponent.addAncestorListener(listener);
    }

    public void removeAncestorListener(AncestorListener listener) {
        this.jComponent.removeAncestorListener(listener);
    }

    public Iterator iteratorOfAncestorListeners() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("javax.swing.event.AncestorListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.jComponent.getListeners(clazz);
        return Arrays.asList(listeners).iterator();
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.jComponent.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.jComponent.removeVetoableChangeListener(listener);
    }

    public Iterator iteratorOfVetoableChangeListeners() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.beans.VetoableChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.jComponent.getListeners(clazz);
        return Arrays.asList(listeners).iterator();
    }

    public void addComponentListener(ComponentListener listener) {
        this.jComponent.addComponentListener(listener);
    }

    public void removeComponentListener(ComponentListener listener) {
        this.jComponent.removeComponentListener(listener);
    }

    public Iterator iteratorOfComponentListeners() {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.awt.event.ComponentListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.jComponent.getListeners(clazz);
        return Arrays.asList(listeners).iterator();
    }

    public void addFocusListener(FocusListener listener) {
        this.jComponent.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.jComponent.removeFocusListener(listener);
    }

    public Iterator iteratorOfFocusListeners() {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.awt.event.FocusListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.jComponent.getListeners(clazz);
        return Arrays.asList(listeners).iterator();
    }

    public void addInputMethodListener(InputMethodListener listener) {
        this.jComponent.addInputMethodListener(listener);
    }

    public void removeInputMethodListener(InputMethodListener listener) {
        this.jComponent.removeInputMethodListener(listener);
    }

    public Iterator iteratorOfInputMethodListeners() {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.awt.event.InputMethodListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.jComponent.getListeners(clazz);
        return Arrays.asList(listeners).iterator();
    }

    public void addKeyListener(KeyListener listener) {
        this.jComponent.addKeyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.jComponent.removeKeyListener(listener);
    }

    public Iterator iteratorOfKeyListeners() {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("java.awt.event.KeyListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.jComponent.getListeners(clazz);
        return Arrays.asList(listeners).iterator();
    }

    public void addMouseListener(MouseListener listener) {
        this.jComponent.addMouseListener(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.jComponent.removeMouseListener(listener);
    }

    public Iterator iteratorOfMouseListeners() {
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("java.awt.event.MouseListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.jComponent.getListeners(clazz);
        return Arrays.asList(listeners).iterator();
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        this.jComponent.addMouseMotionListener(listener);
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.jComponent.removeMouseMotionListener(listener);
    }

    public Iterator iteratorOfMouseMotionListeners() {
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("java.awt.event.MouseMotionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.jComponent.getListeners(clazz);
        return Arrays.asList(listeners).iterator();
    }

    public void setVisible(boolean vis) {
        this.jComponent.setVisible(vis);
    }

    public boolean isVisible() {
        return this.jComponent != null && this.jComponent.isVisible();
    }

    public void setForeground(Color color) {
        this.jComponent.setForeground(color);
        this.jComponent.putClientProperty(ForegroundHighlighter.OLDCOLOR_CLIENTPROPERTY, null);
    }

    public Color getForeground() {
        if (this.jComponent == null) {
            return null;
        }
        return this.jComponent.getForeground();
    }

    public void setBackground(Color color) {
        this.jComponent.setBackground(color);
    }

    public Color getBackground() {
        if (this.jComponent == null) {
            return null;
        }
        return this.jComponent.getBackground();
    }

    public void invalidate() {
        this.jComponent.invalidate();
    }

    public final void setLocation(Point location) {
        if (location != null) {
            this.setLocation(location.x, location.y);
        }
    }

    public void setLocation(int x, int y) {
        Point oldLocation = this.getLocation();
        if (oldLocation.x != x || oldLocation.y != y) {
            this.getJComponent().setLocation(x, y);
        }
    }

    public Point getLocation() {
        if (this.jComponent == null) {
            return null;
        }
        return this.jComponent.getLocation();
    }

    public Dimension getSize() {
        if (this.jComponent == null) {
            return null;
        }
        return this.jComponent.getSize();
    }

    public Point getLocation(Point point) {
        if (this.jComponent == null) {
            return null;
        }
        return this.jComponent.getLocation(point);
    }

    public void dragTo(int newX, int newY) {
        this.setLocation(newX, newY);
        this.setTransientProperties(false);
        this.saveLocation();
    }

    public void dragByDelta(int deltaX, int deltaY) {
        Point location = this.getJComponent().getLocation();
        this.setLocation(location.x + deltaX, location.y + deltaY);
        this.setTransientProperties(false);
        this.saveLocation();
    }

    public void setOpaque(boolean opaque) {
        this.getJComponent().setOpaque(opaque);
    }

    public void setFont(Font newFont) {
        this.getJComponent().setFont(newFont);
    }

    public Font getFont() {
        if (this.jComponent == null) {
            return null;
        }
        return this.jComponent.getFont();
    }

    public void setItalic(boolean italic) {
        Font theFont = this.getFont();
        int style = theFont.getStyle();
        if (theFont.isItalic() != italic) {
            theFont = theFont.deriveFont(style += italic ? 2 : -2);
            this.setFont(theFont);
        }
    }

    public boolean isItalic() {
        Font theFont = this.getFont();
        return theFont.isItalic();
    }

    public void setBold(boolean bold) {
        Font theFont = this.getFont();
        int style = theFont.getStyle();
        if (theFont.isBold() != bold) {
            theFont = theFont.deriveFont(style += bold ? 1 : -1);
            this.setFont(theFont);
        }
    }

    public boolean isBold() {
        Font theFont = this.getFont();
        return theFont.isBold();
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public void setUnderlined(boolean newUnderlined) {
        if (this.underlined != newUnderlined) {
            this.underlined = newUnderlined;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode()) + "{" + this.jComponent + "}";
    }

    private static final class ASGInformationListener
    implements PropertyChangeListener {
        private final WeakReference fsaObject;

        ASGInformationListener(FSAObject obj) {
            this.fsaObject = new WeakReference<FSAObject>(obj);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            FSAObject obj = (FSAObject)this.fsaObject.get();
            if (obj != null && !obj.writingASGInformation) {
                if (logger.isEnabledFor(Priority.DEBUG)) {
                    logger.debug((Object)("ASGInformationListener has been notified about propertychange of '" + evt.getPropertyName() + "': newValue '" + evt.getNewValue() + "', oldValue '" + evt.getOldValue() + "'"));
                }
                obj.applyProperties();
            }
        }
    }
}

