/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa;

import de.uni_paderborn.fujaba.fsa.FSAContainer;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;

public class FSAEditorPane
extends FSAContainer {
    public static HyperlinkListener linkListener = null;
    private JEditorPane myjeditorpane = null;

    public FSAEditorPane(LogicUnparseInterface incr) {
        this(incr, (JComponent)null);
    }

    public FSAEditorPane(LogicUnparseInterface incr, JComponent parent) {
        super(incr, null, parent);
    }

    public FSAEditorPane(LogicUnparseInterface incr, String propName, JComponent parent) {
        super(incr, propName, parent);
    }

    public void setPane(JEditorPane newPane) {
        this.myjeditorpane = newPane;
    }

    public JEditorPane getPane() {
        return this.myjeditorpane;
    }

    public JEditorPane findPane() {
        JComponent jcomp = this.getJComponent();
        while (jcomp != null && !(jcomp instanceof JEditorPane)) {
            jcomp = (JComponent)jcomp.getComponent(0);
        }
        this.myjeditorpane = (JEditorPane)jcomp;
        return this.myjeditorpane;
    }

    protected JComponent createJComponent() {
        this.setPane(new JEditorPane());
        this.getPane().setContentType("text/html");
        this.getPane().setText("<body><h1>empty document</h1></body>");
        this.getPane().setEditable(false);
        if (linkListener != null) {
            JEditorPane myPane = this.getPane();
            myPane.addHyperlinkListener(linkListener);
            myPane.addCaretListener((CaretListener)((Object)linkListener));
        }
        JScrollPane jp = new JScrollPane(this.getPane());
        jp.getAccessibleContext().setAccessibleName("HTML panel");
        jp.getAccessibleContext().setAccessibleDescription("A panel for viewing HTML documents, and following their links");
        return jp;
    }

    public void setLayout(LayoutManager layout) {
        this.getJComponent().setLayout(layout);
    }

    public void addToChildren(FSAObject object) {
        JComponent comp = object.getJComponent();
        JLayeredPane pane = (JLayeredPane)this.getJComponent();
        if (comp != null && pane != null) {
            pane.setLayer(comp, JLayeredPane.DEFAULT_LAYER, 0);
        }
        super.addToChildren(object);
    }

    public void removeFromChildren(FSAObject object) {
        super.removeFromChildren(object);
        JComponent myComp = this.getJComponent();
        if (myComp != null && object != null && object.getJComponent() != null) {
            myComp.repaint();
        }
    }

    public void setJComponentValue(Object value) {
    }

    public Object getJComponentValue() {
        return null;
    }

    public void setSelected(boolean selected) {
    }

    public boolean isSelected() {
        return false;
    }

    public void setFocused(boolean focused) {
    }

    class PaneMouseAdapter
    extends MouseInputAdapter {
        private Point relativePositionOnPress;
        private JPanel panel;
        private HashSet selected;
        private HashSet unselected;

        PaneMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            if ((e.getModifiers() & 2) == 0 && (e.getModifiers() & 1) == 0) {
                SelectionManager.get().clear();
            }
            this.relativePositionOnPress = e.getPoint();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.panel != null) {
                FSAEditorPane.this.getJComponent().remove(this.panel);
                FSAEditorPane.this.getJComponent().repaint();
                this.panel = null;
            }
            this.relativePositionOnPress = null;
            this.unselected = null;
            this.selected = null;
        }

        public void mouseDragged(MouseEvent e) {
            SelectionManager manager = SelectionManager.get();
            Vector<FSAObject> changed = null;
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setOpaque(false);
                this.panel.setBorder(new LineBorder(ColorsPreferences.get().SELECTION_RECT));
                FSAEditorPane.this.getJComponent().add((Component)this.panel, JLayeredPane.DRAG_LAYER);
            }
            if (this.selected == null || this.unselected == null) {
                int maxSize = 0;
                if (FSAEditorPane.this.getChildConnector() != null) {
                    maxSize = FSAEditorPane.this.getChildConnector().getComponentCount();
                }
                this.unselected = new HashSet(maxSize);
                this.selected = new HashSet(maxSize);
                Iterator childIter = FSAEditorPane.this.iteratorOfChildren();
                while (childIter.hasNext()) {
                    FSAObject child = (FSAObject)childIter.next();
                    if (child.isSelected()) {
                        this.selected.add(child);
                        continue;
                    }
                    this.unselected.add(child);
                }
            }
            Point newLocation = e.getPoint();
            if (this.relativePositionOnPress == null) {
                this.relativePositionOnPress = newLocation;
            }
            Rectangle bounds = new Rectangle(Math.min(newLocation.x, this.relativePositionOnPress.x), Math.min(newLocation.y, this.relativePositionOnPress.y), Math.abs(newLocation.x - this.relativePositionOnPress.x), Math.abs(newLocation.y - this.relativePositionOnPress.y));
            Rectangle oldBounds = this.panel.getBounds();
            this.panel.setBounds(bounds);
            if (!bounds.contains(oldBounds)) {
                changed = new Vector<FSAObject>();
                Rectangle[] removedAreas = SwingUtilities.computeDifference(oldBounds, bounds);
                Iterator selIter = this.selected.iterator();
                block1: while (selIter.hasNext()) {
                    FSAObject selObject = (FSAObject)selIter.next();
                    JComponent selComp = selObject.getJComponent();
                    if (selComp == null) continue;
                    Rectangle selBounds = selComp.getBounds();
                    int i = 0;
                    while (i < removedAreas.length) {
                        if (removedAreas[i].intersects(selBounds)) {
                            manager.setSelected(selComp, false, true);
                            selIter.remove();
                            changed.add(selObject);
                            continue block1;
                        }
                        ++i;
                    }
                }
            }
            if (!oldBounds.contains(bounds)) {
                Iterator unselIter = this.unselected.iterator();
                while (unselIter.hasNext()) {
                    Rectangle unselBounds;
                    FSAObject unselObject = (FSAObject)unselIter.next();
                    JComponent unselComp = unselObject.getJComponent();
                    if (unselComp == null || !bounds.contains(unselBounds = unselComp.getBounds())) continue;
                    manager.setSelected(unselComp, true, true);
                    unselIter.remove();
                    this.selected.add(unselObject);
                    break;
                }
            }
            if (changed != null) {
                this.unselected.addAll(changed);
            }
        }
    }
}

