/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.coobra.util;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    private Hashtable filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public ExtensionFileFilter() {
    }

    public ExtensionFileFilter(String extension) {
        this(extension, null);
    }

    public ExtensionFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public ExtensionFileFilter(String[] filters) {
        this(filters, null);
    }

    public ExtensionFileFilter(String[] filters, String description) {
        this();
        int i = 0;
        while (i < filters.length) {
            this.addExtension(filters[i]);
            ++i;
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters.get(extension) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            String extension = filename.substring(i + 1).toLowerCase();
            if ("gz".equals(extension) && (i = filename.lastIndexOf(46, i - 1)) > 0) {
                extension = filename.substring(i + 1).toLowerCase();
            }
            return extension;
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : String.valueOf(this.description) + " (";
                Enumeration extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = String.valueOf(this.fullDescription) + "." + (String)extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = String.valueOf(this.fullDescription) + ", ." + (String)extensions.nextElement();
                    }
                }
                this.fullDescription = String.valueOf(this.fullDescription) + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

