/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.coobra.actions;

import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectServerRepositoryDialog
extends JDialog {
    private static final String NAME_SERVER = "name server";
    private static final String NAME_SERVER_PORT = "name server port";
    private boolean nameServerChecked = true;
    private static final String REPOSITORY_HOST = "repository host";
    private static final String REPOSITORY_PORT = "repository port";
    private Vector historyListData;
    boolean ok = false;
    public static final String PROPERTIES_KEY = "coobra/connect.properties";
    public static final String HISTORY_KEY = "history";
    private JPanel jPanel8;
    private JPanel jPanel7;
    private JPanel jPanel6;
    private JPanel iorTabLabelPanel;
    private JPanel nameTabContentPanel;
    private JPanel nameTabLabelPanel;
    private JPanel nameTabLeftPanel;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JButton cancelButton;
    private JButton okButton;
    private JTextField repositoryName;
    private JTextField login;
    private JPasswordField password;
    private JCheckBox lightweightCheck;
    private JTextField nameServer;
    private JTabbedPane jTabbedPane;
    private JTextField nameServerPort;
    private JTextField ior;
    private JLabel iorLabel;
    private JLabel repositoryNameLabel;
    private JLabel loginLabel;
    private JLabel passwordLabel;
    private JLabel connectOnlyLabel;
    private JCheckBox connectOnly;
    private JLabel lightweightLabel;
    private JLabel portLabel;
    JComboBox nameServerBox;
    private JPanel historyPanel;
    private JList historyList;
    private JButton historyDeleteButton;

    public SelectServerRepositoryDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initComponents();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public boolean isNameServerChecked() {
        return this.nameServerChecked;
    }

    public void setNameServerChecked(boolean nameServerChecked) {
        int port;
        try {
            port = Integer.parseInt(this.nameServerPort.getText());
        }
        catch (NumberFormatException e) {
            port = 0;
        }
        this.nameServerChecked = nameServerChecked;
        if (nameServerChecked) {
            this.nameServerBox.setSelectedItem(NAME_SERVER);
            this.portLabel.setText(NAME_SERVER_PORT);
            this.repositoryName.setEnabled(true);
            if (this.lightweightCheck.isSelected() && port >= 27400 && port - 27400 < 100) {
                this.nameServerPort.setText(String.valueOf(1900));
            }
        } else {
            this.nameServerBox.setSelectedItem(REPOSITORY_HOST);
            this.portLabel.setText(REPOSITORY_PORT);
            this.repositoryName.setEnabled(false);
            if (this.lightweightCheck.isSelected() && port == 1900) {
                this.nameServerPort.setText(String.valueOf(27400));
            }
        }
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.nameTabLabelPanel = new JPanel();
        this.nameTabLeftPanel = new JPanel();
        this.nameServerBox = new JComboBox();
        this.portLabel = new JLabel();
        this.repositoryNameLabel = new JLabel();
        this.loginLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.connectOnlyLabel = new JLabel();
        this.connectOnly = new JCheckBox();
        this.lightweightLabel = new JLabel();
        this.nameTabContentPanel = new JPanel();
        this.nameServer = new JTextField();
        this.nameServerPort = new JTextField();
        this.repositoryName = new JTextField();
        this.login = new JTextField();
        this.password = new JPasswordField();
        this.lightweightCheck = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.jPanel2 = new JPanel();
        this.iorTabLabelPanel = new JPanel();
        this.iorLabel = new JLabel();
        this.jPanel6 = new JPanel();
        this.ior = new JTextField();
        this.jPanel8 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.historyPanel = new JPanel();
        this.historyListData = new Vector();
        this.historyList = new JList(this.historyListData);
        this.historyDeleteButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SelectServerRepositoryDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new EmptyBorder(new Insets(3, 3, 3, 3)));
        this.nameTabLabelPanel.setLayout(new GridLayout(0, 1));
        this.nameServerBox.addItem(NAME_SERVER);
        this.nameServerBox.addItem(REPOSITORY_HOST);
        this.setNameServerChecked(true);
        this.nameServerBox.setSelectedItem("");
        this.nameServerBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectServerRepositoryDialog.this.setNameServerChecked(SelectServerRepositoryDialog.NAME_SERVER.equals(SelectServerRepositoryDialog.this.nameServerBox.getSelectedItem()));
            }
        });
        this.nameTabLabelPanel.add(this.nameServerBox);
        this.nameTabLabelPanel.add(this.portLabel);
        this.repositoryNameLabel.setText("repository name");
        this.nameTabLabelPanel.add(this.repositoryNameLabel);
        this.lightweightLabel.setText("lightweight");
        this.nameTabLabelPanel.add(this.lightweightLabel);
        this.loginLabel.setText("user name");
        this.nameTabLabelPanel.add(this.loginLabel);
        this.passwordLabel.setText("password");
        this.nameTabLabelPanel.add(this.passwordLabel);
        this.connectOnlyLabel.setText("connect only");
        this.nameTabLabelPanel.add(this.connectOnlyLabel);
        this.nameTabLeftPanel.setLayout(new BorderLayout());
        this.nameTabLeftPanel.add((Component)this.nameTabLabelPanel, "West");
        JPanel nameTabLeftPanelSurround = new JPanel();
        nameTabLeftPanelSurround.setLayout(new BorderLayout());
        nameTabLeftPanelSurround.add((Component)this.nameTabLeftPanel, "North");
        this.jPanel1.add((Component)nameTabLeftPanelSurround, "West");
        this.nameTabContentPanel.setLayout(new GridLayout(0, 1));
        this.nameTabContentPanel.setBorder(new EmptyBorder(new Insets(0, 5, 0, 0)));
        this.nameServer.setText("www.se.eecs.uni-kassel.de");
        this.nameTabContentPanel.add(this.nameServer);
        this.nameServerPort.setText("1900");
        this.nameTabContentPanel.add(this.nameServerPort);
        this.repositoryName.setText("ServerRepository");
        this.nameTabContentPanel.add(this.repositoryName);
        this.lightweightCheck.setSelected(true);
        this.nameTabContentPanel.add(this.lightweightCheck);
        this.login.setText("guest");
        this.nameTabContentPanel.add(this.login);
        this.password.setText("guest");
        this.nameTabContentPanel.add(this.password);
        this.connectOnly.setSelected(false);
        this.nameTabContentPanel.add(this.connectOnly);
        this.historyPanel.setLayout(new BorderLayout());
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(5, 5));
        this.historyPanel.add((Component)spacer, "West");
        JPanel historyContentPanel = new JPanel();
        historyContentPanel.setLayout(new BorderLayout());
        historyContentPanel.add((Component)new JScrollPane(this.historyList), "Center");
        this.historyDeleteButton.setText("delete entry");
        historyContentPanel.add((Component)this.historyDeleteButton, "South");
        this.historyPanel.add((Component)historyContentPanel, "Center");
        this.historyDeleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectServerRepositoryDialog.this.historyDeleteButtonActionPerformed(evt);
            }
        });
        this.historyList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SelectServerRepositoryDialog.this.listEntrySelected();
            }
        });
        this.historyList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SelectServerRepositoryDialog.this.listEntrySelected();
            }
        });
        this.nameTabLeftPanel.add((Component)this.nameTabContentPanel, "Center");
        this.jPanel1.add((Component)this.jPanel7, "South");
        this.jPanel1.add((Component)this.historyPanel, "East");
        this.jTabbedPane.addTab("by name", this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setBorder(new EmptyBorder(new Insets(3, 3, 3, 3)));
        this.iorTabLabelPanel.setLayout(new BorderLayout());
        this.iorTabLabelPanel.setBorder(new EmptyBorder(new Insets(3, 0, 0, 0)));
        this.iorLabel.setText("IOR of server repository");
        this.iorLabel.setMaximumSize(new Dimension(117, 22));
        this.iorLabel.setMinimumSize(new Dimension(117, 22));
        this.iorTabLabelPanel.add((Component)this.iorLabel, "North");
        this.jPanel2.add((Component)this.iorTabLabelPanel, "West");
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel6.setBorder(new EmptyBorder(new Insets(0, 5, 0, 0)));
        this.jPanel6.add((Component)this.ior, "North");
        this.jPanel2.add((Component)this.jPanel6, "Center");
        this.jTabbedPane.addTab("by IOR", this.jPanel2);
        this.getContentPane().add((Component)this.jTabbedPane, "Center");
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectServerRepositoryDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.okButton);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectServerRepositoryDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel8, "South");
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.loadHistory();
        this.pack();
    }

    void listEntrySelected() {
        if (this.historyList.getSelectedValue() != null) {
            HistoryEntry entry = (HistoryEntry)this.historyList.getSelectedValue();
            this.nameServer.setText(entry.getNameServer());
            this.nameServerPort.setText(entry.getNameServerPort());
            this.setNameServerChecked(entry.isUsingNameServer());
            this.repositoryName.setText(entry.getRepository());
            this.login.setText(entry.getLogin());
            if ("guest".equals(entry.getLogin())) {
                this.password.setText("guest");
                this.password.setSelectionStart(0);
                this.password.setSelectionEnd("guest".length());
            } else {
                this.password.setText("");
            }
            this.password.requestFocus();
        }
    }

    void historyDeleteButtonActionPerformed(ActionEvent evt) {
        if (this.historyList.getSelectedIndex() >= 0) {
            this.historyListData.remove(this.historyList.getSelectedIndex());
            this.historyList.updateUI();
        }
    }

    void jButton2ActionPerformed(ActionEvent evt) {
        this.hide();
    }

    public boolean isOk() {
        return this.ok;
    }

    public void show() {
        this.ok = false;
        this.loadHistory();
        super.show();
    }

    private void loadHistory() {
        PreferencesProperties props = PreferencesProperties.get(PROPERTIES_KEY);
        Vector fileNameVector = props.getVectorSetting(HISTORY_KEY);
        this.historyListData.clear();
        int i = 0;
        while (i < fileNameVector.size()) {
            HistoryEntry entry = new HistoryEntry((String)fileNameVector.elementAt(i));
            this.historyListData.add(entry);
            ++i;
        }
        this.historyList.updateUI();
    }

    private void saveHistory() {
        PreferencesProperties props = PreferencesProperties.get(PROPERTIES_KEY);
        Vector<String> dataVector = new Vector<String>();
        try {
            int i = 0;
            while (i < this.historyListData.size()) {
                HistoryEntry entry = (HistoryEntry)this.historyListData.elementAt(i);
                dataVector.add(entry.getData());
                ++i;
            }
            props.putSetting(HISTORY_KEY, dataVector);
            props.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isByName() {
        return this.jTabbedPane.getSelectedIndex() == 0;
    }

    public String getNameServer() {
        return this.nameServer.getText().trim();
    }

    public String getNameServerPort() {
        return this.nameServerPort.getText().trim();
    }

    public String getRepositoryName() {
        return this.repositoryName.getText().trim();
    }

    public String getLogin() {
        return this.login.getText().trim();
    }

    public String getPassword() {
        return new String(this.password.getPassword()).trim();
    }

    public void setLogin(String value) {
        this.login.setText(value);
    }

    public void setPassword(String value) {
        this.password.setText(value);
    }

    public boolean isLightweightChecked() {
        return this.lightweightCheck.isSelected();
    }

    public boolean isConnectOnlyChecked() {
        return this.connectOnly.isSelected();
    }

    public String getIOR() {
        return this.ior.getText().trim();
    }

    public void setIOR(String text) {
        this.ior.setText(text);
    }

    public void setIOREnabled(boolean enabled) {
        this.ior.setEnabled(enabled);
    }

    public void rememberCurrentDataInHistoryList() {
        HistoryEntry entry = new HistoryEntry(this.getNameServer(), this.getNameServerPort(), this.getRepositoryName(), this.getLogin(), this.isNameServerChecked());
        if (!this.historyListData.contains(entry)) {
            this.historyListData.add(entry);
        }
        this.saveHistory();
    }

    void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.saveHistory();
        this.hide();
    }

    void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class HistoryEntry {
        private String nameServer;
        private String nameServerPort;
        private String repository;
        private String login;
        private boolean usingNameServer;

        public String getLogin() {
            return this.login;
        }

        public String getNameServer() {
            return this.nameServer;
        }

        public String getNameServerPort() {
            return this.nameServerPort;
        }

        public String getRepository() {
            return this.repository;
        }

        public HistoryEntry(String nameServer, String nameServerPort, String repository, String login, boolean usingNameServer) {
            this.nameServer = nameServer;
            this.nameServerPort = nameServerPort;
            this.repository = repository;
            this.login = login;
            this.usingNameServer = usingNameServer;
        }

        public HistoryEntry(String data) {
            StringTokenizer tokenizer = new StringTokenizer(data, "\n");
            this.nameServer = tokenizer.nextToken();
            this.nameServerPort = tokenizer.nextToken();
            this.repository = tokenizer.nextToken();
            this.login = tokenizer.nextToken();
            this.usingNameServer = tokenizer.hasMoreTokens() ? Boolean.valueOf(tokenizer.nextToken()) : true;
        }

        public boolean isUsingNameServer() {
            return this.usingNameServer;
        }

        public String getData() {
            return String.valueOf(this.getNameServer()) + "\n" + this.getNameServerPort() + "\n" + this.getRepository() + "\n" + this.getLogin() + "\n" + this.isUsingNameServer();
        }

        public String toString() {
            return this.isUsingNameServer() ? this.getRepository() : String.valueOf(this.getNameServer()) + ":" + this.getNameServerPort();
        }

        public boolean equals(Object o) {
            return this.getData().equals(((HistoryEntry)o).getData());
        }
    }
}

