/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.coobra.actions;

import de.uni_paderborn.fujaba.app.FrameMain;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CheckoutVersionChooser
extends JDialog {
    Vector data;
    JList list;
    boolean allowFreeSelection = false;
    private ListSelectionListener listSelectionListener = new ListSelectionListener(){
        boolean inValueChanged = false;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void valueChanged(ListSelectionEvent e) {
            if (this.inValueChanged) return;
            if (CheckoutVersionChooser.this.allowFreeSelection) return;
            try {
                this.inValueChanged = true;
                int[] selection = CheckoutVersionChooser.this.list.getSelectedIndices();
                if (selection != null && selection.length > 0) {
                    int largestSelectedIndex = selection[selection.length - 1];
                    if (CheckoutVersionChooser.this.data.size() > 1 && largestSelectedIndex > 0) {
                        CheckoutVersionChooser.this.list.setSelectionInterval(1, largestSelectedIndex);
                    } else {
                        CheckoutVersionChooser.this.list.setSelectionInterval(0, 0);
                    }
                } else {
                    CheckoutVersionChooser.this.list.setSelectionInterval(0, 0);
                }
                Object var4_6 = null;
                this.inValueChanged = false;
                return;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.inValueChanged = false;
                throw throwable;
            }
        }
    };

    public CheckoutVersionChooser() throws HeadlessException {
        super((Frame)FrameMain.get(), true);
        this.setup();
        this.pack();
    }

    private void setup() {
        this.setTitle("Choose version");
        this.setDefaultCloseOperation(0);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel bottom = new JPanel();
        contentPane.add((Component)bottom, "South");
        this.data = new Vector();
        this.list = new JList(this.data);
        this.list.setSelectionMode(1);
        this.list.addListSelectionListener(this.listSelectionListener);
        contentPane.add((Component)new JScrollPane(this.list), "Center");
        JButton okButton = new JButton("OK");
        bottom.setLayout(new FlowLayout(1));
        bottom.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CheckoutVersionChooser.this.dispose();
            }
        });
    }

    public void pack() {
        super.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void chooseFromVersions(Collection versions) {
        this.data.clear();
        this.data.add("none (clear repository on next checkin)");
        this.data.addAll(versions);
        this.list.updateUI();
        if (this.data.size() > 1) {
            this.list.setSelectionInterval(1, this.data.size() - 1);
        } else {
            this.list.setSelectionInterval(0, 0);
        }
        this.pack();
        this.show();
    }

    public Object getLargestChosenVersion() {
        int[] selection = this.list.getSelectedIndices();
        if (selection != null && selection.length > 0) {
            int largestSelectedIndex = selection[selection.length - 1];
            if (largestSelectedIndex > 0) {
                return this.data.get(largestSelectedIndex);
            }
            return null;
        }
        return null;
    }

    public Object getSmallestChosenVersion() {
        int[] selection = this.list.getSelectedIndices();
        if (selection != null && selection.length > 0) {
            int smallestSelectedIndex = selection[0];
            if (smallestSelectedIndex > 1) {
                return this.data.get(smallestSelectedIndex - 1);
            }
            return null;
        }
        return null;
    }

    public boolean isAllowFreeSelection() {
        return this.allowFreeSelection;
    }

    public void setAllowFreeSelection(boolean allowFreeSelection) {
        this.allowFreeSelection = allowFreeSelection;
    }
}

