/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.coobra.actions;

import de.tu_bs.coobra.LocalRepository;
import de.tu_bs.coobra.RemoteRepositoryManager;
import de.tu_bs.coobra.errors.ServerIdentifierChangedException;
import de.tu_bs.coobra.remote.RemoteRepository;
import de.tu_bs.coobra.remote.ServerRepositoryOperations;
import de.tu_bs.coobra.remote.lightweight.LightWeightNameService;
import de.tu_bs.coobra.remote.lightweight.LightWeightServer;
import de.tu_bs.coobra.util.Password;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.coobra.actions.ProgressDialog;
import de.uni_paderborn.fujaba.coobra.actions.SelectServerRepositoryDialog;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class CheckoutAction
extends AbstractAction
implements LocalRepository.ProgressCallback {
    SelectServerRepositoryDialog dialog;
    private boolean connectOnly;
    ProgressDialog progress = new ProgressDialog(FrameMain.get());

    public void progress(int percent) {
        if (this.progress != null) {
            this.progress.setPercentage(percent);
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.connectOnly = this.shouldConnectOnly();
        if (this.dialog == null) {
            this.dialog = new SelectServerRepositoryDialog((Frame)FrameMain.get(), true);
        }
        if (this.connectOnly) {
            this.dialog.setTitle("Connect");
            this.progress.setTitle("Connect");
        } else {
            this.dialog.setTitle("Checkout");
            this.progress.setTitle("Checkout");
        }
        this.dialog.show();
        this.progress.setPercentage(0);
        if (this.dialog.isOk()) {
            this.connectOnly |= this.dialog.isConnectOnlyChecked();
            String status = "connecting";
            FrameMain.get().setStatusLabel(status);
            new Thread(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    while (!CheckoutAction.this.progress.isVisible()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        CheckoutAction.this.connect();
                        Object var1_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var1_2 = null;
                        CheckoutAction.this.progress.hide();
                        throw throwable;
                    }
                    CheckoutAction.this.progress.hide();
                }
            }.start();
            this.progress.show();
        }
    }

    protected boolean shouldConnectOnly() {
        return FujabaChangeManager.getVMRepository() != null && FujabaChangeManager.getVMRepository().getServerIdentifier() != null;
    }

    void connect() {
        try {
            if (this.dialog.isByName()) {
                this.connect(this.dialog.isNameServerChecked() ? this.dialog.getRepositoryName() : null, null, this.dialog.getLogin(), this.dialog.getPassword(), this.dialog.getNameServer(), this.dialog.getNameServerPort(), this.dialog.isLightweightChecked());
            } else {
                this.connect(this.dialog.getIOR());
            }
            this.dialog.rememberCurrentDataInHistoryList();
        }
        catch (Exception e) {
            FrameMain.get().setStatusLabel("connect failed: " + e.getMessage());
            if (e.getMessage() != null) {
                if (e.getMessage().indexOf("authentication failed") >= 0) {
                    JOptionPane.showMessageDialog(FrameMain.get(), "Username and password not accepted!", "Connect", 0);
                } else if (e.getMessage().indexOf("access to repository denied for user ") >= 0) {
                    JOptionPane.showMessageDialog(FrameMain.get(), "User " + this.dialog.getLogin() + " is not allowed to connect to repository " + this.dialog.getRepositoryName(), "Connect", 0);
                }
            }
            e.printStackTrace();
        }
    }

    public void connect(String ior) throws NumberFormatException, IOException {
        this.connect(null, ior, null, null, null, null, false);
    }

    public void connect(String repName, String ior, String login, String password, String nameServer, String nameServerPort, boolean lightweight) throws NumberFormatException, IOException {
        RemoteRepository remote;
        RemoteRepositoryManager manager;
        LocalRepository repository;
        if (!this.connectOnly) {
            this.createNewProject();
            repository = this.createRepository();
        } else {
            repository = FujabaChangeManager.getVMRepository();
        }
        if (ior == null) {
            if (!lightweight) {
                manager = new RemoteRepositoryManager(nameServer, nameServerPort, null);
                remote = manager.connectByName(repName);
            } else if (repName != null) {
                LightWeightNameService.ServiceInfo info = LightWeightNameService.query((String)nameServer, (int)Integer.parseInt(nameServerPort), (String)repName);
                String passwordHash = Password.passwordHash((String)password);
                remote = new RemoteRepository((ServerRepositoryOperations)new LightWeightServer(info.getHost(), Integer.parseInt(info.getPort()), login, passwordHash));
            } else {
                String passwordHash = Password.passwordHash((String)password);
                remote = new RemoteRepository((ServerRepositoryOperations)new LightWeightServer(nameServer, Integer.parseInt(nameServerPort), login, passwordHash));
            }
        } else {
            manager = new RemoteRepositoryManager(null);
            remote = manager.connectByIOR(ior);
        }
        try {
            repository.connect(remote);
        }
        catch (ServerIdentifierChangedException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(FrameMain.get(), "The server does not contain the Project you are working on. Connect aborted!", "Connect", 0);
            return;
        }
        String status = "connect succeeded";
        if (!this.connectOnly) {
            repository.update((LocalRepository.ProgressCallback)this);
            if (repository.getUpdateFilter() == null || !repository.getUpdateFilter().isPatch()) {
                UMLProject project = FujabaChangeManager.getUMLProject();
                if (project != null) {
                    UMLProject.setNewProject(project);
                    FrameMain.get().setUMLProject(project);
                    project.refreshDisplay();
                    repository.moveChangesIntoChangesBase();
                    project.setSaved(true);
                } else {
                    status = "No project was found in the loaded repository!";
                }
            }
        }
        FrameMain.get().setStatusLabel(status);
    }

    protected void createNewProject() {
        UMLProject.setNewProject(null);
    }

    protected LocalRepository createRepository() {
        LocalRepository oldRepo = FujabaChangeManager.getVMRepository();
        LocalRepository localRepository = new LocalRepository();
        FujabaChangeManager.setVMRepository(localRepository);
        if (oldRepo != null) {
            oldRepo.removeYou();
        }
        return localRepository;
    }
}

