/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.coobra;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class RecoverDialog
extends JDialog {
    private JPanel base;

    private void init() {
        this.getRootPane().setLayout(new BorderLayout());
        this.base = new JPanel();
        this.getRootPane().add((Component)this.base, "Center");
        GridLayout grid = new GridLayout();
        grid.setColumns(1);
        grid.setRows(0);
        this.base.setLayout(grid);
        JPanel top = new JPanel();
        this.getRootPane().add((Component)top, "North");
        JLabel label = new JLabel("Temporary files of past Fujaba sessions were found. Do you wish to recover any of these?");
        top.setPreferredSize(new Dimension((int)label.getPreferredSize().getWidth() + 20, (int)label.getPreferredSize().getHeight() + 20));
        FlowLayout flow = new FlowLayout(1);
        top.setLayout(flow);
        top.add(label);
    }

    public RecoverDialog(Frame owner) throws HeadlessException {
        super(owner, "Recover", true);
        this.init();
    }

    public void check() {
        boolean foundFiles = false;
        File dir = new File(".");
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            String fileName = files[i];
            File file = new File(dir, fileName);
            if (!file.isDirectory() && fileName.startsWith("~") && fileName.endsWith(".cxri") && (UMLProject.get().getBackupFile() == null || !fileName.equals(UMLProject.get().getBackupFile().getName()))) {
                foundFiles = true;
                JPanel filePanel = new JPanel();
                filePanel.putClientProperty("file", file);
                filePanel.setLayout(new FlowLayout(1));
                JButton loadButton = new JButton(fileName);
                filePanel.add(loadButton);
                loadButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JComponent parent = (JComponent)((JComponent)e.getSource()).getParent();
                        RecoverDialog.this.load(parent);
                    }
                });
                JButton deleteButton = new JButton("delete");
                filePanel.add(deleteButton);
                deleteButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JComponent parent = (JComponent)((JComponent)e.getSource()).getParent();
                        RecoverDialog.this.delete(parent);
                    }
                });
                this.base.add(filePanel);
            }
            ++i;
        }
        JButton noneButton = new JButton("no");
        JPanel nonePanel = new JPanel();
        nonePanel.setLayout(new FlowLayout(1));
        nonePanel.add(noneButton);
        this.base.add(nonePanel);
        noneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RecoverDialog.this.dispose();
            }
        });
        if (foundFiles) {
            this.pack();
            this.center();
            this.show();
        }
    }

    void delete(JComponent parent) {
        File file = (File)parent.getClientProperty("file");
        if (file.delete()) {
            parent.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(this, "Delete failed! Maybe file is in use?", "Delete", 0);
        }
    }

    void load(JComponent parent) {
        File file = (File)parent.getClientProperty("file");
        FrameMain.get().openFile(file);
        this.dispose();
    }

    private void center() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }
}

