/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.coobra;

import de.tu_bs.coobra.LocalRepository;
import de.tu_bs.coobra.ObjectChange;
import de.tu_bs.coobra.ObjectChangeCause;
import de.tu_bs.coobra.ObjectChangeStringCause;
import de.tu_bs.coobra.errors.ErrorHandlerInterface;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.UnifiedClassLoader;
import de.uni_paderborn.fujaba.coobra.FujabaErrorHandler;
import de.uni_paderborn.fujaba.metamodel.FProject;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.lib.userinterface.ActionExecutionListener;
import de.upb.lib.userinterface.UserInterfaceManager;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FujabaChangeManager {
    static final transient Logger log;
    private static LocalRepository vMRepository;
    private static ErrorHandlerInterface errorHandler;
    private static ActionExecutionListener ael;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.coobra.FujabaChangeManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        errorHandler = new FujabaErrorHandler();
    }

    public static LocalRepository getVMRepository() {
        if (vMRepository == null && GeneralPreferences.get().isRepositoryActivated()) {
            FujabaChangeManager.setVMRepository(new LocalRepository());
        }
        return vMRepository;
    }

    public static void setVMRepository(LocalRepository vMRepository) {
        if (vMRepository != null) {
            vMRepository.setClassLoader(UnifiedClassLoader.get());
            LocalRepository.setErrorHandler((ErrorHandlerInterface)errorHandler);
        }
        FujabaChangeManager.vMRepository = vMRepository;
    }

    public static void addActionCauseListener() {
        if (ael == null) {
            ael = new ActionExecutionListener(){

                public void preActionNotify(ActionEvent e) {
                    ObjectChangeCause cause;
                    while ((cause = ObjectChange.peekCause()) != null) {
                        ObjectChange.popCause((ObjectChangeCause)cause);
                    }
                    ObjectChange.pushCause((ObjectChangeCause)new ObjectChangeStringCause("Action: " + e.getActionCommand()));
                }

                public void postActionNotify(ActionEvent e) {
                    while (ObjectChange.peekCause() != null) {
                        ObjectChange.popCause((ObjectChangeCause)ObjectChange.peekCause());
                    }
                }
            };
        }
        UserInterfaceManager.get().addExecutionListener(ael);
    }

    public static boolean isCollectionField(Class cls, String fieldName) {
        if (cls != null && fieldName != null && fieldName.length() >= 1) {
            String suffix = String.valueOf(fieldName.substring(0, 1).toUpperCase()) + fieldName.substring(1);
            String addName = "addTo" + suffix;
            Method addMethod = null;
            Method[] methods = cls.getMethods();
            int i = 0;
            while (i < methods.length) {
                Class<?>[] paramTypes;
                Method method = methods[i];
                if (method.getName().equals(addName) && (paramTypes = method.getParameterTypes()).length == 1) {
                    addMethod = method;
                    break;
                }
                ++i;
            }
            return addMethod != null;
        }
        return false;
    }

    public static UMLProject getUMLProject() {
        UMLProject project = null;
        LocalRepository vmRepository = FujabaChangeManager.getVMRepository();
        if (vmRepository != null) {
            if (vmRepository.getRootObject() instanceof UMLProject) {
                return (UMLProject)vmRepository.getRootObject();
            }
            Iterator it = vmRepository.iteratorOfKnownObjects();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof FProject)) continue;
                project = (UMLProject)obj;
                break;
            }
            vmRepository.setRootObject(project);
        }
        return project;
    }

    public static boolean isInUndoRedo() {
        return ObjectChange.peekCause() != null && ObjectChange.peekCause().isUndoRedo();
    }

    public static void updateUndoRedoActions() {
        final LocalRepository repository = FujabaChangeManager.getVMRepository();
        final AbstractAction undoAction = UserInterfaceManager.get().getFromActions("coobra.undo");
        final AbstractAction redoAction = UserInterfaceManager.get().getFromActions("coobra.redo");
        if (undoAction != null && redoAction != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (repository != null) {
                        undoAction.setEnabled(repository.isUndoPossible());
                        redoAction.setEnabled(repository.isRedoPossible());
                    } else {
                        undoAction.setEnabled(false);
                        redoAction.setEnabled(false);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void executeTransient(Runnable runnable) {
        boolean transientMode = ASGElement.isInTransientMode();
        try {
            HashSet oldTransient = new HashSet(ASGElement.getTransientElements());
            ASGElement.setInTransientMode(true);
            runnable.run();
            HashSet newTransient = new HashSet(ASGElement.getTransientElements());
            newTransient.removeAll(oldTransient);
            Iterator iter = newTransient.iterator();
            while (iter.hasNext()) {
                ASGElement element = (ASGElement)iter.next();
                element.removeYou();
                iter.remove();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ASGElement.setInTransientMode(transientMode);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        ASGElement.setInTransientMode(transientMode);
    }
}

