/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.codegen.CodeGenFragment;
import de.uni_paderborn.fujaba.codegen.CodeGenVisitor;
import de.uni_paderborn.fujaba.codegen.ImportFragment;
import de.uni_paderborn.fujaba.codegen.OOGenStrategyClient;
import de.uni_paderborn.fujaba.codegen.OOGenStrategyHandler;
import de.uni_paderborn.fujaba.codegen.OOGenToken;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FFile;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class UMLFileOOHandler
extends OOGenStrategyHandler {
    private static final transient Logger log;
    public static final String FRAGMENT_CLASSES = "File:Classes";
    public static final String FRAGMENT_FILE_HEADER = "File:Header";
    public static final String FRAGMENT_FILE_FOOTER = "File:Footer";
    public static final String FRAGMENT_IMPORTS = "File:Imports";
    public static final String CREATE_IMPORTS_FUNCTION = "createImportsForFile";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.UMLFileOOHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public boolean isResponsible(FElement incr) {
        return incr instanceof FFile;
    }

    public final boolean needToken() {
        return false;
    }

    public OOGenToken generateSourceCode(FElement incr, OOGenToken prevToken, Object[] param) {
        FFile theFile = (FFile)incr;
        OOGenStrategyClient client = (OOGenStrategyClient)this.getClientOfChain();
        boolean writeFiles = true;
        if (param != null && param.length == 1 && param[0] instanceof Boolean) {
            writeFiles = (Boolean)param[0];
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ".generateSourceCode(theFile=" + theFile + ",path=" + client.getFilePath(theFile) + ",name=" + client.getFileName(theFile) + ",target=" + client.getCurrentOOGenVisitor() + ")"));
        }
        if (!this.necessaryToCreateFile(theFile)) {
            if (log.isDebugEnabled() && log.isInfoEnabled()) {
                log.info((Object)(this + " ignore FFile:" + theFile));
            }
        } else {
            client.initVisitor(client.getFilePath(theFile), client.getFileName(theFile), writeFiles);
            this.generateFFileHeader(theFile);
            this.generateFPackageBegin(theFile);
            this.generateImportList(theFile);
            client.getCurrentVisitor().appendTextFragment(FRAGMENT_CLASSES);
            FClass tmpFClass = null;
            Iterator tmpIter = theFile.iteratorOfContains();
            while (tmpIter.hasNext()) {
                tmpFClass = (FClass)tmpIter.next();
                this.getClientOfChain().generateSourceCodeFor(tmpFClass, null, null);
            }
            this.generateFPackageEnd(theFile);
            this.generateFFileFooter(theFile);
            if (writeFiles) {
                client.writeFiles();
            }
        }
        return null;
    }

    public final void generateFFileHeader(FFile theFile) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".generateFFileHeader(" + theFile + ")"));
        }
        OOGenStrategyClient client = (OOGenStrategyClient)this.getClientOfChain();
        client.getCurrentVisitor().appendTextFragment(FRAGMENT_FILE_HEADER);
        if (theFile.getFComment() != null) {
            client.append(theFile.getFComment().getText());
        }
    }

    public final void generateFFileFooter(FFile theFile) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".generateFFileFooter(" + theFile + ")"));
        }
        OOGenStrategyClient client = (OOGenStrategyClient)this.getClientOfChain();
        client.getCurrentVisitor().appendTextFragment(FRAGMENT_FILE_FOOTER);
        if (theFile.getFooter() != null) {
            this.getClientOfChain().append(theFile.getFooter());
        }
    }

    public final void generateFPackageBegin(FFile theFile) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".generateFPackageBegin(" + theFile + ")"));
        }
        ((OOGenStrategyClient)this.getClientOfChain()).generateFPackageBegin(theFile);
    }

    public final void generateFPackageEnd(FFile theFile) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".generateFPackageEnd(" + theFile + ")"));
        }
        ((OOGenStrategyClient)this.getClientOfChain()).generateFPackageEnd(theFile);
    }

    public final void generateImportList(FFile theFile) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".generateImportList(" + theFile + ")"));
        }
        FPackage tmpPackage = null;
        FClass tmpClass = null;
        OOGenStrategyClient client = (OOGenStrategyClient)this.getClientOfChain();
        ImportFragment importFragment = new ImportFragment(FRAGMENT_IMPORTS, client);
        client.getCurrentVisitor().appendFragment(importFragment);
        Iterator importIter = theFile.iteratorOfImportedPackages();
        while (importIter.hasNext()) {
            tmpPackage = (FPackage)importIter.next();
            importFragment.addPackage(tmpPackage);
        }
        importIter = theFile.iteratorOfImportedClasses();
        while (importIter.hasNext()) {
            tmpClass = (FClass)importIter.next();
            importFragment.addClass(tmpClass);
        }
        this.generateImplicitImports(theFile, importFragment);
    }

    public boolean necessaryToCreateFile(FFile theFile) {
        boolean create = false;
        Iterator iter = theFile.iteratorOfContains();
        while (!create && iter.hasNext()) {
            FClass tmpClass = (FClass)iter.next();
            create = this.necessaryToCreateClass(tmpClass);
        }
        return create;
    }

    public boolean necessaryToCreateClass(FClass tmpClass) {
        return !tmpClass.hasInStereotypes(UMLStereotypeManager.get().getFromStereotypes("reference")) && !tmpClass.hasInStereotypes(UMLStereotypeManager.get().getFromStereotypes("import"));
    }

    public static ImportFragment findImportFragment(CodeGenVisitor visitor) {
        if (visitor != null) {
            CodeGenFragment fragment = visitor.getFirstFragment();
            while (fragment != null) {
                if (FRAGMENT_IMPORTS.equals(fragment.getName()) && fragment instanceof ImportFragment) {
                    return (ImportFragment)fragment;
                }
                fragment = fragment.getNextFragment();
            }
        }
        return null;
    }

    public void generateImplicitImports(final FFile umlFile, final ImportFragment importFrag) {
        Runnable runnable = new Runnable(){

            public void run() {
                UMLFileOOHandler.this.generateCode(umlFile, UMLFileOOHandler.CREATE_IMPORTS_FUNCTION, new Object[]{importFrag});
            }
        };
        FujabaChangeManager.executeTransient(runnable);
    }

    public String toString() {
        return "UMLFileOOHandler[]";
    }
}

