/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.basic.SourceCodeFactory;
import de.uni_paderborn.fujaba.basic.UnifiedClassLoader;
import de.uni_paderborn.fujaba.codegen.UMLClassBodyStrategy;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FQualifier;
import de.uni_paderborn.fujaba.metamodel.FRole;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.upb.tools.fca.StandardComparator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;

public class UMLClassBodyRemoveYouStrategy
extends UMLClassBodyStrategy {
    public void createContents(FClass umlClass) {
        if (UMLClassBodyRemoveYouStrategy.mustCreateRemoveYouMethod(umlClass)) {
            this.generateRemoveYouMethod(umlClass);
        }
    }

    public static boolean mustCreateRemoveYouMethod(FClass clazz) {
        boolean result = false;
        UMLStereotype interfaceType = UMLStereotypeManager.get().getFromStereotypes("interface");
        UMLStereotype referenceType = UMLStereotypeManager.get().getFromStereotypes("reference");
        UMLStereotype importType = UMLStereotypeManager.get().getFromStereotypes("import");
        if (!(clazz == null || clazz.hasInStereotypes(interfaceType) || clazz.hasInStereotypes(referenceType) || clazz.hasInStereotypes(importType))) {
            result = UMLClassBodyRemoveYouStrategy.getRemoveRoles(clazz).size() > 0 && clazz.getFromFMethodsByShortName("removeYou") == null;
        }
        return result;
    }

    protected void generateRemoveYouMethod(FClass clazz) {
        StringBuffer methodBody = new StringBuffer();
        SourceCodeFactory factory = UMLProject.getSourceCodeFactory();
        boolean callSuperMethod = false;
        Collection removeRoles = UMLClassBodyRemoveYouStrategy.getRemoveRoles(clazz);
        Iterator iter = removeRoles.iterator();
        while (iter.hasNext()) {
            boolean isInternalQualified;
            callSuperMethod = true;
            FRole tmpRole = (FRole)iter.next();
            FRole tmpPartnerRole = tmpRole.getFPartnerRole();
            FQualifier qualifier = tmpRole.getFQualifier();
            FQualifier partnerQualifier = tmpPartnerRole.getFQualifier();
            boolean isQualified = qualifier != null;
            boolean isPartnerQualified = false;
            if (partnerQualifier != null) {
                isPartnerQualified = true;
                isInternalQualified = !partnerQualifier.isExternalQualifier();
            } else {
                isInternalQualified = false;
            }
            boolean toOneAccess = isQualified ? false : tmpPartnerRole.getFCard() == null || tmpPartnerRole.getFCard() != null && tmpPartnerRole.getFCard().getUpperBound() == 1;
            FClass target = tmpPartnerRole.getFTarget();
            if (target == null) continue;
            methodBody.append(factory.removeYouBody(tmpPartnerRole.getAttrName(), target.getName(), toOneAccess, isQualified, isPartnerQualified, isInternalQualified, tmpRole.getAdornment() == 2));
        }
        boolean bl = callSuperMethod = callSuperMethod && UMLClassBodyRemoveYouStrategy.alreadyImplementsRemoveYou(clazz);
        if (callSuperMethod) {
            methodBody.append("super.").append(factory.getAccessMethodName("", 8)).append(" (").append(")").append(";\n\n");
        }
        UMLMethod removeYouMethod = new UMLMethod(false);
        removeYouMethod.setGenerated(true);
        removeYouMethod.setName(factory.getAccessMethodName("", 8));
        removeYouMethod.setVisibility(1);
        removeYouMethod.setResultType(UMLProject.get().getFromBaseTypes("Void"));
        removeYouMethod.setDisplayLevel(0);
        removeYouMethod.setMethodBody(methodBody.toString(), true);
        this.getClassHandler().generateFMethod(removeYouMethod);
        removeYouMethod.removeYou();
    }

    protected static Collection getRemoveRoles(FClass umlClass) {
        Enumeration enumeration = umlClass.elementsOfRoles();
        TreeSet<FRole> removeRoles = new TreeSet<FRole>(new FRoleComparator());
        TreeSet<String> roleNames = new TreeSet<String>(new StandardComparator());
        while (enumeration.hasMoreElements()) {
            FRole tmpRole = (FRole)enumeration.nextElement();
            String tmpName = tmpRole.getFPartnerRole().getName();
            if (tmpName == null || roleNames.contains(tmpName)) continue;
            roleNames.add(tmpName);
            if (tmpRole.getFAssoc().isVirtualPath() || tmpRole.getAdornment() == 3 || tmpRole.getFPartnerRole() == null) continue;
            removeRoles.add(tmpRole);
        }
        return removeRoles;
    }

    public static boolean alreadyImplementsRemoveYou(FClass clazz) {
        Enumeration subclassEnum = clazz.elementsOfRevSubclass();
        while (subclassEnum.hasMoreElements()) {
            UMLClass tmpClass = ((UMLGeneralization)subclassEnum.nextElement()).getSuperclass();
            if (UMLClassBodyRemoveYouStrategy.mustCreateRemoveYouMethod(tmpClass)) {
                return true;
            }
            if (tmpClass.getFromFMethodsByShortName("removeYou") != null) {
                return true;
            }
            if (tmpClass.isReference()) {
                boolean maybe = false;
                try {
                    maybe = UnifiedClassLoader.get().loadClass(tmpClass.getFullClassName()).getMethod("removeYou", null) != null;
                }
                catch (NoSuchMethodException e) {
                    maybe = false;
                }
                catch (ClassNotFoundException e) {
                    maybe = false;
                }
                if (!maybe) continue;
                return true;
            }
            if (!UMLClassBodyRemoveYouStrategy.alreadyImplementsRemoveYou(tmpClass)) continue;
            return true;
        }
        return false;
    }

    protected static class FRoleComparator
    implements Comparator {
        protected FRoleComparator() {
        }

        public int compare(Object o1, Object o2) {
            boolean role2IsSpecial;
            if (o1.equals(o2)) {
                return 0;
            }
            UMLRole role1 = (UMLRole)o1;
            UMLRole role2 = (UMLRole)o2;
            boolean role1IsSpecial = role1.getPartnerRole().getQualifier() != null && role1.getPartnerRole().getQualifier().getQualifiedRole() != null;
            boolean bl = role2IsSpecial = role2.getPartnerRole().getQualifier() != null && role2.getPartnerRole().getQualifier().getQualifiedRole() != null;
            if (role1IsSpecial && !role2IsSpecial) {
                return -1;
            }
            if (!role1IsSpecial && role2IsSpecial) {
                return 1;
            }
            if (!role1IsSpecial && !role2IsSpecial) {
                return role1.hashCode() - role2.hashCode();
            }
            UMLRole qualiRole1 = role1.getPartnerRole().getQualifier().getQualifiedRole();
            UMLRole qualiRole2 = role2.getPartnerRole().getQualifier().getQualifiedRole();
            if (qualiRole2 == role1.getFPartnerRole() && qualiRole1 != role2.getFPartnerRole()) {
                return 1;
            }
            if (qualiRole1 == role2.getPartnerRole() && qualiRole2 != role1.getPartnerRole()) {
                return -1;
            }
            if (qualiRole1 != role2.getPartnerRole() && qualiRole2 != role1.getPartnerRole()) {
                return this.compare(qualiRole1.getPartnerRole(), qualiRole2.getPartnerRole());
            }
            if (qualiRole1 == role2.getPartnerRole() && qualiRole2 == role1.getPartnerRole()) {
                return role1.hashCode() - role2.hashCode();
            }
            return role1.hashCode() - role2.hashCode();
        }
    }
}

