/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.basic.RuntimeExceptionWithContext;
import de.uni_paderborn.fujaba.codegen.CodeGenException;
import de.uni_paderborn.fujaba.codegen.GeneratedMethodRef;
import de.uni_paderborn.fujaba.codegen.UMLClassBodyStrategy;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FMethod;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class UMLClassBodyMethodsStrategy
extends UMLClassBodyStrategy {
    private int createStatic = -1;

    public void createContents(FClass umlClass) {
        SortedSet methods = this.getMethods(umlClass);
        Iterator iter = methods.iterator();
        CodeGenException exception = new CodeGenException();
        while (iter.hasNext()) {
            FMethod method = (FMethod)iter.next();
            if (!this.isResponsible(method)) continue;
            try {
                this.createMethod(method);
            }
            catch (RuntimeException e22) {
                RuntimeExceptionWithContext e22;
                String newMessage = "error generating code for method '" + method.getFullMethodName() + "': " + e22.getMessage();
                if (e22 instanceof RuntimeExceptionWithContext) {
                    RuntimeExceptionWithContext eWC = (RuntimeExceptionWithContext)e22;
                    Throwable cause = eWC.getCause() != null ? eWC.getCause() : eWC;
                    e22 = new RuntimeExceptionWithContext(newMessage, cause, eWC.getContext());
                } else {
                    e22 = new RuntimeExceptionWithContext(newMessage, e22, method);
                }
                exception.addToExceptions(e22);
            }
        }
        if (exception.sizeOfExceptions() > 0) {
            throw exception;
        }
    }

    protected void createMethod(FMethod method) {
        this.getClassHandler().generateFMethod(method);
    }

    protected boolean isResponsible(FMethod method) {
        if (method == null || method.getFResultType() == null) {
            return false;
        }
        return !method.isParsed() && this.checkFlag(method.isStatic(), this.createStatic) && !"constructor".equals(method.getFResultType().getName()) && method.getFAccessedAttribute() == null && !GeneratedMethodRef.hasGeneratedMethodRef(method);
    }

    public boolean isCreateStatic() {
        return this.createStatic == 1;
    }

    public void setCreateStatic(boolean createStatic) {
        this.setCreateStatic(createStatic ? 1 : 0);
    }

    public void setCreateStatic(int createStatic) {
        if (createStatic != -1 && createStatic != 1 && createStatic != 0) {
            throw new IllegalArgumentException();
        }
        this.createStatic = createStatic;
    }

    public void resetCreateStatic() {
        this.setCreateStatic(-1);
    }

    public int getCreateStatic() {
        return this.createStatic;
    }

    protected SortedSet getMethods(FClass umlClass) {
        TreeSet methodsSet = new TreeSet(new UMLClassBodyStrategy.MethodComparator());
        Iterator methodsIter = umlClass.iteratorOfMethods();
        while (methodsIter.hasNext()) {
            methodsSet.add(methodsIter.next());
        }
        return methodsSet;
    }
}

