/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.basic.BasicIncrement;
import de.uni_paderborn.fujaba.basic.Utility;
import de.uni_paderborn.fujaba.codegen.CGU;
import de.uni_paderborn.fujaba.codegen.CodeGenVisitor;
import de.uni_paderborn.fujaba.codegen.OO;
import de.uni_paderborn.fujaba.codegen.OOAssignExpr;
import de.uni_paderborn.fujaba.codegen.OOBeginMethodBodyStatement;
import de.uni_paderborn.fujaba.codegen.OOBreakStatement;
import de.uni_paderborn.fujaba.codegen.OOCallAttrExpr;
import de.uni_paderborn.fujaba.codegen.OOCallMethodExpr;
import de.uni_paderborn.fujaba.codegen.OOCaseStatement;
import de.uni_paderborn.fujaba.codegen.OOCatchStatement;
import de.uni_paderborn.fujaba.codegen.OOClassOfVariableExpr;
import de.uni_paderborn.fujaba.codegen.OOCollectionEnum;
import de.uni_paderborn.fujaba.codegen.OOContainerType;
import de.uni_paderborn.fujaba.codegen.OODoStatement;
import de.uni_paderborn.fujaba.codegen.OOElseStatement;
import de.uni_paderborn.fujaba.codegen.OOEmptyLineStatement;
import de.uni_paderborn.fujaba.codegen.OOEndBlockStatement;
import de.uni_paderborn.fujaba.codegen.OOEndMethodBodyStatement;
import de.uni_paderborn.fujaba.codegen.OOExceptionExpr;
import de.uni_paderborn.fujaba.codegen.OOExprStatement;
import de.uni_paderborn.fujaba.codegen.OOExpression;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorGetExpr;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorGotoNextExpr;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorHasNextExpr;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorOfExpr;
import de.uni_paderborn.fujaba.codegen.OOForStatement;
import de.uni_paderborn.fujaba.codegen.OOIdentifierExpr;
import de.uni_paderborn.fujaba.codegen.OOIfStatement;
import de.uni_paderborn.fujaba.codegen.OOInfixExprLeft;
import de.uni_paderborn.fujaba.codegen.OOInfixExprRight;
import de.uni_paderborn.fujaba.codegen.OOInfixOp;
import de.uni_paderborn.fujaba.codegen.OOLineCommentStatement;
import de.uni_paderborn.fujaba.codegen.OOLocalVarDeclStatement;
import de.uni_paderborn.fujaba.codegen.OOMemoStatement;
import de.uni_paderborn.fujaba.codegen.OOMethod;
import de.uni_paderborn.fujaba.codegen.OOMethodType;
import de.uni_paderborn.fujaba.codegen.OONewArrayExpr;
import de.uni_paderborn.fujaba.codegen.OONewObjectExpr;
import de.uni_paderborn.fujaba.codegen.OOObjectOfTypeExpr;
import de.uni_paderborn.fujaba.codegen.OOPrefixExpr;
import de.uni_paderborn.fujaba.codegen.OOPrefixOp;
import de.uni_paderborn.fujaba.codegen.OOReturnStatement;
import de.uni_paderborn.fujaba.codegen.OOSDMEnsureStatement;
import de.uni_paderborn.fujaba.codegen.OOStartBlockStatement;
import de.uni_paderborn.fujaba.codegen.OOStartMethodBodyStatement;
import de.uni_paderborn.fujaba.codegen.OOStatement;
import de.uni_paderborn.fujaba.codegen.OOStringExpr;
import de.uni_paderborn.fujaba.codegen.OOSwitchCaseStatement;
import de.uni_paderborn.fujaba.codegen.OOThrowStatement;
import de.uni_paderborn.fujaba.codegen.OOTryStatement;
import de.uni_paderborn.fujaba.codegen.OOType;
import de.uni_paderborn.fujaba.codegen.OOTypeCastExpr;
import de.uni_paderborn.fujaba.codegen.OOTypeInterface;
import de.uni_paderborn.fujaba.codegen.OOUnitAssertStatement;
import de.uni_paderborn.fujaba.codegen.OOVariable;
import de.uni_paderborn.fujaba.codegen.OOVariableType;
import de.uni_paderborn.fujaba.codegen.OOWhileStatement;
import de.uni_paderborn.fujaba.metamodel.FArray;
import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FBaseTypes;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FCommentary;
import de.uni_paderborn.fujaba.metamodel.FFile;
import de.uni_paderborn.fujaba.metamodel.FMethod;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.metamodel.FParam;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.preferences.JavaPreferences;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.sdm.Path;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class OOGenVisitor
extends CodeGenVisitor {
    private static final transient Logger log;
    public static final String TMP_FILE_EXTENDER = "tmp";
    public static final String EMPTY_STRING = "";
    public String CLASS_STRING = "class";
    public String INTERFACE_STRING = "interface";
    public String NULL_STRING = "null";
    public String EXTENDS_STRING = "extends";
    public String IMPLEMENTS_STRING = "implements";
    public String START_BLOCK = "{";
    public String END_BLOCK = "}";
    public String START_IF_BLOCK = "{";
    public String START_METHOD_BLOCK = "{";
    public String START_METHOD_BODY = "";
    public String END_METHOD_BLOCK = "}";
    public String OPEN_NORM_BRACKET = "(";
    public String CLOSE_NORM_BRACKET = ")";
    public String END_OF_STATEMENT = ";";
    public String END_OF_LINE = "\n";
    public String END_OF_STATEMENT_LINE = String.valueOf(this.END_OF_STATEMENT) + this.END_OF_LINE;
    public String LIST_SEPARATOR = ",";
    public String POINTER_POSTFIX = "";
    public String SDM_ENSURE_STRING = "JavaSDM.ensure";
    public String SDM_EXCEPTION_STRING = "JavaSDMException";
    public String UNIT_ASSERT_STRING = "junit.framework.Assert.assertTrue";
    public String INTERRUPTED_EXCEPTION_STRING = "InterruptedException";
    public String ILLEGALDATA_EXCEPTION_STRING = "de.uni_paderborn.lib.resource.IllegalDataException";
    public String ASSIGNMENT_OP_STRING = "=";
    public String FALSE_STRING = "false";
    public String TRUE_STRING = "true";
    public String IF_STRING = "if";
    public String WHILE_STRING = "while";
    public String TRY_STRING = "try";
    public String CATCH_STRING = "catch";
    public String FINALLY_STRING = "finally";
    public String ELSE_STRING = "else";
    public String DO_STRING = "do";
    public String BREAK_STRING = "break";
    public String FOR_STRING = "for";
    public String SWITCH_STRING = "switch";
    public String CASE_STRING = "case";
    public String THIS_STRING = "this.";
    public String RETURN_STRING = "return";
    public String AND_OP_STRING = "&&";
    public String OR_OP_STRING = "||";
    public String EQUAL_OP_STRING = "==";
    public String NOT_EQUAL_OP_STRING = "!=";
    public String LESS_OP_STRING = "<";
    public String GREATER_OP_STRING = ">";
    public String LESS_EQUAL_OP_STRING = "<=";
    public String GREATER_EQUAL_OP_STRING = ">=";
    public String ADD_OP_STRING = "+";
    public String SUB_OP_STRING = "-";
    public String MUL_OP_STRING = "*";
    public String DIV_OP_STRING = "/";
    public String NOT_OP_STRING = "!";
    public String INCR_OP_STRING = "++";
    public String DECR_OP_STRING = "--";
    public String F_STATIC_STRING = "static";
    public String FINAL_STRING = "final";
    public String TRANSIENT_STRING = "transient";
    public String ABSTRACT_STRING = "abstract";
    public String SYNCHRONIZED_STRING = "synchronized";
    public String NATIVE_STRING = "native";
    public String EQUALS_METHOD_STRING = "equals";
    public String COMPARE_TO_METHOD_STRING = "compareTo";
    public String ADD_TO_SET_METHOD_STRING = "add";
    public String SET_CONTAINS_METHOD_STRING = "contains";
    public static final int NO_ORDER = 0;
    public static final int ORDER = 1;
    private transient TreeMap progLangTypes = null;
    protected String[] visibilityStrings = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.OOGenVisitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public OOGenVisitor() {
        this.initVisibilityStrings();
        this.initProgLangTypes();
    }

    public OOGenVisitor(String extender) {
        this();
        this.setExtender(extender);
    }

    public abstract String getReferenceTemplateName();

    public abstract String getAssocTemplateName();

    public abstract String getContainerName(OOCollectionEnum var1, boolean var2);

    public final String getContainerName(OOCollectionEnum containerType) {
        return this.getContainerName(containerType, false);
    }

    public abstract void generateClassEndBlock();

    public abstract void generateClassStartBlock();

    public abstract void generatePackageBegin(FFile var1);

    public abstract void generatePackageEnd(FFile var1);

    public abstract String generateImportPackage(FPackage var1);

    public abstract String generateImportClass(FClass var1);

    public abstract String getAttrDeclName(FAttr var1);

    public abstract String getMethodDeclName(FMethod var1);

    public String getMethodName(OOMethod methodName) {
        String name = methodName.getName();
        StringBuffer result = new StringBuffer();
        if (methodName.getType() == OOMethodType.DEFAULT_METHOD) {
            return methodName.getName();
        }
        if (methodName.getType() == OOMethodType.GET_METHOD) {
            result.append("get");
        } else if (methodName.getType() == OOMethodType.IS_METHOD) {
            result.append("is");
        } else if (methodName.getType() == OOMethodType.SET_METHOD) {
            result.append("set");
        } else if (methodName.getType() == OOMethodType.HAS_IN_METHOD) {
            if (!EMPTY_STRING.equals(name)) {
                result.append("hasIn");
            } else {
                result.append("contains");
            }
        } else if (methodName.getType() == OOMethodType.ELEMENTS_OF_METHOD) {
            result.append("elementsOf");
        } else if (methodName.getType() == OOMethodType.ITERATOR_OF_METHOD) {
            if (!EMPTY_STRING.equals(name)) {
                result.append("iteratorOf");
            } else {
                result.append("iterator");
            }
        } else {
            if (methodName.getType() == OOMethodType.OLD_STYLE_ELEMENTS) {
                result.append(name);
                result.append("Elements");
                return result.toString();
            }
            if (methodName.getType() == OOMethodType.REMOVE_YOU_METHOD) {
                return "removeYou";
            }
            if (methodName.getType() == OOMethodType.ADD_METHOD) {
                if (!EMPTY_STRING.equals(name)) {
                    result.append("addTo");
                } else {
                    result.append("add");
                }
            } else if (methodName.getType() == OOMethodType.REMOVE_METHOD) {
                if (!EMPTY_STRING.equals(name)) {
                    result.append("removeFrom");
                } else {
                    result.append("remove");
                }
            } else if (methodName.getType() == OOMethodType.GET_FROM_METHOD) {
                if (!EMPTY_STRING.equals(name)) {
                    result.append("getFrom");
                } else {
                    result.append("get");
                }
            } else if (methodName.getType() == OOMethodType.SIZE_OF_METHOD) {
                if (!EMPTY_STRING.equals(name)) {
                    result.append("sizeOf");
                } else {
                    result.append("size");
                }
            } else if (methodName.getType() == OOMethodType.REMOVE_ALL_FROM_METHOD) {
                if (!EMPTY_STRING.equals(name)) {
                    result.append("removeAllFrom");
                } else {
                    result.append("clear");
                }
            } else if (methodName.getType() == OOMethodType.INDEX_OF_METHOD) {
                result.append("indexOf");
            } else if (methodName.getType() == OOMethodType.LAST_INDEX_OF_METHOD) {
                result.append("lastIndexOf");
            } else if (methodName.getType() == OOMethodType.IS_BEFORE_OF_METHOD) {
                result.append("isBeforeOf");
            } else if (methodName.getType() == OOMethodType.IS_AFTER_OF_METHOD) {
                result.append("isAfterOf");
            } else if (methodName.getType() == OOMethodType.GET_FIRST_OF_METHOD) {
                result.append("getFirst");
                if (!EMPTY_STRING.equals(name)) {
                    result.append("Of");
                }
            } else if (methodName.getType() == OOMethodType.GET_LAST_OF_METHOD) {
                result.append("getLast");
                if (!EMPTY_STRING.equals(name)) {
                    result.append("Of");
                }
            } else if (methodName.getType() == OOMethodType.GET_NEXT_OF_METHOD) {
                result.append("getNextOf");
            } else if (methodName.getType() == OOMethodType.GET_NEXT_INDEX_OF_METHOD) {
                result.append("getNextIndexOf");
            } else if (methodName.getType() == OOMethodType.GET_PREVIOUS_OF_METHOD) {
                result.append("getPreviousOf");
            } else if (methodName.getType() == OOMethodType.GET_PREVIOUS_INDEX_OF_METHOD) {
                result.append("getPreviousIndexOf");
            } else if (methodName.getType() == OOMethodType.ADD_BEFORE_OF_METHOD) {
                result.append("addBeforeOf");
            } else if (methodName.getType() == OOMethodType.ADD_AFTER_OF_METHOD) {
                result.append("addAfterOf");
            } else if (methodName.getType() == OOMethodType.GET_VALUE_FROM_METHOD) {
                result.append("getValueFrom");
            } else if (methodName.getType() == OOMethodType.GET_KEY_FROM_METHOD) {
                result.append("getKeyFrom");
            } else if (methodName.getType() == OOMethodType.HAS_VALUE_IN_METHOD) {
                if (!EMPTY_STRING.equals(name)) {
                    result.append("hasValueIn");
                } else {
                    result.append("containsValue");
                }
            } else if (methodName.getType() == OOMethodType.HAS_KEY_IN_METHOD) {
                if (!EMPTY_STRING.equals(name)) {
                    result.append("hasKeyIn");
                } else {
                    result.append("containsKey");
                }
            } else if (methodName.getType() == OOMethodType.HAS_ENTRY_IN_METHOD) {
                result.append("hasEntryIn");
            } else if (methodName.getType() == OOMethodType.KEYS_OF_METHOD) {
                if (!EMPTY_STRING.equals(name)) {
                    result.append("keysOf");
                } else {
                    result.append("keySet ().iterator");
                }
            } else if (methodName.getType() == OOMethodType.REMOVE_VALUE_FROM_METHOD) {
                result.append("removeValueFrom");
            } else if (methodName.getType() == OOMethodType.REMOVE_KEY_FROM_METHOD) {
                if (!EMPTY_STRING.equals(name)) {
                    result.append("removeKeyFrom");
                } else {
                    result.append("remove");
                }
            } else if (methodName.getType() == OOMethodType.REMOVE_ENTRY_FROM_METHOD) {
                result.append("removeEntryFrom");
            } else if (methodName.getType() == OOMethodType.ENTRIES_OF_METHOD) {
                if (!EMPTY_STRING.equals(name)) {
                    result.append("entriesOf");
                } else {
                    result.append("entrySet ().iterator");
                }
            } else {
                if (methodName.getType() == OOMethodType.GET_AT_METHOD) {
                    result.append("get").append(CGU.upFirstChar(name)).append("At");
                    return result.toString();
                }
                if (methodName.getType() == OOMethodType.IS_EMPTY_METHOD) {
                    result.append("is" + CGU.upFirstChar(name) + "Empty");
                    return result.toString();
                }
                if (methodName.getType() == OOMethodType.EQUALS_METHOD) {
                    return this.EQUALS_METHOD_STRING;
                }
                if (methodName.getType() == OOMethodType.ADD_TO_SET_METHOD) {
                    return this.ADD_TO_SET_METHOD_STRING;
                }
                if (methodName.getType() == OOMethodType.SET_CONTAINS_METHOD) {
                    return this.SET_CONTAINS_METHOD_STRING;
                }
            }
        }
        result.append(CGU.upFirstChar(name));
        return result.toString();
    }

    public void generateOpenBlock(String blockType) {
        this.getCurrentBuffer().append(this.indentText(blockType));
        this.newLine();
        this.incIndentNr();
    }

    public void generateCloseBlock(String blockType) {
        this.decIndentNr();
        this.getCurrentBuffer().append(this.indentText(blockType));
        this.newLine();
    }

    public String createClassInterfaceModifier(FClass theClass) {
        StringBuffer modifier = new StringBuffer();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getVisibilityString(" + theClass + "," + theClass.getVisibility() + ")=" + this.getVisibilityString(theClass.getVisibility())));
        }
        modifier.append(this.getVisibilityString(theClass.getVisibility()));
        if (theClass.isStatic()) {
            modifier.append(" ");
            modifier.append(this.F_STATIC_STRING);
        }
        if (theClass.isFinal()) {
            modifier.append(" ");
            modifier.append(this.FINAL_STRING);
        }
        return modifier.toString();
    }

    public String createInterfaceDeclaration(FClass theClass) {
        StringBuffer interfaceDeclString = new StringBuffer();
        interfaceDeclString.append(this.createClassInterfaceModifier(theClass));
        interfaceDeclString.append(" ");
        interfaceDeclString.append(this.INTERFACE_STRING);
        interfaceDeclString.append(" ");
        interfaceDeclString.append(this.getInterfaceName(theClass));
        interfaceDeclString.append(this.createInterfaceExtendsDeclaration(theClass));
        return interfaceDeclString.toString();
    }

    public String createClassDeclaration(FClass theClass) {
        StringBuffer classDeclString = new StringBuffer();
        if (this.createClassInterfaceModifier(theClass) != null) {
            classDeclString.append(this.createClassInterfaceModifier(theClass));
            classDeclString.append(" ");
        }
        if (theClass.isAbstract()) {
            classDeclString.append(this.ABSTRACT_STRING);
            classDeclString.append(" ");
        }
        if (theClass.hasKeyInStereotypes("final")) {
            classDeclString.append("final ");
        }
        if (theClass.hasKeyInStereotypes("strictfp")) {
            classDeclString.append("strictfp ");
        }
        classDeclString.append(this.CLASS_STRING);
        classDeclString.append(" ");
        classDeclString.append(this.getClassName(theClass));
        classDeclString.append(this.createClassExtendsDeclaration(theClass));
        return classDeclString.toString();
    }

    public String createClassExtendsDeclaration(FClass theClass) {
        StringBuffer declString = new StringBuffer();
        FClass superClass = theClass.getFSuperClass();
        if (superClass != null) {
            declString.append("\n");
            declString.append(this.EXTENDS_STRING);
            declString.append(" ");
            declString.append(this.getClassName(superClass));
        }
        Path parentEnum = theClass.iteratorOfSuperClasses();
        boolean firstTime = true;
        FClass tmpClass = null;
        UMLStereotype interfaceType = UMLStereotypeManager.get().getFromStereotypes("interface");
        while (parentEnum.hasMoreElements()) {
            tmpClass = (FClass)parentEnum.nextElement();
            if (!tmpClass.hasInStereotypes(interfaceType)) continue;
            if (!firstTime) {
                declString.append(", ");
            } else {
                declString.append("\n");
                declString.append(this.IMPLEMENTS_STRING);
                declString.append(" ");
                firstTime = false;
            }
            declString.append(this.getClassName(tmpClass));
        }
        return declString.toString();
    }

    public String createInterfaceExtendsDeclaration(FClass theClass) {
        StringBuffer declString = new StringBuffer();
        Path parentEnum = theClass.iteratorOfSuperClasses();
        FClass tmpClass = null;
        boolean firstTime = true;
        while (parentEnum.hasMoreElements()) {
            tmpClass = (FClass)parentEnum.nextElement();
            if (!firstTime) {
                declString.append(", ");
            } else {
                declString.append("\n");
                declString.append(this.EXTENDS_STRING);
                declString.append(" ");
                firstTime = false;
            }
            declString.append(this.getClassName(tmpClass));
        }
        return declString.toString();
    }

    public String createClassCommentary(FCommentary theCommentary) {
        return this.createCommentary(theCommentary.getText());
    }

    public String createAttrCommentary(FCommentary theCommentary) {
        return this.createCommentary(theCommentary.getText());
    }

    public String createMethodCommentary(FCommentary theCommentary) {
        return this.createCommentary(theCommentary.getText());
    }

    public String createAttrDeclaration(FAttr theAttr) {
        StringBuffer declString = new StringBuffer();
        int visibility = theAttr.getVisibility();
        if (theAttr.isNeedsAccessMethods() && !theAttr.isParsed()) {
            visibility = 0;
        }
        declString.append(this.getAttrDeclVisibilityString(visibility));
        declString.append(" ");
        if (theAttr.isStatic()) {
            declString.append(this.F_STATIC_STRING);
            declString.append(" ");
        }
        if (theAttr.isFinal()) {
            declString.append(this.FINAL_STRING);
            declString.append(" ");
        }
        if (theAttr.isTransient()) {
            declString.append(this.TRANSIENT_STRING);
            declString.append(" ");
        }
        if (theAttr.hasKeyInStereotypes("volatile")) {
            declString.append("volatile ");
        }
        declString.append(this.getTypeAsString(theAttr.getFAttrType(), false));
        declString.append(" ");
        declString.append(this.getAttrDeclName(theAttr));
        if (!Utility.isNullOrEmpty(theAttr.getInitialValue())) {
            declString.append(" = " + theAttr.getInitialValue());
        }
        declString.append(";");
        declString.append("\n\n");
        return this.indentText(declString.toString());
    }

    public String createMethodDeclaration(FMethod theMethod) {
        String declString = null;
        FType returnType = theMethod.getFResultType();
        if (returnType == null) {
            log.error((Object)("Method has no Return Type: " + theMethod.getName()));
        }
        declString = returnType != null && returnType.getName().equals("Initializer") ? this.createInitializerDeclaration(theMethod) : this.createNormalFMethodDeclaration(theMethod);
        return declString;
    }

    public String createInitializerDeclaration(FMethod theMethod) {
        StringBuffer declString = new StringBuffer();
        declString.append(this.F_STATIC_STRING);
        declString.append(" ");
        return this.indentText(declString.toString());
    }

    public String createNormalFMethodDeclaration(FMethod theMethod) {
        StringBuffer declString = new StringBuffer();
        if (this.getMethodDeclVisibilityString(theMethod.getVisibility()) != null) {
            declString.append(this.getMethodDeclVisibilityString(theMethod.getVisibility()));
            declString.append(" ");
        }
        if (theMethod.isAbstract()) {
            declString.append(this.ABSTRACT_STRING);
            declString.append(" ");
        }
        if (theMethod.isUmlNative()) {
            declString.append(this.NATIVE_STRING);
            declString.append(" ");
        }
        if (theMethod.isSynchronized()) {
            declString.append(this.SYNCHRONIZED_STRING);
            declString.append(" ");
        }
        if (theMethod.isStatic()) {
            declString.append(this.F_STATIC_STRING);
            declString.append(" ");
        }
        if (theMethod.isFinal()) {
            declString.append(this.FINAL_STRING);
            declString.append(" ");
        }
        if (theMethod.getFResultType() != null) {
            declString.append(this.getTypeAsString(theMethod.getFResultType(), theMethod.isResultTypeIsPointer()));
            declString.append(" ");
        } else {
            declString.append("result_type_is_missing");
        }
        declString.append(this.getMethodDeclName(theMethod));
        declString.append(this.OPEN_NORM_BRACKET);
        declString.append(this.createMethodParamList(theMethod));
        declString.append(this.CLOSE_NORM_BRACKET);
        if (theMethod.sizeOfThrowsTypes() > 0) {
            boolean firstThrow = true;
            Iterator throwsIter = theMethod.iteratorOfThrowsTypes();
            FType myThrowType = null;
            while (throwsIter.hasNext()) {
                if (firstThrow) {
                    declString.append(" throws ");
                    firstThrow = false;
                } else {
                    declString.append(", ");
                }
                myThrowType = (FType)throwsIter.next();
                declString.append(myThrowType.getName());
            }
        }
        return this.indentText(declString.toString());
    }

    public String createOpenBlock(String blockType) {
        String result = "\n" + this.indentText(blockType) + "\n";
        this.incIndentNr();
        return result;
    }

    public String createCloseBlock(String blockType) {
        this.decIndentNr();
        String result = "\n" + this.indentText(blockType) + "\n";
        return result;
    }

    public String createMethodParamList(FMethod theMethod) {
        Iterator iter = theMethod.iteratorOfParam();
        StringBuffer declString = new StringBuffer();
        while (iter.hasNext()) {
            FParam param = (FParam)iter.next();
            declString.append(this.createMethodParam(param));
            if (!iter.hasNext()) continue;
            declString.append(this.LIST_SEPARATOR);
            declString.append(" ");
        }
        return declString.toString();
    }

    public String createMethodParam(FParam theParam) {
        StringBuffer declString = new StringBuffer();
        if (theParam.getFParamType() == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"ERROR: parameter in method found without a type !");
            }
            if (theParam.getFRevParam().getFParent() != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("\tClass    : " + theParam.getFRevParam().getFParent().getID() + ": " + theParam.getFRevParam().getFParent().getName()));
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"\tClass    : NULL !!!");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("\tMethod   : " + theParam.getFRevParam().getID() + ": " + theParam.getFRevParam().getName()));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("\tParameter: " + theParam.getID() + ": " + theParam.getName()));
            }
        } else {
            declString.append(this.getTypeAsString(theParam.getFParamType(), theParam.isPointer()));
            declString.append(" ");
            declString.append(theParam.getName());
        }
        return declString.toString();
    }

    public abstract String getSourceCode(OOThrowStatement var1);

    public String getSourceCode(OOExprStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        StringBuffer result = new StringBuffer();
        String exprCode = statement.getExpr().getSourceCode(this);
        if (exprCode == null) {
            return null;
        }
        result.append(this.createIndentString());
        result.append(exprCode);
        result.append(this.END_OF_STATEMENT);
        return result.toString();
    }

    public String getSourceCode(OOIfStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        StringBuffer result = new StringBuffer();
        result.append(this.createIndentString());
        result.append(this.IF_STRING);
        result.append(" ");
        result.append(this.OPEN_NORM_BRACKET);
        result.append(" ");
        if (statement.getCondition() != null) {
            result.append(statement.getCondition().getSourceCode(this));
        } else {
            result.append(String.valueOf(this.START_BLOCK_COMMENTARY) + " oops, condition is missing " + this.END_BLOCK_COMMENTARY);
        }
        result.append(" ");
        result.append(this.CLOSE_NORM_BRACKET);
        return result.toString();
    }

    public String getSourceCode(OOWhileStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        StringBuffer result = new StringBuffer();
        result.append(this.createIndentString());
        result.append(this.WHILE_STRING);
        result.append(" ");
        result.append(this.OPEN_NORM_BRACKET);
        result.append(" ");
        if (statement.getCondition() != null) {
            result.append(statement.getCondition().getSourceCode(this));
        } else {
            result.append(String.valueOf(this.START_BLOCK_COMMENTARY) + " oops, condition is missing " + this.END_BLOCK_COMMENTARY);
        }
        result.append(" ");
        result.append(this.CLOSE_NORM_BRACKET);
        if (statement.isFoot()) {
            result.append(" ");
            result.append(this.END_OF_STATEMENT);
        }
        return result.toString();
    }

    public String getSourceCode(OOForStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        StringBuffer result = new StringBuffer();
        result.append(this.createIndentString());
        result.append(this.FOR_STRING);
        result.append(" ");
        result.append(this.OPEN_NORM_BRACKET);
        result.append(" ");
        if (statement.getInitExpr() != null) {
            result.append(statement.getInitExpr().getSourceCode(this));
        } else {
            result.append(String.valueOf(this.START_BLOCK_COMMENTARY) + " oops, initExpr is missing " + this.END_BLOCK_COMMENTARY);
        }
        result.append(this.END_OF_STATEMENT);
        if (statement.getEndExpr() != null) {
            result.append(statement.getEndExpr().getSourceCode(this));
        } else {
            result.append(String.valueOf(this.START_BLOCK_COMMENTARY) + " oops, endExpr is missing " + this.END_BLOCK_COMMENTARY);
        }
        result.append(this.END_OF_STATEMENT);
        if (statement.getStepExpr() != null) {
            result.append(statement.getStepExpr().getSourceCode(this));
        } else {
            result.append(String.valueOf(this.START_BLOCK_COMMENTARY) + " oops, stepExpr is missing " + this.END_BLOCK_COMMENTARY);
        }
        result.append(" ");
        result.append(this.CLOSE_NORM_BRACKET);
        return result.toString();
    }

    public String getSourceCode(OOElseStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        StringBuffer result = new StringBuffer();
        result.append(this.createIndentString());
        result.append(this.ELSE_STRING);
        return result.toString();
    }

    public String getSourceCode(OOLineCommentStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        StringTokenizer toki = new StringTokenizer(statement.getComment(), "\n");
        StringBuffer result = new StringBuffer();
        if (toki.countTokens() == 1) {
            result.append(this.createIndentString());
            result.append(this.createLineCommentary(statement.getComment()));
        } else if (toki.countTokens() > 1) {
            result.append(this.indentText(this.createCommentary(statement.getComment()), this.createIndentString()));
        }
        return result.toString();
    }

    public String getSourceCode(OOLocalVarDeclStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        StringBuffer result = new StringBuffer();
        result.append(this.createIndentString());
        if (!statement.isDeclared()) {
            result.append(this.getOOTypeAsString(statement.getVarType()));
            result.append(" ");
        }
        result.append(this.getVarName(statement.getObjectName()));
        OOExpression initExpr = statement.getInitExpr();
        if (initExpr != null) {
            result.append(" ");
            result.append(this.ASSIGNMENT_OP_STRING);
            result.append(" ");
            result.append(initExpr.getSourceCode(this));
        }
        result.append(" ");
        result.append(this.END_OF_STATEMENT);
        return result.toString();
    }

    public String getSourceCode(OOStartBlockStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        String result = String.valueOf(this.createIndentString()) + this.START_BLOCK;
        this.incIndentNr();
        return result;
    }

    public String getSourceCode(OOEndBlockStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        this.decIndentNr();
        StringBuffer result = new StringBuffer();
        result.append(this.createIndentString());
        result.append(this.END_BLOCK);
        if (statement.getText() != null) {
            result.append(" ");
            result.append(this.createLineCommentary(statement.getText()));
        }
        return result.toString();
    }

    public String getSourceCode(OOSDMEnsureStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        StringBuffer result = new StringBuffer();
        result.append(this.createIndentString());
        if (statement instanceof OOUnitAssertStatement) {
            result.append(this.UNIT_ASSERT_STRING);
        } else {
            result.append(this.SDM_ENSURE_STRING);
        }
        result.append(" ");
        result.append(this.OPEN_NORM_BRACKET);
        result.append(" ");
        if (statement instanceof OOUnitAssertStatement) {
            result.append("\"" + ((OOUnitAssertStatement)statement).getDescription() + "\", ");
        }
        if (statement.getCondition() != null) {
            result.append(statement.getCondition().getSourceCode(this));
        } else if (statement.getConditionText() != null) {
            result.append(statement.getConditionText());
        } else {
            result.append(String.valueOf(this.START_BLOCK_COMMENTARY) + " oops, condition is missing " + this.END_BLOCK_COMMENTARY);
        }
        result.append(" ");
        result.append(this.CLOSE_NORM_BRACKET);
        result.append(" ");
        result.append(this.END_OF_STATEMENT);
        return result.toString();
    }

    public String getSourceCode(OOTryStatement statement) {
        return String.valueOf(this.createIndentString()) + this.TRY_STRING;
    }

    public String getSourceCode(OOReturnStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        StringBuffer result = new StringBuffer();
        result.append(this.createIndentString());
        result.append(this.RETURN_STRING);
        if (statement.getReturnValue() != null) {
            result.append(" ");
            result.append(this.OPEN_NORM_BRACKET);
            result.append(statement.getReturnValue().getSourceCode(this));
            result.append(this.CLOSE_NORM_BRACKET);
            result.append(" ");
        } else if (statement.getReturnValueName() != null && !statement.getReturnValueName().equals(EMPTY_STRING)) {
            result.append(" ");
            result.append(this.OPEN_NORM_BRACKET);
            result.append(statement.getReturnValueName());
            result.append(this.CLOSE_NORM_BRACKET);
            result.append(" ");
        }
        result.append(this.END_OF_STATEMENT);
        return result.toString();
    }

    public String getSourceCode(OOCatchStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        StringBuffer result = new StringBuffer();
        result.append(this.createIndentString());
        result.append(this.CATCH_STRING);
        result.append(" ");
        result.append(this.OPEN_NORM_BRACKET);
        result.append(" ");
        result.append(statement.getExceptionType().getSourceCode(this));
        result.append(" ");
        result.append(this.getVarName(statement.getExceptionName()));
        result.append(" ");
        result.append(this.CLOSE_NORM_BRACKET);
        return result.toString();
    }

    public String getSourceCode(OOStartMethodBodyStatement statement) {
        return null;
    }

    public String getSourceCode(OOBeginMethodBodyStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        String result = String.valueOf(this.createIndentString()) + this.START_METHOD_BLOCK;
        this.incIndentNr();
        return result;
    }

    public String getSourceCode(OOEndMethodBodyStatement statement) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + statement + ")"));
        }
        this.decIndentNr();
        return String.valueOf(this.createIndentString()) + this.END_METHOD_BLOCK;
    }

    public String getSourceCode(OOEmptyLineStatement statement) {
        return String.valueOf(this.createIndentString()) + " ";
    }

    public String getSourceCode(OODoStatement statement) {
        return String.valueOf(this.createIndentString()) + this.DO_STRING;
    }

    public String getSourceCode(OOMemoStatement statement) {
        return String.valueOf(this.createIndentString()) + statement.getMemo();
    }

    public String getSourceCode(OOBreakStatement statement) {
        return String.valueOf(this.createIndentString()) + this.BREAK_STRING + this.END_OF_STATEMENT;
    }

    public final String getSourceCode(OOSwitchCaseStatement statement) {
        StringBuffer result = new StringBuffer();
        result.append(String.valueOf(this.createIndentString()) + this.SWITCH_STRING + this.OPEN_NORM_BRACKET + statement.getVariable().getFirstName() + this.CLOSE_NORM_BRACKET + this.START_BLOCK + this.END_OF_LINE);
        this.incIndentNr();
        Iterator iter = statement.getCases();
        while (iter.hasNext()) {
            OOCaseStatement caseStatement = (OOCaseStatement)iter.next();
            result.append(caseStatement.getSourceCode(this));
        }
        this.decIndentNr();
        result.append(String.valueOf(this.createIndentString()) + this.END_BLOCK);
        return result.toString();
    }

    public final String getSourceCode(OOCaseStatement caseStatement) {
        StringBuffer result = new StringBuffer();
        Iterator iter = caseStatement.getValues();
        while (iter.hasNext()) {
            String value = (String)iter.next();
            result.append(String.valueOf(this.createIndentString()) + this.CASE_STRING + " " + value + ":" + this.END_OF_LINE);
        }
        Vector vector = caseStatement.getStatements();
        int i = 0;
        while (i < vector.size()) {
            OOStatement statement = (OOStatement)vector.get(i);
            result.append(String.valueOf(this.createIndentString()) + statement.getSourceCode(this) + this.END_OF_LINE);
            ++i;
        }
        return result.toString();
    }

    public final String getSourceCode(OOStatement statement) {
        return this + ".getSourceCode(" + statement + ") is empty !";
    }

    public final String appendStatement(OOStatement statement) {
        return String.valueOf(this.LINE_COMMENTARY) + " " + statement;
    }

    abstract String getSourceCode(OOObjectOfTypeExpr var1);

    abstract String getSourceCode(OOClassOfVariableExpr var1);

    abstract String getSourceCode(OOFWIteratorOfExpr var1);

    abstract String getSourceCode(OOFWIteratorGetExpr var1);

    abstract String getSourceCode(OOFWIteratorHasNextExpr var1);

    abstract String getSourceCode(OOFWIteratorGotoNextExpr var1);

    public abstract String getSourceCode(OONewArrayExpr var1);

    public final String getSourceCode(OONewObjectExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append("new ");
        result.append(this.getOOTypeAsString(expression.getVarType()));
        result.append(" (");
        Iterator iter = expression.iteratorOfParameter();
        while (iter.hasNext()) {
            OOExpression tmpParameter = (OOExpression)iter.next();
            result.append(tmpParameter.getSourceCode(this));
            if (!iter.hasNext()) continue;
            result.append(this.LIST_SEPARATOR);
            result.append(" ");
        }
        result.append(" )");
        return result.toString();
    }

    public String getSourceCode(OOPrefixExpr expression) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + expression + ")"));
        }
        boolean needBrackets = !(expression.getMyExpr() instanceof OOVariable);
        StringBuffer result = new StringBuffer();
        if (expression.getMyOp() == OOPrefixOp.NOT_OP) {
            result.append(this.NOT_OP_STRING);
        } else if (expression.getMyOp() == OOPrefixOp.INCR_OP) {
            result.append(this.INCR_OP_STRING);
        } else if (expression.getMyOp() == OOPrefixOp.DECR_OP) {
            result.append(this.DECR_OP_STRING);
        } else {
            result.append(this.START_BLOCK_COMMENTARY).append(" unsupported op ").append(expression.getMyOp()).append(this.END_BLOCK_COMMENTARY);
        }
        if (needBrackets) {
            result.append(this.OPEN_NORM_BRACKET);
        }
        result.append(expression.getMyExpr().getSourceCode(this));
        if (needBrackets) {
            result.append(this.CLOSE_NORM_BRACKET);
        }
        return result.toString();
    }

    public String getSourceCode(OOInfixExprLeft expression) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + expression + ")"));
        }
        StringBuffer result = new StringBuffer();
        boolean needBrackets = expression.getMyExp() instanceof OOInfixExprLeft;
        OOInfixExprRight tmpRight = null;
        if (needBrackets) {
            result.append(this.OPEN_NORM_BRACKET);
        }
        if (expression.getMyExp() != null) {
            result.append(expression.getMyExp().getSourceCode(this));
        } else {
            result.append(String.valueOf(this.START_BLOCK_COMMENTARY) + " oops, getMyExp() is null ! " + this.END_BLOCK_COMMENTARY);
        }
        if (needBrackets) {
            result.append(this.CLOSE_NORM_BRACKET);
        }
        tmpRight = expression.getRightExp();
        while (tmpRight != null) {
            needBrackets = tmpRight.getMyExp() instanceof OOInfixExprLeft;
            result.append(" ");
            result.append(this.getSourceCode(tmpRight.getMyOp()));
            result.append(" ");
            if (needBrackets) {
                result.append(this.OPEN_NORM_BRACKET);
            }
            result.append(tmpRight.getMyExp().getSourceCode(this));
            if (needBrackets) {
                result.append(this.CLOSE_NORM_BRACKET);
            }
            tmpRight = tmpRight.getNextExpression();
        }
        return result.toString();
    }

    public String getSourceCode(OOIdentifierExpr expression) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + expression + ")"));
        }
        String result = null;
        result = expression == OOIdentifierExpr.NULL_IDENTIFIER ? this.NULL_STRING : (expression == OOIdentifierExpr.FALSE_IDENTIFIER ? this.FALSE_STRING : (expression == OOIdentifierExpr.TRUE_IDENTIFIER ? this.TRUE_STRING : this.getVarName(expression.getVariableName())));
        return result;
    }

    public String getSourceCode(OOTypeCastExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append(this.OPEN_NORM_BRACKET);
        result.append(this.getOOTypeAsString(expression.getTypeName(), true));
        result.append(this.CLOSE_NORM_BRACKET);
        result.append(" ");
        result.append(expression.getCastSource().getSourceCode(this));
        return result.toString();
    }

    public String getSourceCode(OOAssignExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append(expression.getLeftExpr().getSourceCode(this));
        result.append(" ");
        result.append(this.ASSIGNMENT_OP_STRING);
        result.append(" ");
        result.append(expression.getRightExpr().getSourceCode(this));
        return result.toString();
    }

    public String getSourceCode(OOCallAttrExpr expression) {
        StringBuffer result = new StringBuffer();
        if (expression.getObjectName() != null && this.getVarName(expression.getObjectName()) != null) {
            result.append(this.getVarName(expression.getObjectName()));
            result.append(".");
        }
        if (expression.getAttrName() != null && this.getVarName(expression.getAttrName()) != null) {
            result.append(this.getVarName(expression.getAttrName()));
        } else {
            result.append(" /* oops, no attr name */ ");
        }
        if (expression.getNextCall() != null) {
            result.append(".");
            result.append(expression.getNextCall().getSourceCode(this));
        }
        return result.toString();
    }

    public String getSourceCode(OOCallMethodExpr expression) {
        StringBuffer result = new StringBuffer();
        if (expression.getObjectName() != null && this.getVarName(expression.getObjectName()) != null) {
            result.append(this.getVarName(expression.getObjectName()));
            result.append(".");
        }
        result.append(this.getMethodName(expression.getMethodName()));
        result.append(" ");
        result.append(this.OPEN_NORM_BRACKET);
        Iterator iter = expression.iteratorOfParameter();
        OOExpression tmpParameter = null;
        while (iter.hasNext()) {
            tmpParameter = (OOExpression)iter.next();
            result.append(tmpParameter.getSourceCode(this));
            if (!iter.hasNext()) continue;
            result.append(this.LIST_SEPARATOR);
            result.append(" ");
        }
        result.append(this.CLOSE_NORM_BRACKET);
        if (expression.getNextCall() != null) {
            result.append(".");
            result.append(expression.getNextCall().getSourceCode(this));
        }
        return result.toString();
    }

    public String getSourceCode(OOExceptionExpr expression) {
        if (expression == OOExceptionExpr.SDM_EXCEPTION) {
            return this.SDM_EXCEPTION_STRING;
        }
        if (expression == OOExceptionExpr.INTERRUPTED_EXCEPTION) {
            return this.INTERRUPTED_EXCEPTION_STRING;
        }
        if (expression == OOExceptionExpr.ILLEGALDATA_EXCEPTION) {
            return this.ILLEGALDATA_EXCEPTION_STRING;
        }
        return this.getOOTypeAsString(expression.getExceptionType());
    }

    public String getSourceCode(OOVariable var) {
        return this.getVarName(var);
    }

    public final String getSourceCode(OOStringExpr expression) {
        return expression.getCondition();
    }

    public final String getSourceCode(OOExpression expression) {
        return this + ".getSourceCode(" + expression + ") is empty !";
    }

    public String getSourceCode(OOInfixOp theOp) {
        if (log.isDebugEnabled() && log.isInfoEnabled()) {
            log.info((Object)(this + ".getSourceCode(" + theOp + ")"));
        }
        String result = null;
        result = OOInfixOp.AND_OP.equals(theOp) ? this.AND_OP_STRING : (OOInfixOp.OR_OP.equals(theOp) ? this.OR_OP_STRING : (OOInfixOp.EQUAL_OP.equals(theOp) ? this.EQUAL_OP_STRING : (OOInfixOp.NOT_EQUAL_OP.equals(theOp) ? this.NOT_EQUAL_OP_STRING : (OOInfixOp.LESS_OP.equals(theOp) ? this.LESS_OP_STRING : (OOInfixOp.GREATER_OP.equals(theOp) ? this.GREATER_OP_STRING : (OOInfixOp.LESS_EQUAL_OP.equals(theOp) ? this.LESS_EQUAL_OP_STRING : (OOInfixOp.GREATER_EQUAL_OP.equals(theOp) ? this.GREATER_EQUAL_OP_STRING : (OOInfixOp.ADD_OP.equals(theOp) ? this.ADD_OP_STRING : (OOInfixOp.SUB_OP.equals(theOp) ? this.SUB_OP_STRING : (OOInfixOp.MUL_OP.equals(theOp) ? this.MUL_OP_STRING : (OOInfixOp.DIV_OP.equals(theOp) ? this.DIV_OP_STRING : "unkown op " + theOp)))))))))));
        return result;
    }

    public void appendClassCommentary(String comment) {
        this.getCurrentBuffer().append(comment);
    }

    public void appendClassDeclaration(String declString) {
        this.getCurrentBuffer().append(declString);
        this.newLine();
    }

    public void appendAttrCommentary(String comment) {
        this.getCurrentBuffer().append(comment);
    }

    public void appendAttrDeclaration(String declString) {
        this.getCurrentBuffer().append(declString);
        this.newLine();
        this.newLine();
    }

    public void appendMethodCommentary(String comment) {
        this.getCurrentBuffer().append(comment);
    }

    public void appendMethodDeclaration(String declString) {
        this.getCurrentBuffer().append(declString);
    }

    public void appendMethodBody(String body) {
        this.getCurrentBuffer().append(body != null ? body : this.END_OF_STATEMENT);
    }

    public String getVarName(OOVariableType type) {
        return this.getVarName(OO.variable(type));
    }

    /*
     * WARNING - void declaration
     */
    public String getVarName(OOVariable variableName) {
        void var3_3;
        String result;
        String fujabaPrefix = JavaPreferences.get().getInternalVariablePrefix();
        if (OOVariableType.iFujabaOrig == variableName.getType()) {
            result = variableName.getFirstName();
        } else if (OOVariableType.iFujabaSuccess == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "Success";
        } else if (OOVariableType.iFujabaAtEnd == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "AtEnd";
        } else if (OOVariableType.iFujabaNextStep == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "NextStep";
        } else if (OOVariableType.iFujabaReturnParam == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "ReturnParam";
        } else if (OOVariableType.iFujabaEnum == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "Enum";
        } else if (OOVariableType.iFujabaOptional == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "Optional";
        } else if (OOVariableType.iFujabaFirstBinding == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "FirstBinding";
        } else if (OOVariableType.iBreakExceptionVariable == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "InternalException";
        } else if (OOVariableType.iBreakExceptionText == variableName.getType()) {
            result = CGU.upFirstChar(this.getVarName(OOVariableType.iBreakExceptionVariable)).toString();
        } else if (OOVariableType.iFujabaTmpObject == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "TmpObject" + variableName.getFirstName();
        } else if (OOVariableType.iFujabaGoodObject == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "GoodObject";
        } else if (OOVariableType.iFujabaIter == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "Iter" + variableName.getFirstName();
        } else if (OOVariableType.iFujabaFor == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + CGU.upFirstChar(variableName.getFirstName()) + "For" + CGU.upFirstChar(variableName.getSecondName());
        } else if (OOVariableType.iFujabaUpperBound == variableName.getType()) {
            result = String.valueOf(fujabaPrefix) + "UpperBound_" + CGU.upFirstChar(variableName.getFirstName());
        } else {
            throw new RuntimeException("Don't know how to handle the internal variable kind : " + variableName);
        }
        return var3_3;
    }

    public String getAttrDeclVisibilityString(int visibility) {
        return this.getVisibilityString(visibility);
    }

    public String getMethodDeclVisibilityString(int visibility) {
        return this.getVisibilityString(visibility);
    }

    public String getInterfaceName(FClass theClass) {
        return theClass.getName();
    }

    public String getClassName(FClass theClass) {
        return theClass.getName();
    }

    public final String getOOTypeAsString(OOTypeInterface theType) {
        return this.getOOTypeAsString(theType, false);
    }

    public final String getOOTypeAsString(OOTypeInterface theType, boolean isBound) {
        if (theType instanceof OOContainerType) {
            return this.getOOTypeAsString((OOContainerType)theType, isBound);
        }
        if (theType instanceof OOType) {
            return this.getOOTypeAsString((OOType)theType, isBound);
        }
        throw new Error(this + ".getOOTypeAsString(" + theType + "," + isBound + ")");
    }

    public String getOOTypeAsString(OOContainerType theType, boolean isBound) {
        return this.getTypeNameAsString(this.getContainerName(theType.getCollectionType(), isBound), theType.isPointer());
    }

    public final String getOOTypeAsString(OOType theType) {
        return this.getOOTypeAsString(theType, false);
    }

    public String getOOTypeAsString(OOType theType, boolean isBound) {
        if (theType.getUmlType() != OOType.EMPTY_TYPE) {
            return this.getTypeAsString(theType.getUmlType(), theType.isPointer());
        }
        if (theType.getTypeName() != null) {
            return this.getTypeNameAsString(theType.getTypeName(), theType.isPointer());
        }
        return String.valueOf(this.START_BLOCK_COMMENTARY) + " illegal type : " + theType + " " + this.END_BLOCK_COMMENTARY;
    }

    public String getTypeAsString(FType theType) {
        return this.getTypeAsString(theType, false);
    }

    public String getTypeAsString(FType theType, boolean isPointer) {
        String typeString = null;
        if (theType instanceof FBaseTypes) {
            typeString = this.getProgLangType((FBaseTypes)theType);
        } else if (theType instanceof FArray) {
            typeString = String.valueOf(this.getTypeAsString(((FArray)theType).getFArrayType(), false)) + "[]";
        } else {
            if (theType instanceof FClass) {
                FClass theClass = (FClass)theType;
                typeString = theClass.getName();
                theClass = theClass.getFDeclaredInClass();
                while (theClass != null) {
                    typeString = String.valueOf(theClass.getName()) + "." + typeString;
                    theClass = theClass.getFDeclaredInClass();
                }
            } else {
                String string = typeString = theType != null ? theType.getName() : null;
            }
            if (isPointer) {
                typeString = String.valueOf(typeString) + this.POINTER_POSTFIX;
            }
        }
        return typeString;
    }

    public String getTypeNameAsString(String typeName) {
        return this.getTypeNameAsString(typeName, false);
    }

    public String getTypeNameAsString(String typeName, boolean isPointer) {
        String newTypeName = this.getFromProgLangTypes(typeName);
        if (newTypeName != null) {
            return newTypeName;
        }
        boolean created = false;
        UMLType tmpType = UMLProject.get().findType(null, typeName);
        if (tmpType == null) {
            tmpType = UMLProject.get().getOrNewType(null, typeName, false);
            created = true;
        }
        newTypeName = tmpType instanceof FClass ? ((FClass)((Object)tmpType)).getFullClassName() : tmpType.getName();
        if (created && tmpType instanceof BasicIncrement) {
            ((BasicIncrement)((Object)tmpType)).removeYou();
        }
        return String.valueOf(newTypeName) + (isPointer ? this.POINTER_POSTFIX : EMPTY_STRING);
    }

    public final String getOperationText(int operation) {
        switch (operation) {
            case 0: {
                return this.EQUAL_OP_STRING;
            }
            case 1: {
                return this.NOT_EQUAL_OP_STRING;
            }
            case 2: {
                return this.LESS_OP_STRING;
            }
            case 3: {
                return this.GREATER_OP_STRING;
            }
            case 4: {
                return this.LESS_EQUAL_OP_STRING;
            }
            case 5: {
                return this.GREATER_EQUAL_OP_STRING;
            }
        }
        throw new Error("unsupported operation : " + operation);
    }

    protected abstract void initProgLangTypes();

    public final String getProgLangType(FBaseTypes baseType) {
        return this.getFromProgLangTypes(baseType.getName());
    }

    protected final boolean hasInProgLangTypes(String object) {
        if (this.progLangTypes == null) {
            return false;
        }
        return this.progLangTypes.containsValue(object);
    }

    protected final boolean hasKeyInProgLangTypes(String key) {
        if (this.progLangTypes == null) {
            return false;
        }
        return this.progLangTypes.containsKey(key);
    }

    protected final Iterator iteratorOfProgLangTypes() {
        if (this.progLangTypes == null) {
            return FEmptyIterator.get();
        }
        return this.progLangTypes.values().iterator();
    }

    protected final Iterator keysOfProgLangTypes() {
        if (this.progLangTypes == null) {
            return FEmptyIterator.get();
        }
        return this.progLangTypes.keySet().iterator();
    }

    protected final Iterator entriesOfProgLangTypes() {
        if (this.progLangTypes == null) {
            return FEmptyIterator.get();
        }
        return this.progLangTypes.entrySet().iterator();
    }

    protected final String getFromProgLangTypes(String key) {
        String elem = this.hasKeyInProgLangTypes(key) ? (String)this.progLangTypes.get(key) : null;
        return elem;
    }

    protected final void addToProgLangTypes(String key, String elem) {
        if (key != null && elem != null) {
            if (this.progLangTypes == null) {
                this.progLangTypes = new TreeMap();
            }
            this.progLangTypes.put(key, elem);
        }
    }

    protected final void removeKeyFromProgLangTypes(String key) {
        if (this.hasKeyInProgLangTypes(key)) {
            this.progLangTypes.remove(key);
        }
    }

    protected final void removeAllFromProgLangTypes() {
        Iterator iter = this.keysOfProgLangTypes();
        String tmpKey = null;
        while (iter.hasNext()) {
            tmpKey = (String)iter.next();
            iter.remove();
            this.removeKeyFromProgLangTypes(tmpKey);
        }
    }

    public abstract void initVisibilityStrings();

    public final String getVisibilityString(int visibility) {
        return this.visibilityStrings[visibility];
    }

    public void removeYou() {
        super.removeYou();
    }

    public String toString() {
        return "OOGenVisitor[]";
    }
}

