/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.Utility;
import de.uni_paderborn.fujaba.codegen.CodeGenFactory;
import de.uni_paderborn.fujaba.codegen.CodeGenVisitor;
import de.uni_paderborn.fujaba.codegen.OOGenVisitor;
import de.uni_paderborn.fujaba.codegen.OOStatement;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FLinkedList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class OOGenToken {
    private static final transient Logger log;
    public static final transient int FIRST = 0;
    public static final transient int LAST = 1;
    public static final transient int UNUSED = 2;
    public static final transient int FILEHEADER = 3;
    public static final transient int FILEFOOT = 4;
    private static final transient String FIRST_TOKEN_NAME = "FIRSTTOKEN";
    private static final transient String LAST_TOKEN_NAME = "LASTTOKEN";
    private static final transient String GENERATED_TOKEN_NAME = "GENERATEDTOKEN";
    private String sectionName = "";
    private int startRow = -1;
    private int startColumn = -1;
    private transient OOGenToken prev;
    private transient OOGenToken next;
    private ASGElement firstAsgElement;
    private ASGElement lastAsgElement;
    private FLinkedList statement;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.OOGenToken");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public boolean isFirstToken() {
        return this.sectionName.equals(FIRST_TOKEN_NAME);
    }

    public boolean isLastToken() {
        return this.sectionName.equals(LAST_TOKEN_NAME);
    }

    public static final OOGenToken createFirstToken() {
        return new OOGenToken(null, FIRST_TOKEN_NAME);
    }

    public static final OOGenToken createLastToken() {
        return new OOGenToken(null, LAST_TOKEN_NAME);
    }

    public static final OOGenToken createGeneratedToken() {
        return new OOGenToken(null, GENERATED_TOKEN_NAME);
    }

    public OOGenToken() {
    }

    public OOGenToken(OOStatement statement) {
        this.appendStatement(statement);
    }

    public OOGenToken(OOStatement statement, String sectionName) {
        this.appendStatement(statement);
        this.setSectionName(sectionName);
    }

    public static OOGenToken createNewList(OOGenToken prevToken) {
        OOGenToken firstToken = OOGenToken.createFirstToken();
        OOGenToken lastToken = OOGenToken.createLastToken();
        OOGenToken oldNextToken = prevToken != null ? prevToken.getNext() : null;
        firstToken.setNext(lastToken);
        firstToken.setPrev(prevToken);
        lastToken.setNext(oldNextToken);
        return firstToken;
    }

    public static void showStatements(OOGenToken token) {
        while (token != null) {
            token.showStatements();
            token = token.getNext();
        }
    }

    public void showStatements() {
        Iterator iter = this.iteratorOfStatement();
        while (iter.hasNext()) {
            log.error((Object)(this + ".statement." + iter.next()));
        }
    }

    public String getSourceCode() {
        Iterator iter = this.iteratorOfStatement();
        StringBuffer text = new StringBuffer();
        CodeGenVisitor tmpVisitor = CodeGenFactory.get().getCurrentVisitor();
        OOGenVisitor v = null;
        OOStatement currentStatement = null;
        String tmpCode = null;
        if (tmpVisitor instanceof OOGenVisitor) {
            v = (OOGenVisitor)tmpVisitor;
        }
        if (v != null) {
            while (iter.hasNext()) {
                currentStatement = (OOStatement)iter.next();
                tmpCode = currentStatement.getSourceCode(v);
                if (tmpCode == null) continue;
                text.append(tmpCode);
                text.append("\n");
            }
        }
        return text.toString();
    }

    public static String getSourceCodeForTokens(OOGenToken token, OOGenToken stop) {
        StringBuffer buf = new StringBuffer();
        while (token != stop) {
            if (token.getSourceCode() != null && token.getSourceCode().trim().length() != 0) break;
            token = token.getNext();
        }
        while (token != stop) {
            buf.append(token.getSourceCode());
            token = token.getNext();
        }
        return buf.toString();
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public String setSectionName(String sectionName) {
        this.sectionName = sectionName;
        return this.sectionName;
    }

    public String toString(int width) {
        StringBuffer buf = new StringBuffer(width);
        buf.append("|" + this.sectionName + "|");
        if (this.getSourceCode() == null) {
            buf.append(">no text<|");
        } else {
            buf.append(Utility.textToWidth(this.getSourceCode(), width));
            buf.append("|");
        }
        return buf.toString();
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int setStartRow(int startRow) {
        this.startRow = startRow;
        return startRow;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int setStartColumn(int startColumn) {
        this.startColumn = startColumn;
        return startColumn;
    }

    public OOGenToken getPrev() {
        return this.prev;
    }

    public void setPrev(OOGenToken prev) {
        if (this.prev != prev) {
            OOGenToken oldPrev = this.prev;
            if (this.prev != null) {
                this.prev = null;
                oldPrev.setNext(null);
            }
            this.prev = prev;
            if (prev != null) {
                this.prev.setNext(this);
            }
        }
    }

    public OOGenToken getNext() {
        return this.next;
    }

    public void setNext(OOGenToken next) {
        if (this.next != next) {
            OOGenToken oldNext = this.next;
            if (this.next != null) {
                this.next = null;
                oldNext.setPrev(null);
            }
            this.next = next;
            if (next != null) {
                this.next.setPrev(this);
            }
        }
    }

    public boolean setFirstAsgElement(ASGElement value) {
        if (this.firstAsgElement != value) {
            if (this.firstAsgElement != null) {
                ASGElement oldValue = this.firstAsgElement;
                this.firstAsgElement = null;
                oldValue.setFirstOOGenToken(null);
            }
            this.firstAsgElement = value;
            if (value != null) {
                this.firstAsgElement.setFirstOOGenToken(this);
            }
            return true;
        }
        return false;
    }

    public ASGElement getFirstAsgElement() {
        return this.firstAsgElement;
    }

    public boolean setLastAsgElement(ASGElement value) {
        if (this.lastAsgElement != value) {
            if (this.lastAsgElement != null) {
                ASGElement oldValue = this.lastAsgElement;
                this.lastAsgElement = null;
                oldValue.setLastOOGenToken(null);
            }
            this.lastAsgElement = value;
            if (value != null) {
                this.lastAsgElement.setLastOOGenToken(this);
            }
            return true;
        }
        return false;
    }

    public ASGElement getLastAsgElement() {
        return this.lastAsgElement;
    }

    public boolean hasInStatement(OOStatement value) {
        return this.statement != null && value != null && this.statement.contains(value);
    }

    public Iterator iteratorOfStatement() {
        return this.statement == null ? FEmptyIterator.get() : this.statement.iterator();
    }

    public int sizeOfStatement() {
        return this.statement == null ? 0 : this.statement.size();
    }

    public boolean addToStatement(OOStatement value) {
        boolean changed = false;
        if (value != null && !this.hasInStatement(value)) {
            if (this.statement == null) {
                this.statement = new FLinkedList();
            }
            if (changed = this.statement.add(value)) {
                value.setToken(this);
            }
        }
        return changed;
    }

    public boolean prependStatement(OOStatement value) {
        boolean changed = false;
        if (value != null && !this.hasInStatement(value)) {
            if (this.statement == null) {
                this.statement = new FLinkedList();
            }
            this.statement.addFirst(value);
            if (changed) {
                value.setToken(this);
            }
            changed = true;
        }
        return changed;
    }

    public void appendStatement(Object value) {
        if (value instanceof OOStatement) {
            this.appendStatement((OOStatement)value);
        } else if (value instanceof OOStatement[]) {
            this.appendStatement((OOStatement[])value);
        } else if (value instanceof LinkedList) {
            this.appendStatement(OOStatement.toArray((LinkedList)value));
        } else {
            throw new UnsupportedOperationException("value=" + value);
        }
    }

    public void appendStatement(OOStatement[] values) {
        int i = 0;
        while (i < values.length) {
            this.appendStatement(values[i]);
            ++i;
        }
    }

    public boolean appendStatement(OOStatement value) {
        return this.addToStatement(value);
    }

    public boolean removeFromStatement(OOStatement value) {
        boolean changed = false;
        if (this.statement != null && value != null && (changed = this.statement.remove(value))) {
            value.setToken(null);
        }
        return changed;
    }

    public void removeAllFromStatement() {
        Iterator iter = this.iteratorOfStatement();
        while (iter.hasNext()) {
            OOStatement tmpValue = (OOStatement)iter.next();
            this.removeFromStatement(tmpValue);
        }
    }

    public OOStatement getStatementAt(int index) {
        if (index >= 0 && index < this.sizeOfStatement()) {
            return (OOStatement)this.statement.get(index);
        }
        throw new IllegalArgumentException("getStatementAt(" + index + ")");
    }

    public int indexOfStatement(OOStatement elem) {
        return this.statement == null ? -1 : this.statement.indexOf(elem);
    }

    public int lastIndexOfStatement(OOStatement elem) {
        return this.statement == null ? -1 : this.statement.lastIndexOf(elem);
    }

    public Iterator iteratorOfStatement(OOStatement lowerBound) {
        Iterator result = FEmptyIterator.get();
        if (this.statement == null) {
            result = FEmptyIterator.get();
        } else if (this.statement != null && lowerBound != null) {
            int index = this.statement.indexOf(lowerBound) + 1;
            result = this.statement.listIterator(index);
        } else if (this.statement != null && lowerBound == null) {
            result = this.statement.listIterator(0);
        }
        return result;
    }

    public boolean isBeforeOfStatement(OOStatement leftObject, OOStatement rightObject) {
        if (this.statement == null) {
            return false;
        }
        return this.statement.isBefore(leftObject, rightObject);
    }

    public boolean isAfterOfStatement(OOStatement leftObject, OOStatement rightObject) {
        if (this.statement == null) {
            return false;
        }
        return this.statement.isAfter(leftObject, rightObject);
    }

    public OOStatement getFirstOfStatement() {
        if (this.statement == null) {
            return null;
        }
        return (OOStatement)this.statement.getFirst();
    }

    public OOStatement getLastOfStatement() {
        if (this.statement == null) {
            return null;
        }
        return (OOStatement)this.statement.getLast();
    }

    public OOStatement getNextOfStatement(OOStatement object) {
        if (this.statement == null) {
            return null;
        }
        return (OOStatement)this.statement.getNextOf(object);
    }

    public OOStatement getNextIndexOfStatement(OOStatement object, int index) {
        if (this.statement == null) {
            return null;
        }
        return (OOStatement)this.statement.getNextOf(object, index);
    }

    public OOStatement getPreviousOfStatement(OOStatement object) {
        if (this.statement == null) {
            return null;
        }
        return (OOStatement)this.statement.getPreviousOf(object);
    }

    public OOStatement getPreviousIndexOfStatement(OOStatement object, int index) {
        if (this.statement == null) {
            return null;
        }
        return (OOStatement)this.statement.getPreviousOf(object, index);
    }

    public OOGenToken findSection(String sectionName) {
        OOGenToken startToken = this;
        while (!(startToken == null || startToken.getSectionName() != null && startToken.getSectionName().equals(sectionName))) {
            startToken = startToken.getNext();
        }
        return startToken;
    }

    public OOGenToken skipSection(String sectionName, OOGenToken lastToken) {
        OOGenToken currentToken = this;
        OOGenToken nextToken = currentToken.getNext();
        while (nextToken != null && nextToken != lastToken && nextToken.getSectionName().equals(sectionName) && nextToken.getFirstAsgElement() == null) {
            currentToken = nextToken;
            nextToken = currentToken.getNext();
        }
        return currentToken;
    }

    public OOGenToken skipToPrevNextFirstToken(OOGenToken lastToken) {
        OOGenToken currentToken = this;
        OOGenToken nextToken = currentToken.getNext();
        while (nextToken != null && nextToken != lastToken && nextToken.getFirstAsgElement() == null) {
            currentToken = nextToken;
            nextToken = currentToken.getNext();
        }
        return currentToken;
    }

    public void deleteToSection(String sectionName, OOGenToken lastToken) {
        OOGenToken currentToken = this;
        OOGenToken nextToken = currentToken.getNext();
        if (sectionName == null) {
            sectionName = LAST_TOKEN_NAME;
        }
        while (nextToken != null && nextToken != lastToken && !nextToken.getSectionName().equals(sectionName) && nextToken.getFirstAsgElement() == null) {
            nextToken.removeYouFromList();
            nextToken.removeYou();
            nextToken = currentToken.getNext();
        }
    }

    public String newSection(String section, OOGenToken lastToken) {
        this.deleteToSection(section, lastToken);
        return section;
    }

    public String insertTopAndBottomToken(String sectionName) {
        this.append(new OOGenToken(null, String.valueOf(sectionName) + "Top"));
        this.getNext().append(new OOGenToken(null, String.valueOf(sectionName) + "Bottom"));
        return sectionName;
    }

    public OOGenToken getTopToken(String sectionName) {
        if (!this.getNext().getSectionName().equals(String.valueOf(sectionName) + "Top")) {
            throw new RuntimeException("Error generating top token");
        }
        return this.getNext();
    }

    public OOGenToken getBottomToken(String sectionName) {
        if (!this.getNext().getSectionName().equals(String.valueOf(sectionName) + "Bottom")) {
            throw new RuntimeException("Error generating top token");
        }
        return this.getNext();
    }

    public OOGenToken insertNewToken(String sectionName) {
        this.append(new OOGenToken(null, sectionName));
        return this.getNext();
    }

    public OOGenToken getNextOrAppend(String sectionName, OOGenToken lastToken) {
        OOGenToken nextToken = this.getNext();
        if (nextToken == null || nextToken == lastToken || !nextToken.getSectionName().equals(sectionName) || nextToken.getFirstAsgElement() != null) {
            this.append(new OOGenToken(null, sectionName));
        }
        return this.getNext();
    }

    public static void cutAndPaste(OOGenToken firstToken, OOGenToken lastToken, OOGenToken prevToken) {
        OOGenToken oldPrevFirstToken = firstToken.getPrev();
        OOGenToken oldNextLastToken = lastToken.getNext();
        OOGenToken oldNextPrevToken = prevToken != null ? prevToken.getNext() : null;
        if (oldPrevFirstToken != null) {
            oldPrevFirstToken.setNext(oldNextLastToken);
        } else if (oldNextLastToken != null) {
            oldNextLastToken.setPrev(oldPrevFirstToken);
        }
        firstToken.setPrev(prevToken);
        lastToken.setNext(oldNextPrevToken);
    }

    public void append(OOGenToken newToken) {
        if (newToken != null) {
            newToken.setNext(this.getNext());
        }
        this.setNext(newToken);
    }

    public void prepend(OOGenToken newToken) {
        if (newToken != null) {
            newToken.setPrev(this.getPrev());
        }
        this.setPrev(newToken);
    }

    public void removeYouFromList() {
        OOGenToken prev = this.getPrev();
        OOGenToken next = this.getNext();
        if (prev != null) {
            prev.setNext(next);
        } else if (next != null) {
            next.setPrev(prev);
        } else {
            this.setPrev(null);
            this.setNext(null);
        }
    }

    public String toString() {
        return "OOGenToken[" + this.hashCode() + "," + this.sectionName + "]";
    }

    public void removeYou() {
        Iterator iter = this.iteratorOfStatement();
        OOStatement tmpStatement = null;
        while (iter.hasNext()) {
            tmpStatement = (OOStatement)iter.next();
            this.removeFromStatement(tmpStatement);
            tmpStatement.removeYou();
        }
        this.setFirstAsgElement(null);
        this.setLastAsgElement(null);
        this.setNext(null);
        this.setPrev(null);
    }
}

