/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.codegen.CodeGenFactory;
import de.uni_paderborn.fujaba.codegen.CodeGenTargetParserPair;
import de.uni_paderborn.fujaba.codegen.digester.XDigester;
import de.uni_paderborn.fujaba.codegen.digester.rules.FUICallMethodRule;
import de.uni_paderborn.fujaba.codegen.digester.rules.XAddToRule;
import de.uni_paderborn.fujaba.codegen.digester.rules.XSetPropertiesRule;
import de.uni_paderborn.fujaba.codegen.digester.rules.XSetPropertyRule;
import de.uni_paderborn.lib.classloader.UPBClassLoader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class CodeGenTargetParser {
    private static final transient Logger log;
    private static CodeGenTargetParser theInstance;
    private int debugLevel = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.CodeGenTargetParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        theInstance = null;
    }

    private CodeGenTargetParser() {
    }

    public static CodeGenTargetParser get() {
        if (theInstance == null) {
            theInstance = new CodeGenTargetParser();
        }
        return theInstance;
    }

    public void parse(String filename) {
        this.parseFile(filename);
    }

    public void parse(String filename, ClassLoader loader) {
        this.parseFile(filename, loader);
    }

    public boolean parseFile(String filename) {
        return this.parseFile(filename, UPBClassLoader.get());
    }

    public boolean parseFile(String filename, ClassLoader loader) {
        CodeGenTargetParserPair pair = null;
        try {
            pair = this.parsePair(filename, loader);
        }
        catch (Exception exception) {
            return false;
        }
        if (pair != null && pair.isValid()) {
            CodeGenFactory.get().addToCodeGenTarget(pair.getTarget());
            CodeGenFactory.get().addToCodeGenStrategy(pair.getStrategy());
            return true;
        }
        return false;
    }

    protected CodeGenTargetParserPair parsePair(String filename) {
        return this.parsePair(filename, UPBClassLoader.get());
    }

    protected CodeGenTargetParserPair parsePair(String filename, ClassLoader loader) {
        InputStream fis = loader.getResourceAsStream(filename);
        if (fis == null) {
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        CodeGenTargetParserPair result = new CodeGenTargetParserPair();
        XDigester digester = this.createDigester(result);
        digester.setClassLoader(loader);
        try {
            digester.push(result);
            digester.parse(bis);
            bis.close();
        }
        catch (IOException e) {
            log.error((Object)("IOException:" + e));
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            log.error((Object)("SAXException:" + e));
            e.printStackTrace();
            return null;
        }
        digester.pop();
        return result;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debugLevel) {
        if (this.debugLevel != debugLevel) {
            this.debugLevel = debugLevel;
        }
    }

    private XDigester createDigester(CodeGenTargetParserPair pair) {
        XDigester digester = new XDigester();
        digester.push(pair);
        digester.setDebug(this.getDebugLevel());
        digester.setValidating(false);
        digester.addObjectCreate("*/codegentarget", "de.uni_paderborn.fujaba.codegen.CodeGenTarget");
        digester.addSetNext("*/codegentarget", "setTarget", "de.uni_paderborn.fujaba.codegen.CodeGenTarget");
        digester.addObjectCreate("*/codegentargetentry", "de.uni_paderborn.fujaba.codegen.CodeGenTargetEntry");
        digester.addSetNext("*/codegentargetentry", "addToCodeGenTargetEntry", "de.uni_paderborn.fujaba.codegen.CodeGenTargetEntry");
        digester.addRule("*/strategyName", new FUICallMethodRule(digester, "setStrategyName", 0));
        digester.addRule("*/visitorName", new FUICallMethodRule(digester, "setVisitorName", 0));
        digester.addObjectCreate("*/codegenstrategy", "de.uni_paderborn.fujaba.codegen.CodeGenStrategy", "name");
        digester.addSetNext("*/codegenstrategy", "setStrategy", "de.uni_paderborn.fujaba.codegen.CodeGenStrategy");
        digester.addRule("*/name", new FUICallMethodRule(digester, "setName", 0));
        digester.addRule("*/fullName", new FUICallMethodRule(digester, "setFullName", 0));
        digester.addObjectCreate("*/visitor", "de.uni_paderborn.fujaba.codegen.CodeGenVisitor", "name");
        digester.addSetNext("*/visitor", "addToCodeGenVisitor", "de.uni_paderborn.fujaba.codegen.CodeGenVisitor");
        digester.addObjectCreate("*/object", "java.lang.Object", "name");
        digester.addRule("*/object", new XAddToRule(digester, "method", "name"));
        digester.addRule("*/object/mode", new FUICallMethodRule(digester, "setMode", 0, new String[]{"int"}));
        digester.addRule("*/object/continueChain", new FUICallMethodRule(digester, "setContinueChain", 0, new String[]{"boolean"}));
        digester.addRule("*/property", new XSetPropertyRule(digester, "name", "value"));
        digester.addRule("*/properties", new XSetPropertiesRule(digester));
        return digester;
    }

    public String toString() {
        return "CodeGenTargetParser[]";
    }

    public static void main(String[] args) {
        CodeGenTargetParser parser = CodeGenTargetParser.get();
        parser.parse("de/uni_paderborn/fujaba/codegen/javatarget.xml");
        System.exit(0);
    }
}

