/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.codegen.CodeGenFactory;
import de.uni_paderborn.fujaba.codegen.CodeGenFragment;
import de.uni_paderborn.fujaba.codegen.CodeGenFunction;
import de.uni_paderborn.fujaba.codegen.CodeGenStrategyHandler;
import de.uni_paderborn.fujaba.codegen.CodeGenVisitor;
import de.uni_paderborn.fujaba.codegen.EndOfChainOOFunction;
import de.uni_paderborn.fujaba.codegen.EndOfChainOOHandler;
import de.uni_paderborn.fujaba.codegen.OOGenToken;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FFile;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.metamodel.FProject;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FLinkedList;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class CodeGenStrategy {
    private static final transient Logger log;
    private CodeGenFactory currentFactory;
    private CodeGenVisitor currentVisitor;
    private CodeGenFactory codeGenFactory;
    private String name;
    private FHashMap codeGenVisitor;
    private FLinkedList handlerChain;
    private CodeGenFunction function;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.CodeGenStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public CodeGenStrategy() {
        EndOfChainOOHandler endOfChainOOHandler = new EndOfChainOOHandler();
        this.addToHandlerChain(endOfChainOOHandler);
        EndOfChainOOFunction endOfChainFunction = new EndOfChainOOFunction();
        this.setFunction(endOfChainFunction);
    }

    public abstract void generateFProject(FProject var1);

    public final StringBuffer generateFElement(FElement element) {
        return this.generateFElement(element, false);
    }

    public boolean handlerIncrNeedsToken(FElement element) {
        CodeGenStrategyHandler nextHandler = null;
        boolean result = false;
        boolean done = false;
        Iterator iter = this.iteratorOfHandlerChain();
        while (!done && iter.hasNext()) {
            nextHandler = (CodeGenStrategyHandler)iter.next();
            if (!nextHandler.isResponsible(element)) continue;
            result = nextHandler.incrNeedsToken(element);
            done = true;
        }
        return result;
    }

    public final StringBuffer generateFElement(FElement element, boolean save) {
        boolean needsToken = this.handlerIncrNeedsToken(element);
        OOGenToken token = null;
        StringBuffer buf = null;
        CodeGenVisitor visitor = this.getCurrentVisitor();
        visitor.initBuffer();
        if (needsToken) {
            token = new OOGenToken();
        }
        this.generateSourceCodeFor(element, token, new Object[]{save});
        buf = visitor.getCurrentBuffer();
        if (needsToken) {
            while (token != null) {
                if (token.getSourceCode() != null && token.getSourceCode().trim().length() != 0) break;
                token = token.getNext();
            }
            while (token != null) {
                buf.append(token.getSourceCode());
                token = token.getNext();
            }
        }
        buf = new StringBuffer();
        CodeGenFragment fragment = visitor.getFirstFragment();
        while (fragment != null) {
            buf.append(fragment.getSourceCode());
            fragment = fragment.getNextFragment();
        }
        return buf;
    }

    public OOGenToken handlerGenerate(FElement asgElement, OOGenToken prevToken, Object[] param) {
        return this.handlerGenerate((ASGElement)asgElement, prevToken, param);
    }

    public OOGenToken handlerGenerate(ASGElement asgElement, OOGenToken prevToken, Object[] param) {
        Iterator iter = this.iteratorOfHandlerChain();
        boolean done = false;
        OOGenToken result = null;
        while (!done && iter.hasNext()) {
            CodeGenStrategyHandler nextHandler = (CodeGenStrategyHandler)iter.next();
            try {
                if (!nextHandler.isResponsible((FElement)asgElement)) continue;
                prevToken = result = nextHandler.generate(asgElement, prevToken, param, true);
                done = !nextHandler.isContinueChain();
            }
            catch (AbstractMethodError e) {
                log.error((Object)("handler of class " + nextHandler.getClass().getName() + " does not implement new interface!"));
                throw e;
            }
        }
        if (!done) {
            throw new IllegalStateException("incr=" + asgElement + ",prevToken=" + prevToken + ",param=" + param);
        }
        return result;
    }

    public OOGenToken generateSourceCodeFor(FElement incr, OOGenToken prevToken, Object[] param) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ".generateSourceCodeFor(incr=" + incr + ",class=" + (incr != null ? incr.getClass().getName() : "null") + ")"));
        }
        if (incr == null) {
            log.error((Object)"incr is null !", new Throwable());
            return null;
        }
        prevToken = this.handlerGenerate(incr, prevToken, param);
        if (incr.getLastOOGenToken() == null) {
            return prevToken;
        }
        return incr.getLastOOGenToken();
    }

    public OOGenToken generateSourceCodeFor(Iterator iter, OOGenToken current, Object[] param) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ".generateSourceCodeFor(iter=" + iter + ")"));
        }
        while (iter.hasNext()) {
            current = this.generateSourceCodeFor((FElement)iter.next(), current, param);
        }
        return current;
    }

    public OOGenToken generateSourceCodeFor(Enumeration enumeration, OOGenToken current, Object[] param) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ".generateSourceCodeFor(enumeration=" + enumeration + ")"));
        }
        while (enumeration.hasMoreElements()) {
            current = this.generateSourceCodeFor((FElement)enumeration.nextElement(), current, param);
        }
        return current;
    }

    public final Object generateCode(FElement incr, String methodName, Object[] param) {
        CodeGenFunction responsible = CodeGenFunction.findNextResponsible(this.getFunction(), methodName);
        if (responsible != null) {
            return responsible.generate(incr, methodName, param);
        }
        throw new IllegalStateException("methodName=" + methodName + ",param=" + Arrays.asList(param));
    }

    public static OOGenToken checkTokenList(FElement increment, OOGenToken prevToken, OOGenToken firstToken, OOGenToken lastToken) {
        if (firstToken == null) {
            firstToken = OOGenToken.createNewList(prevToken);
            lastToken = firstToken.getNext();
            increment.setFirstOOGenToken(firstToken);
            increment.setLastOOGenToken(lastToken);
        }
        if (firstToken == lastToken || firstToken == null || lastToken == null) {
            throw new RuntimeException("Token list is not correct");
        }
        if (firstToken.getPrev() != prevToken) {
            OOGenToken.cutAndPaste(firstToken, lastToken, prevToken);
        }
        return firstToken;
    }

    public void createFiles(String path, String name) {
        this.getCurrentVisitor().createFiles(path, name);
    }

    public void initVisitor(String path, String name, boolean writeFiles) {
        this.getCurrentVisitor().initVisitor(path, name, writeFiles);
    }

    public void initBuffer() {
        this.getCurrentVisitor().initBuffer();
    }

    public void writeFiles() {
        this.getCurrentVisitor().writeFiles();
    }

    public CodeGenStrategy append(StringBuffer code) {
        this.getCurrentVisitor().append(code);
        return this;
    }

    public CodeGenStrategy append(String code) {
        this.getCurrentVisitor().append(code);
        return this;
    }

    public String createIndentString() {
        return this.getCurrentVisitor().createIndentString();
    }

    public String indentText(String text) {
        return this.getCurrentVisitor().indentText(text);
    }

    public String indentText(StringBuffer text) {
        return this.getCurrentVisitor().indentText(text.toString());
    }

    public StringBuffer getCurrentBuffer() {
        return this.getCurrentVisitor().getCurrentBuffer();
    }

    public String createLineCommentary(String text) {
        return this.getCurrentVisitor().createLineCommentary(text);
    }

    public String createCommentary(String text) {
        return this.getCurrentVisitor().createCommentary(text);
    }

    public String getFilePath(FFile theFile) {
        String theFilePath = GeneralPreferences.get().getExportFolder();
        FPackage thePackage = theFile.getFPackage();
        if (thePackage != null) {
            theFilePath = String.valueOf(theFilePath) + File.separator + thePackage.getPackagePath();
        }
        return theFilePath;
    }

    public String getFileName(FFile theFile) {
        return this.getCurrentVisitor().getFileName(theFile);
    }

    public boolean setCurrentFactory(CodeGenFactory value) {
        if (this.currentFactory != value) {
            if (this.currentFactory != null) {
                CodeGenFactory oldValue = this.currentFactory;
                this.currentFactory = null;
                oldValue.setCurrentStrategy(null);
            }
            this.currentFactory = value;
            if (value != null) {
                this.currentFactory.setCurrentStrategy(this);
            }
            return true;
        }
        return false;
    }

    public CodeGenFactory getCurrentFactory() {
        return this.currentFactory;
    }

    public boolean setCurrentVisitor(CodeGenVisitor value) {
        if (this.currentVisitor != value) {
            if (this.currentVisitor != null) {
                CodeGenVisitor oldValue = this.currentVisitor;
                this.currentVisitor = null;
                oldValue.setCurrentStrategy(null);
            }
            this.currentVisitor = value;
            if (value != null) {
                this.currentVisitor.setCurrentStrategy(this);
            }
            return true;
        }
        return false;
    }

    public CodeGenVisitor getCurrentVisitor() {
        return this.currentVisitor;
    }

    public CodeGenFactory getCodeGenFactory() {
        return this.codeGenFactory;
    }

    public boolean setCodeGenFactory(CodeGenFactory value) {
        boolean changed = false;
        if (this.codeGenFactory != value) {
            if (this.codeGenFactory != null) {
                CodeGenFactory oldValue = this.codeGenFactory;
                this.codeGenFactory = null;
                oldValue.removeFromCodeGenStrategy(this);
            }
            this.codeGenFactory = value;
            if (value != null) {
                value.addToCodeGenStrategy(this);
            }
            changed = true;
        }
        return changed;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name == null && name != null || this.name != null && !this.name.equals(name)) {
            this.name = name;
        }
    }

    public boolean hasInCodeGenVisitor(CodeGenVisitor value) {
        return this.codeGenVisitor != null && value != null && value.getName() != null && this.codeGenVisitor.get(value.getName()) == value;
    }

    public boolean hasKeyInCodeGenVisitor(String key) {
        return this.codeGenVisitor != null && key != null && this.codeGenVisitor.containsKey(key);
    }

    public Iterator iteratorOfCodeGenVisitor() {
        return this.codeGenVisitor == null ? FEmptyIterator.get() : this.codeGenVisitor.values().iterator();
    }

    public Iterator keysOfCodeGenVisitor() {
        return this.codeGenVisitor == null ? FEmptyIterator.get() : this.codeGenVisitor.keySet().iterator();
    }

    public Iterator entriesOfCodeGenVisitor() {
        return this.codeGenVisitor == null ? FEmptyIterator.get() : this.codeGenVisitor.entrySet().iterator();
    }

    public int sizeOfCodeGenVisitor() {
        return this.codeGenVisitor == null ? 0 : this.codeGenVisitor.size();
    }

    public CodeGenVisitor getFromCodeGenVisitor(String key) {
        return this.codeGenVisitor == null || key == null ? null : (CodeGenVisitor)this.codeGenVisitor.get(key);
    }

    public boolean addToCodeGenVisitor(CodeGenVisitor value) {
        boolean changed = false;
        if (value != null && value.getName() != null) {
            CodeGenVisitor oldValue;
            if (this.codeGenVisitor == null) {
                this.codeGenVisitor = new FHashMap();
            }
            if ((oldValue = (CodeGenVisitor)this.codeGenVisitor.put(value.getName(), value)) != value) {
                if (oldValue != null) {
                    oldValue.setCodeGenStrategy(null);
                }
                value.setCodeGenStrategy(this);
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromCodeGenVisitor(CodeGenVisitor value) {
        CodeGenVisitor oldValue;
        boolean changed = false;
        if (this.codeGenVisitor != null && value != null && value.getName() != null && (oldValue = (CodeGenVisitor)this.codeGenVisitor.get(value.getName())) == value) {
            this.codeGenVisitor.remove(value.getName());
            value.setCodeGenStrategy(null);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromCodeGenVisitor(String key) {
        CodeGenVisitor tmpValue;
        boolean changed = false;
        if (this.codeGenVisitor != null && key != null && (tmpValue = (CodeGenVisitor)this.codeGenVisitor.get(key)) != null) {
            this.codeGenVisitor.remove(key);
            tmpValue.setCodeGenStrategy(null);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromCodeGenVisitor() {
        Iterator iter = this.iteratorOfCodeGenVisitor();
        while (iter.hasNext()) {
            CodeGenVisitor tmpValue = (CodeGenVisitor)iter.next();
            this.removeFromCodeGenVisitor(tmpValue);
        }
    }

    public boolean addToBeforeHandlerChain(CodeGenStrategyHandler value, CodeGenStrategyHandler successorHandler) {
        boolean changed = false;
        if (value != null && !this.hasInHandlerChain(value)) {
            if (this.handlerChain == null) {
                this.handlerChain = new FLinkedList();
            }
            int i = this.handlerChain.indexOf(successorHandler);
            this.handlerChain.add(i, (Object)value);
            changed = true;
            if (changed) {
                value.setChainMaster(this);
            }
        }
        return changed;
    }

    public boolean addToHandlerChain(CodeGenStrategyHandler value) {
        boolean changed = false;
        if (value != null && !this.hasInHandlerChain(value)) {
            if (this.handlerChain == null) {
                this.handlerChain = new FLinkedList();
            }
            if (changed = this.handlerChain.add(value)) {
                value.setChainMaster(this);
            }
        }
        return changed;
    }

    public CodeGenStrategyHandler getFirstOfHandlerChain() {
        if (this.handlerChain == null) {
            return null;
        }
        return (CodeGenStrategyHandler)this.handlerChain.getFirst();
    }

    public CodeGenStrategyHandler getHandlerChainAt(int index) {
        if (index >= 0 && index < this.sizeOfHandlerChain()) {
            return (CodeGenStrategyHandler)this.handlerChain.get(index);
        }
        throw new IllegalArgumentException("getHandlerChainAt(" + index + ")");
    }

    public CodeGenStrategyHandler getLastOfHandlerChain() {
        if (this.handlerChain == null) {
            return null;
        }
        return (CodeGenStrategyHandler)this.handlerChain.getLast();
    }

    public CodeGenStrategyHandler getNextIndexOfHandlerChain(CodeGenStrategyHandler object, int index) {
        if (this.handlerChain == null) {
            return null;
        }
        return (CodeGenStrategyHandler)this.handlerChain.getNextOf(object, index);
    }

    public CodeGenStrategyHandler getNextOfHandlerChain(CodeGenStrategyHandler object) {
        if (this.handlerChain == null) {
            return null;
        }
        return (CodeGenStrategyHandler)this.handlerChain.getNextOf(object);
    }

    public CodeGenStrategyHandler getPreviousIndexOfHandlerChain(CodeGenStrategyHandler object, int index) {
        if (this.handlerChain == null) {
            return null;
        }
        return (CodeGenStrategyHandler)this.handlerChain.getPreviousOf(object, index);
    }

    public CodeGenStrategyHandler getPreviousOfHandlerChain(CodeGenStrategyHandler object) {
        if (this.handlerChain == null) {
            return null;
        }
        return (CodeGenStrategyHandler)this.handlerChain.getPreviousOf(object);
    }

    public boolean hasInHandlerChain(CodeGenStrategyHandler value) {
        return this.handlerChain != null && value != null && this.handlerChain.contains(value);
    }

    public int indexOfHandlerChain(CodeGenStrategyHandler elem) {
        return this.handlerChain == null ? -1 : this.handlerChain.indexOf(elem);
    }

    public boolean isAfterOfHandlerChain(CodeGenStrategyHandler leftObject, CodeGenStrategyHandler rightObject) {
        if (this.handlerChain == null) {
            return false;
        }
        return this.handlerChain.isAfter(leftObject, rightObject);
    }

    public boolean isBeforeOfHandlerChain(CodeGenStrategyHandler leftObject, CodeGenStrategyHandler rightObject) {
        if (this.handlerChain == null) {
            return false;
        }
        return this.handlerChain.isBefore(leftObject, rightObject);
    }

    public Iterator iteratorOfHandlerChain() {
        return this.handlerChain == null ? FEmptyIterator.get() : this.handlerChain.iterator();
    }

    public Iterator iteratorOfHandlerChain(CodeGenStrategyHandler lowerBound) {
        Iterator result = FEmptyIterator.get();
        if (this.handlerChain == null) {
            result = FEmptyIterator.get();
        } else if (this.handlerChain != null && lowerBound != null) {
            int index = this.handlerChain.indexOf(lowerBound) + 1;
            result = this.handlerChain.listIterator(index);
        } else if (this.handlerChain != null && lowerBound == null) {
            result = this.handlerChain.listIterator(0);
        }
        return result;
    }

    public int lastIndexOfHandlerChain(CodeGenStrategyHandler elem) {
        return this.handlerChain == null ? -1 : this.handlerChain.lastIndexOf(elem);
    }

    public void removeAllFromHandlerChain() {
        Iterator iter = this.iteratorOfHandlerChain();
        while (iter.hasNext()) {
            CodeGenStrategyHandler tmpValue = (CodeGenStrategyHandler)iter.next();
            this.removeFromHandlerChain(tmpValue);
        }
    }

    public boolean removeFromHandlerChain(CodeGenStrategyHandler value) {
        boolean changed = false;
        if (this.handlerChain != null && value != null && (changed = this.handlerChain.remove(value))) {
            value.setChainMaster(null);
        }
        return changed;
    }

    public int sizeOfHandlerChain() {
        return this.handlerChain == null ? 0 : this.handlerChain.size();
    }

    public void appendHandler(CodeGenStrategyHandler newHandler) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("de.uni_paderborn.fujaba.codegen.EndOfChainOOHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.insertHandler(clazz, newHandler);
    }

    public void insertHandler(Class successorHandlerType, CodeGenStrategyHandler newHandler) {
        if (newHandler == null) {
            throw new IllegalArgumentException("CodeGenStrategy.insertHandler(): argument 'newHandler' is null!");
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("de.uni_paderborn.fujaba.codegen.CodeGenStrategyHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(successorHandlerType)) {
            throw new IllegalArgumentException("CodeGenStrategy.insertHandler(): argument 'successorHandlerType' is of wrong type!");
        }
        CodeGenStrategyHandler successorHandler = null;
        boolean found = false;
        Iterator iter = this.iteratorOfHandlerChain();
        while (!found && iter.hasNext()) {
            successorHandler = (CodeGenStrategyHandler)iter.next();
            found = successorHandlerType.equals(successorHandler.getClass());
        }
        if (found) {
            this.addToBeforeHandlerChain(newHandler, successorHandler);
        }
    }

    public boolean setFunction(CodeGenFunction value) {
        if (this.function != value) {
            if (this.function != null) {
                CodeGenFunction oldValue = this.function;
                this.function = null;
                oldValue.setClient(null);
            }
            this.function = value;
            if (value != null) {
                this.function.setClient(this);
            }
            return true;
        }
        return false;
    }

    public CodeGenFunction getFunction() {
        return this.function;
    }

    public void appendFunction(CodeGenFunction newFunction) {
        if (newFunction == null) {
            throw new IllegalArgumentException("CodeGenFactor.appendFunction(): argument is null!");
        }
        CodeGenFunction endOfChain = this.getFunction();
        while (endOfChain.getSuccessor() != null) {
            endOfChain = endOfChain.getSuccessor();
        }
        CodeGenFunction nextToLastFunction = endOfChain.getPrevFunction();
        if (nextToLastFunction == null) {
            this.setFunction(newFunction);
        } else {
            nextToLastFunction.setSuccessor(newFunction);
        }
        newFunction.setSuccessor(endOfChain);
    }

    public void insertFunction(Class beforeFunction, CodeGenFunction newFunction) {
        if (newFunction == null) {
            throw new IllegalArgumentException("CodeGenFactor.insertFunction(): argument is null!");
        }
        CodeGenFunction insertBefore = this.getFunction();
        while (insertBefore.getSuccessor() != null && !beforeFunction.equals(insertBefore.getClass())) {
            insertBefore = insertBefore.getSuccessor();
        }
        CodeGenFunction prevFunction = insertBefore.getPrevFunction();
        if (prevFunction == null) {
            this.setFunction(newFunction);
        } else {
            prevFunction.setSuccessor(newFunction);
        }
        newFunction.setSuccessor(insertBefore);
    }

    public void removeYou() {
        this.removeAllFromCodeGenVisitor();
        this.removeAllFromHandlerChain();
        CodeGenFactory tmpCodeGenFactory = this.getCodeGenFactory();
        if (tmpCodeGenFactory != null) {
            this.setCodeGenFactory(null);
        }
    }

    public String toString() {
        return "CodeGenStrategy[" + this.getName() + "]";
    }
}

