/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.codegen.CodeGenStrategy;
import de.uni_paderborn.fujaba.codegen.CodeGenTarget;
import de.uni_paderborn.fujaba.codegen.CodeGenTargetEntry;
import de.uni_paderborn.fujaba.codegen.CodeGenTargetParser;
import de.uni_paderborn.fujaba.codegen.CodeGenVisitor;
import de.uni_paderborn.fujaba.codegen.OOGenVisitor;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FProject;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CodeGenFactory {
    private static final transient Logger log;
    public static CodeGenFactory theInstance;
    private CodeGenTarget currentTarget = null;
    private FProject currentFProject;
    private CodeGenStrategy currentStrategy;
    private FHashMap codeGenStrategy;
    private FHashMap codeGenTarget;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.CodeGenFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        theInstance = null;
    }

    private CodeGenFactory() {
    }

    public static CodeGenFactory get() {
        if (theInstance == null) {
            theInstance = new CodeGenFactory();
            theInstance.init();
        }
        return theInstance;
    }

    private void init() {
        boolean success = CodeGenTargetParser.get().parseFile("de/uni_paderborn/fujaba/codegen/javatarget.xml");
        if (success) {
            this.setCurrentTarget("java");
        } else {
            this.setCurrentTarget(null);
            log.error((Object)"parsing de/uni_paderborn/fujaba/codegen/javatarget.xml failed !");
        }
    }

    public void parseTargetFile(String targetFileName) {
        CodeGenTargetParser.get().parseFile(targetFileName);
    }

    public void setCurrentTarget(String name) {
        CodeGenTarget newTarget = this.getFromCodeGenTarget(name);
        if (this.currentTarget != newTarget && newTarget != null) {
            this.currentTarget = newTarget;
            Iterator iter = this.currentTarget.iteratorOfCodeGenTargetEntry();
            CodeGenTargetEntry tmpEntry = (CodeGenTargetEntry)iter.next();
            CodeGenStrategy tmpStrategy = this.getFromCodeGenStrategy(tmpEntry.getStrategyName());
            this.setCurrentStrategy(tmpStrategy);
            tmpStrategy.setCurrentVisitor(tmpStrategy.getFromCodeGenVisitor(tmpEntry.getVisitorName()));
        }
    }

    public CodeGenTarget getCurrentTarget() {
        return this.currentTarget;
    }

    public final StringBuffer generateFElement(FElement element) {
        return this.generateFElement(element, false);
    }

    public final StringBuffer generateFElement(FElement element, boolean save) {
        FElementGeneratorRunnable runnable = new FElementGeneratorRunnable(element, save);
        FujabaChangeManager.executeTransient(runnable);
        return runnable.buffer;
    }

    public void generateFProject() {
        this.generateFProject(UMLProject.get());
    }

    public void generateFProject(final FProject theProject) {
        Runnable runnable = new Runnable(){

            public void run() {
                CodeGenFactory.this.generateFProjectInternal(theProject);
            }
        };
        FujabaChangeManager.executeTransient(runnable);
    }

    void generateFProjectInternal(FProject theProject) {
        Iterator iter = this.currentTarget.iteratorOfCodeGenTargetEntry();
        if (log.isDebugEnabled()) {
            log.debug((Object)("generating code for " + this.currentTarget));
        }
        while (iter.hasNext()) {
            CodeGenTargetEntry tmpEntry = (CodeGenTargetEntry)iter.next();
            String strategyName = tmpEntry.getStrategyName();
            String visitorName = tmpEntry.getVisitorName();
            CodeGenStrategy tmpStrategy = this.getFromCodeGenStrategy(strategyName);
            this.setCurrentStrategy(tmpStrategy);
            CodeGenVisitor tmpVisitor = tmpStrategy.getFromCodeGenVisitor(visitorName);
            tmpStrategy.setCurrentVisitor(tmpVisitor);
            this.setCurrentFProject(theProject);
            this.getCurrentStrategy().generateFProject(theProject);
            this.setCurrentFProject(null);
        }
    }

    public FProject getCurrentFProject() {
        return this.currentFProject != null ? this.currentFProject : UMLProject.get();
    }

    public void setCurrentFProject(FProject currentFProject) {
        if (this.currentFProject != currentFProject) {
            this.currentFProject = currentFProject;
        }
    }

    public boolean setCurrentStrategy(CodeGenStrategy value) {
        if (this.currentStrategy != value) {
            if (this.currentStrategy != null) {
                CodeGenStrategy oldValue = this.currentStrategy;
                this.currentStrategy = null;
                oldValue.setCurrentFactory(null);
            }
            this.currentStrategy = value;
            if (value != null) {
                this.currentStrategy.setCurrentFactory(this);
            }
            return true;
        }
        return false;
    }

    public CodeGenStrategy getCurrentStrategy() {
        return this.currentStrategy;
    }

    public CodeGenVisitor getCurrentVisitor() {
        if (this.getCurrentStrategy() != null) {
            return this.getCurrentStrategy().getCurrentVisitor();
        }
        return null;
    }

    public OOGenVisitor getCurrentOOVisitor() {
        if (this.getCurrentStrategy() != null && this.getCurrentStrategy().getCurrentVisitor() != null && this.getCurrentStrategy().getCurrentVisitor() instanceof OOGenVisitor) {
            return (OOGenVisitor)this.getCurrentStrategy().getCurrentVisitor();
        }
        return null;
    }

    public boolean hasInCodeGenStrategy(CodeGenStrategy value) {
        return this.codeGenStrategy != null && value != null && value.getName() != null && this.codeGenStrategy.get(value.getName()) == value;
    }

    public boolean hasKeyInCodeGenStrategy(String key) {
        return this.codeGenStrategy != null && key != null && this.codeGenStrategy.containsKey(key);
    }

    public Iterator iteratorOfCodeGenStrategy() {
        return this.codeGenStrategy == null ? FEmptyIterator.get() : this.codeGenStrategy.values().iterator();
    }

    public Iterator keysOfCodeGenStrategy() {
        return this.codeGenStrategy == null ? FEmptyIterator.get() : this.codeGenStrategy.keySet().iterator();
    }

    public Iterator entriesOfCodeGenStrategy() {
        return this.codeGenStrategy == null ? FEmptyIterator.get() : this.codeGenStrategy.entrySet().iterator();
    }

    public int sizeOfCodeGenStrategy() {
        return this.codeGenStrategy == null ? 0 : this.codeGenStrategy.size();
    }

    public CodeGenStrategy getFromCodeGenStrategy(String key) {
        return this.codeGenStrategy == null || key == null ? null : (CodeGenStrategy)this.codeGenStrategy.get(key);
    }

    public boolean addToCodeGenStrategy(CodeGenStrategy value) {
        boolean changed = false;
        if (value != null && value.getName() != null) {
            CodeGenStrategy oldValue;
            if (this.codeGenStrategy == null) {
                this.codeGenStrategy = new FHashMap();
            }
            if ((oldValue = (CodeGenStrategy)this.codeGenStrategy.put(value.getName(), value)) != value) {
                if (oldValue != null) {
                    oldValue.setCodeGenFactory(null);
                }
                value.setCodeGenFactory(this);
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromCodeGenStrategy(CodeGenStrategy value) {
        CodeGenStrategy oldValue;
        boolean changed = false;
        if (this.codeGenStrategy != null && value != null && value.getName() != null && (oldValue = (CodeGenStrategy)this.codeGenStrategy.get(value.getName())) == value) {
            this.codeGenStrategy.remove(value.getName());
            value.setCodeGenFactory(null);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromCodeGenStrategy(String key) {
        CodeGenStrategy tmpValue;
        boolean changed = false;
        if (this.codeGenStrategy != null && key != null && (tmpValue = (CodeGenStrategy)this.codeGenStrategy.get(key)) != null) {
            this.codeGenStrategy.remove(key);
            tmpValue.setCodeGenFactory(null);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromCodeGenStrategy() {
        Iterator iter = this.iteratorOfCodeGenStrategy();
        while (iter.hasNext()) {
            CodeGenStrategy tmpValue = (CodeGenStrategy)iter.next();
            this.removeFromCodeGenStrategy(tmpValue);
        }
    }

    public boolean hasInCodeGenTarget(CodeGenTarget value) {
        return this.codeGenTarget != null && value != null && value.getName() != null && this.codeGenTarget.get(value.getName()) == value;
    }

    public boolean hasKeyInCodeGenTarget(String key) {
        return this.codeGenTarget != null && key != null && this.codeGenTarget.containsKey(key);
    }

    public Iterator iteratorOfCodeGenTarget() {
        return this.codeGenTarget == null ? FEmptyIterator.get() : this.codeGenTarget.values().iterator();
    }

    public Iterator keysOfCodeGenTarget() {
        return this.codeGenTarget == null ? FEmptyIterator.get() : this.codeGenTarget.keySet().iterator();
    }

    public Iterator entriesOfCodeGenTarget() {
        return this.codeGenTarget == null ? FEmptyIterator.get() : this.codeGenTarget.entrySet().iterator();
    }

    public int sizeOfCodeGenTarget() {
        return this.codeGenTarget == null ? 0 : this.codeGenTarget.size();
    }

    public CodeGenTarget getFromCodeGenTarget(String key) {
        return this.codeGenTarget == null || key == null ? null : (CodeGenTarget)this.codeGenTarget.get(key);
    }

    public boolean addToCodeGenTarget(CodeGenTarget value) {
        boolean changed = false;
        if (value != null && value.getName() != null) {
            CodeGenTarget oldValue;
            if (this.codeGenTarget == null) {
                this.codeGenTarget = new FHashMap();
            }
            if ((oldValue = (CodeGenTarget)this.codeGenTarget.put(value.getName(), value)) != value) {
                if (oldValue != null) {
                    oldValue.setCodeGenFactory(null);
                }
                value.setCodeGenFactory(this);
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromCodeGenTarget(CodeGenTarget value) {
        CodeGenTarget oldValue;
        boolean changed = false;
        if (this.codeGenTarget != null && value != null && value.getName() != null && (oldValue = (CodeGenTarget)this.codeGenTarget.get(value.getName())) == value) {
            this.codeGenTarget.remove(value.getName());
            value.setCodeGenFactory(null);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromCodeGenTarget(String key) {
        CodeGenTarget tmpValue;
        boolean changed = false;
        if (this.codeGenTarget != null && key != null && (tmpValue = (CodeGenTarget)this.codeGenTarget.get(key)) != null) {
            this.codeGenTarget.remove(key);
            tmpValue.setCodeGenFactory(null);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromCodeGenTarget() {
        Iterator iter = this.iteratorOfCodeGenTarget();
        while (iter.hasNext()) {
            CodeGenTarget tmpValue = (CodeGenTarget)iter.next();
            this.removeFromCodeGenTarget(tmpValue);
        }
    }

    public void removeYou() {
        this.removeAllFromCodeGenStrategy();
        this.removeAllFromCodeGenTarget();
    }

    public String toString() {
        return "CodeGenFactory[]";
    }

    private class FElementGeneratorRunnable
    implements Runnable {
        StringBuffer buffer;
        FElement element;
        boolean save;

        public FElementGeneratorRunnable(FElement element, boolean save) {
            this.element = element;
            this.save = save;
        }

        public void run() {
            CodeGenStrategy strategy = CodeGenFactory.this.getCurrentStrategy();
            this.buffer = strategy.generateFElement(this.element, this.save);
        }
    }
}

