/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.codegen.CGU;
import de.uni_paderborn.fujaba.codegen.OOCallAttrExpr;
import de.uni_paderborn.fujaba.codegen.OOCallMethodExpr;
import de.uni_paderborn.fujaba.codegen.OOClassOfVariableExpr;
import de.uni_paderborn.fujaba.codegen.OOCollectionEnum;
import de.uni_paderborn.fujaba.codegen.OOContainerType;
import de.uni_paderborn.fujaba.codegen.OOExpression;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorGetExpr;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorGotoNextExpr;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorHasNextExpr;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorOfExpr;
import de.uni_paderborn.fujaba.codegen.OOGenVisitor;
import de.uni_paderborn.fujaba.codegen.OOMethod;
import de.uni_paderborn.fujaba.codegen.OOMethodType;
import de.uni_paderborn.fujaba.codegen.OONewArrayExpr;
import de.uni_paderborn.fujaba.codegen.OOObjectOfTypeExpr;
import de.uni_paderborn.fujaba.codegen.OOThrowStatement;
import de.uni_paderborn.fujaba.codegen.OOTypeCastExpr;
import de.uni_paderborn.fujaba.metamodel.FArray;
import de.uni_paderborn.fujaba.metamodel.FBaseTypes;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.metamodel.FType;
import java.util.Iterator;

public abstract class AbstractCPPGenVisitor
extends OOGenVisitor {
    public AbstractCPPGenVisitor(String extender) {
        super(extender);
        this.SDM_ENSURE_STRING = "CppSDM::ensure";
        this.SDM_EXCEPTION_STRING = "CppSDMException";
        this.POINTER_POSTFIX = "*";
        this.INTERFACE_STRING = "";
        this.NULL_STRING = "NULL";
        this.EXTENDS_STRING = ":";
        this.IMPLEMENTS_STRING = "";
        this.INTERRUPTED_EXCEPTION_STRING = "InterruptedException";
        this.ILLEGALDATA_EXCEPTION_STRING = "IllegalDataException";
        this.THIS_STRING = "this->";
        this.FINAL_STRING = "final";
        this.TRANSIENT_STRING = "";
        this.ABSTRACT_STRING = "virtual";
        this.SYNCHRONIZED_STRING = "";
        this.NATIVE_STRING = "native";
    }

    public String getReferenceTemplateName() {
        return "Templates/ReferenceTemplate.CPP.tpl";
    }

    public String getAssocTemplateName() {
        return "Templates/AssocTemplateFCA.CPP.tpl";
    }

    public String getContainerName(OOCollectionEnum containerType, boolean bound) {
        StringBuffer containerName = new StringBuffer();
        containerName.append("std::");
        if (OOCollectionEnum.ITERATOR.equals(containerType)) {
            containerName.append("Iterator");
        }
        if (OOCollectionEnum.LIST_ITERATOR.equals(containerType)) {
            containerName.append("ListIterator");
        }
        if (OOCollectionEnum.KEY_VALUE_PAIR.equals(containerType)) {
            containerName.append("MapEntry");
        }
        if (OOCollectionEnum.LIST.equals(containerType)) {
            containerName.append("list");
        } else if (OOCollectionEnum.HASHTABLE.equals(containerType)) {
            containerName.append("set");
        } else if (OOCollectionEnum.SET.equals(containerType)) {
            containerName.append("set");
        } else if (OOCollectionEnum.MAP.equals(containerType)) {
            containerName.append("map");
        } else if (OOCollectionEnum.MULTI_MAP.equals(containerType)) {
            containerName.append("duplicatedMap");
        } else if (OOCollectionEnum.TREESET.equals(containerType)) {
            containerName.append("set");
        } else if (OOCollectionEnum.SORTED_MAP.equals(containerType)) {
            containerName.append("map");
        } else if (OOCollectionEnum.SORTED_MULTI_MAP.equals(containerType)) {
            containerName.append("duplicatedMap");
        }
        return containerName.toString();
    }

    public void initProgLangTypes() {
        this.addToProgLangTypes("Initializer", "");
        this.addToProgLangTypes("Boolean", "bool");
        this.addToProgLangTypes("Character", "char");
        this.addToProgLangTypes("String", "string");
        this.addToProgLangTypes("Integer", "int");
        this.addToProgLangTypes("Byte", "byte");
        this.addToProgLangTypes("ShortInteger", "short");
        this.addToProgLangTypes("LongInteger", "long");
        this.addToProgLangTypes("Float", "float");
        this.addToProgLangTypes("Double", "double");
        this.addToProgLangTypes("Void", "void");
        this.addToProgLangTypes("constructor", "");
        this.addToProgLangTypes("BooleanArray", "bool[]");
        this.addToProgLangTypes("CharacterArray", "char[]");
        this.addToProgLangTypes("StringArray", "string[]");
        this.addToProgLangTypes("IntegerArray", "int[]");
        this.addToProgLangTypes("ByteArray", "byte[]");
        this.addToProgLangTypes("ShortIntegerArray", "short[]");
        this.addToProgLangTypes("LongIntegerArray", "long[]");
        this.addToProgLangTypes("FloatArray", "float[]");
        this.addToProgLangTypes("DoubleArray", "double[]");
        this.addToProgLangTypes("ObjectArray", "Object[]");
        this.addToProgLangTypes("FWIterator", "iterator");
    }

    public void initVisibilityStrings() {
        this.visibilityStrings = new String[]{"private", "public", "protected", "/*package*/", "/*user*/"};
    }

    public String getMethodName(OOMethod methodName) {
        String name = methodName.getName();
        StringBuffer result = new StringBuffer();
        if (methodName.getType() == OOMethodType.DEFAULT_METHOD) {
            if (methodName == OOMethod.STRING_COMPARE_METHOD) {
                return "strcmp";
            }
            return methodName.getName();
        }
        if (methodName.getType() == OOMethodType.GET_METHOD) {
            result.append("get");
        } else if (methodName.getType() == OOMethodType.IS_METHOD) {
            result.append("is");
        } else if (methodName.getType() == OOMethodType.SET_METHOD) {
            result.append("set");
        } else if (methodName.getType() == OOMethodType.HAS_IN_METHOD) {
            result.append("hasIn");
        } else if (methodName.getType() == OOMethodType.ELEMENTS_OF_METHOD) {
            result.append("elementsOf");
        } else if (methodName.getType() == OOMethodType.ITERATOR_OF_METHOD) {
            if (!"".equals(name)) {
                result.append("iteratorOf");
            } else {
                result.append("iterator");
            }
        } else {
            if (methodName.getType() == OOMethodType.OLD_STYLE_ELEMENTS) {
                result.append(name);
                result.append("Elements");
                return result.toString();
            }
            if (methodName.getType() == OOMethodType.REMOVE_YOU_METHOD) {
                return "removeYou";
            }
            if (methodName.getType() == OOMethodType.ADD_METHOD) {
                if (!"".equals(name)) {
                    result.append("addTo");
                } else {
                    result.append("add");
                }
            } else if (methodName.getType() == OOMethodType.REMOVE_METHOD) {
                if (!"".equals(name)) {
                    result.append("removeFrom");
                } else {
                    result.append("remove");
                }
            } else if (methodName.getType() == OOMethodType.GET_FROM_METHOD) {
                result.append("getFrom");
            } else if (methodName.getType() == OOMethodType.SIZE_OF_METHOD) {
                result.append("sizeOf");
            } else if (methodName.getType() == OOMethodType.REMOVE_ALL_FROM_METHOD) {
                result.append("removeAllFrom");
            } else if (methodName.getType() == OOMethodType.INDEX_OF_METHOD) {
                result.append("indexOf");
            } else if (methodName.getType() == OOMethodType.LAST_INDEX_OF_METHOD) {
                result.append("lastIndexOf");
            } else if (methodName.getType() == OOMethodType.IS_BEFORE_OF_METHOD) {
                result.append("isBeforeOf");
            } else if (methodName.getType() == OOMethodType.IS_AFTER_OF_METHOD) {
                result.append("isAfterOf");
            } else if (methodName.getType() == OOMethodType.GET_FIRST_OF_METHOD) {
                result.append("getFirstOf");
            } else if (methodName.getType() == OOMethodType.GET_LAST_OF_METHOD) {
                result.append("getLastOf");
            } else if (methodName.getType() == OOMethodType.GET_NEXT_OF_METHOD) {
                result.append("getNextOf");
            } else if (methodName.getType() == OOMethodType.GET_NEXT_INDEX_OF_METHOD) {
                result.append("getNextIndexOf");
            } else if (methodName.getType() == OOMethodType.GET_PREVIOUS_OF_METHOD) {
                result.append("getPreviousOf");
            } else if (methodName.getType() == OOMethodType.GET_PREVIOUS_INDEX_OF_METHOD) {
                result.append("getPreviousIndexOf");
            } else if (methodName.getType() == OOMethodType.ADD_BEFORE_OF_METHOD) {
                result.append("addBeforeOf");
            } else if (methodName.getType() == OOMethodType.ADD_AFTER_OF_METHOD) {
                result.append("addAfterOf");
            } else if (methodName.getType() == OOMethodType.GET_VALUE_FROM_METHOD) {
                result.append("getValueFrom");
            } else if (methodName.getType() == OOMethodType.GET_KEY_FROM_METHOD) {
                result.append("getKeyFrom");
            } else if (methodName.getType() == OOMethodType.HAS_VALUE_IN_METHOD) {
                result.append("hasValueIn");
            } else if (methodName.getType() == OOMethodType.HAS_KEY_IN_METHOD) {
                result.append("hasKeyIn");
            } else if (methodName.getType() == OOMethodType.HAS_ENTRY_IN_METHOD) {
                result.append("hasEntryIn");
            } else if (methodName.getType() == OOMethodType.KEYS_OF_METHOD) {
                result.append("keysOf");
            } else if (methodName.getType() == OOMethodType.REMOVE_VALUE_FROM_METHOD) {
                result.append("removeValueFrom");
            } else if (methodName.getType() == OOMethodType.REMOVE_KEY_FROM_METHOD) {
                result.append("removeKeyFrom");
            } else if (methodName.getType() == OOMethodType.REMOVE_ENTRY_FROM_METHOD) {
                result.append("removeEntryFrom");
            } else if (methodName.getType() == OOMethodType.ENTRIES_OF_METHOD) {
                result.append("entriesOf");
            } else {
                if (methodName.getType() == OOMethodType.GET_AT_METHOD) {
                    result.append("get").append(CGU.upFirstChar(name)).append("At");
                    return result.toString();
                }
                if (methodName.getType() == OOMethodType.IS_EMPTY_METHOD) {
                    result.append("is" + CGU.upFirstChar(name) + "Empty");
                    return result.toString();
                }
                if (methodName.getType() == OOMethodType.EQUALS_METHOD) {
                    return this.EQUALS_METHOD_STRING;
                }
                if (methodName.getType() == OOMethodType.ADD_TO_SET_METHOD) {
                    return this.ADD_TO_SET_METHOD_STRING;
                }
                if (methodName.getType() == OOMethodType.SET_CONTAINS_METHOD) {
                    return this.SET_CONTAINS_METHOD_STRING;
                }
            }
        }
        result.append(CGU.upFirstChar(name));
        return result.toString();
    }

    public final String getSourceCode(OOThrowStatement statement) {
        StringBuffer result = new StringBuffer();
        result.append(this.createIndentString());
        result.append("throw ");
        result.append(statement.getMyException().getSourceCode(this));
        return result.toString();
    }

    public String getSourceCode(OOTypeCastExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append("dynamic_cast<");
        result.append(this.getOOTypeAsString(expression.getTypeName()));
        if (this.getFromProgLangTypes(this.getOOTypeAsString(expression.getTypeName())) == null) {
            result.append("*");
        }
        result.append(">");
        result.append(" ( ");
        result.append(expression.getCastSource().getSourceCode(this));
        result.append(" ) ");
        return result.toString();
    }

    public String getSourceCode(OOObjectOfTypeExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append("dynamic_cast<");
        result.append(this.getOOTypeAsString(expression.getTypeName()));
        if (this.getFromProgLangTypes(this.getOOTypeAsString(expression.getTypeName())) == null) {
            result.append("*");
        }
        result.append(">(");
        result.append(this.getVarName(expression.getObjectName()));
        result.append(")");
        return result.toString();
    }

    public final String getSourceCode(OOClassOfVariableExpr expression) {
        return this + ".getSourceCode(" + expression + ") is empty !";
    }

    public final String getSourceCode(OOFWIteratorOfExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append(this.getVarName(expression.getObjectName()));
        result.append(".begin ()");
        return result.toString();
    }

    public final String getSourceCode(OOFWIteratorGetExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append("*");
        result.append(this.getVarName(expression.getObjectName()));
        return result.toString();
    }

    public String getSourceCode(OONewArrayExpr expression) {
        StringBuffer result = new StringBuffer();
        Iterator iter = expression.iteratorOfParameter();
        result.append("new ");
        result.append(this.getOOTypeAsString(expression.getElementType()));
        result.append("[");
        if (!iter.hasNext()) {
            result.append(expression.getSizeExpr().getSourceCode(this));
        }
        result.append("] ");
        if (iter.hasNext()) {
            result.append("{");
            while (iter.hasNext()) {
                OOExpression tmpParameter = (OOExpression)iter.next();
                result.append(tmpParameter.getSourceCode(this));
                if (!iter.hasNext()) continue;
                result.append(", ");
            }
            result.append("}");
        }
        return result.toString();
    }

    public final String getSourceCode(OOFWIteratorHasNextExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append(this.getVarName(expression.getIterName()));
        result.append(" != ");
        if (expression.isUseAccessMethod()) {
            if (expression.getObjectName() != null) {
                result.append(this.getVarName(expression.getObjectName()));
                result.append("->");
            }
            result.append("end");
            result.append(CGU.upFirstChar(this.getMethodName(new OOMethod(this.getOOTypeAsString(expression.getElemType()), OOMethodType.ITERATOR_OF_METHOD))));
            result.append(" ()");
        } else {
            result.append(String.valueOf(CGU.downFirstChar(this.getVarName(expression.getObjectName()))) + "->end ()");
        }
        return result.toString();
    }

    public final String getSourceCode(OOFWIteratorGotoNextExpr expression) {
        return String.valueOf(this.getVarName(expression.getIterName())) + "++";
    }

    public String getSourceCode(OOCallAttrExpr expression) {
        StringBuffer result = new StringBuffer();
        if (expression.getObjectName() != null && this.getVarName(expression.getObjectName()) != null) {
            result.append(this.getVarName(expression.getObjectName()));
            result.append("->");
        }
        if (expression.getAttrName() != null && this.getVarName(expression.getAttrName()) != null) {
            result.append(this.getVarName(expression.getAttrName()));
        } else {
            result.append(" /* oops, no attr name */ ");
        }
        if (expression.getNextCall() != null) {
            result.append("->");
            result.append(expression.getNextCall().getSourceCode(this));
        }
        return result.toString();
    }

    public String getSourceCode(OOCallMethodExpr expression) {
        StringBuffer result = new StringBuffer();
        if (expression.getObjectName() != null && this.getVarName(expression.getObjectName()) != null) {
            result.append(this.getVarName(expression.getObjectName()));
            if (!this.getMethodName(expression.getMethodName()).equals(this.EQUALS_METHOD_STRING)) {
                result.append("->");
            }
        }
        if (this.getMethodName(expression.getMethodName()).equals(this.EQUALS_METHOD_STRING)) {
            result.append(" == ");
        }
        if (!this.getMethodName(expression.getMethodName()).equals(this.EQUALS_METHOD_STRING)) {
            result.append(this.getMethodName(expression.getMethodName()));
            result.append(" ");
            result.append(this.OPEN_NORM_BRACKET);
        }
        Iterator iter = expression.iteratorOfParameter();
        OOExpression tmpParameter = null;
        while (iter.hasNext()) {
            tmpParameter = (OOExpression)iter.next();
            result.append(tmpParameter.getSourceCode(this));
            if (!iter.hasNext()) continue;
            result.append(this.LIST_SEPARATOR);
            result.append(" ");
        }
        if (!this.getMethodName(expression.getMethodName()).equals(this.EQUALS_METHOD_STRING)) {
            result.append(this.CLOSE_NORM_BRACKET);
            if (expression.getNextCall() != null) {
                if (!this.getMethodName(((OOCallMethodExpr)expression.getNextCall()).getMethodName()).equals(this.EQUALS_METHOD_STRING)) {
                    result.append("->");
                }
                result.append(expression.getNextCall().getSourceCode(this));
            }
        }
        return result.toString();
    }

    public String getTypeAsString(FType theType, boolean isPointer) {
        String typeString = null;
        if (theType instanceof FBaseTypes) {
            typeString = this.getProgLangType((FBaseTypes)theType);
        } else if (theType instanceof FArray) {
            typeString = String.valueOf(this.getTypeAsString(((FArray)theType).getFArrayType(), false)) + "[]";
        } else {
            if (theType instanceof FClass) {
                FClass theClass = (FClass)theType;
                typeString = theClass.getName();
                theClass = theClass.getFDeclaredInClass();
                while (theClass != null) {
                    typeString = String.valueOf(theClass.getName()) + "->" + typeString;
                    theClass = theClass.getFDeclaredInClass();
                }
            } else {
                typeString = theType.getName();
            }
            if (isPointer) {
                typeString = String.valueOf(typeString) + this.POINTER_POSTFIX;
            }
        }
        return typeString;
    }

    public String getOOTypeAsString(OOContainerType theType, boolean isBound) {
        StringBuffer result = new StringBuffer();
        if (theType.getCollectionType() != null) {
            result.append(this.getTypeNameAsString(this.getContainerName(theType.getCollectionType())));
            result.append("<");
            int length = theType.getParameter().length;
            int i = 0;
            while (i < length) {
                result.append(this.getOOTypeAsString(theType.getParameter()[i]));
                if (i + 1 < length) {
                    result.append(",");
                }
                ++i;
            }
            result.append(">");
        }
        return result.toString();
    }

    public String generateImportPackage(FPackage thePackage) {
        return "";
    }

    public String generateImportClass(FClass theClass) {
        return "";
    }

    public void removeYou() {
        super.removeYou();
    }

    public String toString() {
        return "AbstractGenVisitor[]";
    }
}

