/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import de.uni_paderborn.fujaba.basic.TemplateFile;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import java.util.Iterator;

public class TemplateManager {
    private static TemplateManager manager;
    private FHashMap templates;

    public static void set(TemplateManager manager) {
        TemplateManager.manager = manager;
    }

    public static TemplateManager get() {
        if (manager == null) {
            manager = new TemplateManager();
        }
        return manager;
    }

    public boolean hasInTemplates(TemplateFile obj) {
        return this.templates != null && obj != null && obj.getFilename() != null && this.templates.get(obj.getFilename()) == obj;
    }

    public boolean hasKeyInTemplates(String key) {
        return this.templates != null && key != null && this.templates.containsKey(key);
    }

    public Iterator iteratorOfTemplates() {
        return this.templates == null ? FEmptyIterator.get() : this.templates.values().iterator();
    }

    public Iterator keysOfTemplates() {
        return this.templates == null ? FEmptyIterator.get() : this.templates.keySet().iterator();
    }

    public Iterator entriesOfTemplates() {
        return this.templates == null ? FEmptyIterator.get() : this.templates.entrySet().iterator();
    }

    public int sizeOfTemplates() {
        return this.templates == null ? 0 : this.templates.size();
    }

    public TemplateFile getFromTemplates(String key) {
        return this.templates == null || key == null ? null : (TemplateFile)this.templates.get(key);
    }

    public boolean addToTemplates(TemplateFile obj) {
        boolean changed = false;
        if (obj != null && obj.getFilename() != null) {
            TemplateFile oldValue;
            if (this.templates == null) {
                this.templates = new FHashMap();
            }
            if ((oldValue = (TemplateFile)this.templates.put(obj.getFilename(), obj)) != obj) {
                if (oldValue != null) {
                    oldValue.setManager(null);
                }
                obj.setManager(this);
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromTemplates(TemplateFile obj) {
        TemplateFile oldValue;
        boolean changed = false;
        if (this.templates != null && obj != null && obj.getFilename() != null && (oldValue = (TemplateFile)this.templates.get(obj.getFilename())) == obj) {
            this.templates.remove(obj.getFilename());
            obj.setManager(null);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromTemplates(String key) {
        TemplateFile tmpObj;
        boolean changed = false;
        if (this.templates != null && key != null && (tmpObj = (TemplateFile)this.templates.get(key)) != null) {
            this.templates.remove(key);
            tmpObj.setManager(null);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromTemplates() {
        Iterator iter = this.iteratorOfTemplates();
        while (iter.hasNext()) {
            TemplateFile tmpObj = (TemplateFile)iter.next();
            this.removeFromTemplates(tmpObj);
        }
    }

    public TemplateFile getTemplate(String filename) {
        TemplateFile template;
        if (this.hasKeyInTemplates(filename)) {
            template = this.getFromTemplates(filename);
            if (template.isModified()) {
                template.parse();
            }
        } else {
            template = new TemplateFile(filename);
            template.parse();
            this.addToTemplates(template);
        }
        return template;
    }

    public void resetTemplates() {
        this.removeAllFromTemplates();
        this.templates = null;
    }
}

