/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import de.uni_paderborn.fujaba.basic.PlaceHolderToken;
import de.uni_paderborn.fujaba.basic.SourceCodeToken;
import de.uni_paderborn.fujaba.basic.TemplateFile;
import de.uni_paderborn.fujaba.basic.TemplateToken;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FLinkedList;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class TemplateCodeBlock {
    private static final transient Logger log;
    private String name = "";
    private TemplateFile template;
    private FLinkedList tokens;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.basic.TemplateCodeBlock");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public TemplateCodeBlock(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        if (this.name == null || !this.name.equals(name)) {
            this.name = name;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean setTemplate(TemplateFile obj) {
        boolean changed = false;
        if (this.template != obj) {
            if (this.template != null) {
                TemplateFile oldValue = this.template;
                this.template = null;
                oldValue.removeFromCodeBlocks(this);
            }
            this.template = obj;
            if (obj != null) {
                obj.addToCodeBlocks(this);
            }
            changed = true;
        }
        return changed;
    }

    public TemplateFile getTemplate() {
        return this.template;
    }

    public boolean hasInTokens(TemplateToken obj) {
        return this.tokens != null && obj != null && this.tokens.contains(obj);
    }

    public Iterator iteratorOfTokens() {
        return this.tokens == null ? FEmptyIterator.get() : this.tokens.iterator();
    }

    public int sizeOfTokens() {
        return this.tokens == null ? 0 : this.tokens.size();
    }

    public boolean addToTokens(TemplateToken obj) {
        boolean changed = false;
        if (obj != null && !this.hasInTokens(obj)) {
            if (this.tokens == null) {
                this.tokens = new FLinkedList();
            }
            this.tokens.add(obj);
            obj.setCodeBlock(this);
            changed = true;
        }
        return changed;
    }

    public boolean removeFromTokens(TemplateToken obj) {
        boolean changed = false;
        if (this.tokens != null && obj != null) {
            changed = this.tokens.remove(obj);
            obj.setCodeBlock(null);
        }
        return changed;
    }

    public void removeAllFromTokens() {
        Iterator iter = this.iteratorOfTokens();
        while (iter.hasNext()) {
            TemplateToken tmpObj = (TemplateToken)iter.next();
            this.removeFromTokens(tmpObj);
        }
        this.tokens = null;
    }

    protected void parse(BufferedReader in) {
        boolean endBlockReached = false;
        try {
            String line;
            while ((line = in.readLine()) != null && !endBlockReached) {
                String str = line.trim();
                if (str != null && !str.equals("") && str.charAt(0) == '#' && str.startsWith("EndCodeBlock", 1)) {
                    endBlockReached = true;
                }
                if (endBlockReached) continue;
                this.processLine(line, in);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error during parsing a template block.");
        }
    }

    protected void processLine(String line, BufferedReader in) {
        String code;
        int startCodeIndex = 0;
        int endCodeIndex = line.length();
        int indexBeginPH = line.indexOf(36, startCodeIndex);
        int indexEndPH = line.indexOf(36, indexBeginPH + 1);
        boolean placeholderFound = false;
        while (indexBeginPH > -1) {
            placeholderFound = true;
            code = line.substring(startCodeIndex, indexBeginPH);
            this.addCodeToken(code);
            String placeholder = line.substring(indexBeginPH, indexEndPH + 1);
            this.addPlaceholderToken(placeholder);
            startCodeIndex = indexEndPH + 1;
            indexBeginPH = line.indexOf(36, startCodeIndex);
            indexEndPH = line.indexOf(36, indexBeginPH + 1);
        }
        if (startCodeIndex < endCodeIndex) {
            code = String.valueOf(line.substring(startCodeIndex, endCodeIndex)) + "\n";
            this.addCodeToken(code);
        } else if (placeholderFound) {
            code = "\n";
            this.addCodeToken(code);
        }
    }

    protected void addCodeToken(String code) {
        SourceCodeToken codeToken = new SourceCodeToken(code);
        this.addToTokens(codeToken);
    }

    protected void addPlaceholderToken(String placeholder) {
        PlaceHolderToken placeholderToken = new PlaceHolderToken(placeholder);
        this.addToTokens(placeholderToken);
    }

    public String getSourceCode(FHashMap parameter) {
        StringBuffer codeBuffer = new StringBuffer();
        Iterator iter = this.iteratorOfTokens();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof TemplateToken) {
                TemplateToken token = (TemplateToken)next;
                codeBuffer.append(token.getSourceCode(parameter));
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Token type: " + (next == null ? "null" : next.getClass().getName())));
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Token text: " + next));
        }
        return codeBuffer.toString();
    }

    public Iterator getSourceCodeLines(FHashMap parameter) {
        String lineSeparator = System.getProperty("line.separator");
        ArrayList<CharSequence> list = new ArrayList<CharSequence>();
        StringBuffer codeBuffer = new StringBuffer();
        Iterator iter = this.iteratorOfTokens();
        while (iter.hasNext()) {
            TemplateToken token = (TemplateToken)iter.next();
            String sourceCode = token.getSourceCode(parameter);
            codeBuffer.append(sourceCode);
            if (!sourceCode.endsWith(lineSeparator)) continue;
            list.add(codeBuffer);
            codeBuffer = new StringBuffer();
        }
        if (codeBuffer.length() != 0) {
            list.add(codeBuffer.toString());
        }
        return list.iterator();
    }
}

