/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.action.ExportFilesAction;
import de.uni_paderborn.fujaba.basic.CommandLineParser;
import de.uni_paderborn.fujaba.basic.ProcessEvent;
import de.uni_paderborn.fujaba.basic.ProcessListener;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.upb.tools.fca.FTreeSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;

public class ProcessOutputViewer
extends JInternalFrame {
    private static final transient Logger log;
    private static final String[] states;
    String exitText = "Exit";
    JTextArea normalOutput = new JTextArea();
    JButton exit = new JButton(this.exitText);
    private JButton execute = new JButton("Execute");
    private JButton recompile = new JButton("Again");
    private JButton clearHistory = new JButton("Clear History");
    private JButton clearDisplay = new JButton("Clear Display");
    private JLabel processCommandLabel = new JLabel("Command: ");
    JComboBox commandLineBox = new JComboBox();
    private JLabel processStateLabel = new JLabel("State: " + states[0]);
    private static final int maxProcessStates = 4;
    private int curProcessState = 0;
    private FTreeSet processListeners = new FTreeSet();
    private StreamPoller normalOutputPoller = null;
    private StreamPoller errorOutputPoller = null;
    Process process = null;
    private ActionListener exitAction = null;
    JPanel advancedPanel;
    private Map environment = this.getenv();
    public boolean calledByCompileAction;
    Collection listeners;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.basic.ProcessOutputViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        states = new String[]{"waiting...", "starting...", "running...", "finished"};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getenv() {
        HashMap<String, String> env = new HashMap<String, String>();
        LineNumberReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader("/proc/self/environ"));
            try {
                String[] lines = reader.readLine().split("\u0000");
                int i = 0;
                while (i < lines.length) {
                    String line = lines[i];
                    int n = line.indexOf(61);
                    env.put(line.substring(0, n), line.substring(n + 1));
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var7_14 = null;
                try {}
                catch (IOException iOException) {
                    return env;
                }
                reader.close();
                return env;
            }
        }
        catch (Exception e) {
            try {
                Process process = Runtime.getRuntime().exec("env");
                reader = new LineNumberReader(new InputStreamReader(process.getInputStream()));
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        return env;
                    }
                    int n = line.indexOf(61);
                    env.put(line.substring(0, n), line.substring(n + 1));
                }
            }
            catch (Exception e1) {
                return env;
            }
        }
    }

    String[] convertEnvironment(Map properties) {
        String[] environment = new String[properties.size()];
        int i = 0;
        Iterator it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            environment[i++] = entry.getKey() + "=" + entry.getValue();
        }
        return environment;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public ProcessOutputViewer() {
        this(false, true);
    }

    public ProcessOutputViewer(boolean calledByCompileAction, boolean show) {
        this.calledByCompileAction = calledByCompileAction;
        this.setTitle("Process Output Viewer");
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                ProcessOutputViewer.this.stopThreads();
                ProcessOutputViewer.this.dispose();
            }
        });
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout(20, 10));
        JPanel exitPanel = new JPanel(new BorderLayout(5, 5));
        exitPanel.add((Component)this.processStateLabel, "West");
        this.exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessOutputViewer.this.exitButtonPressed();
                if (ProcessOutputViewer.this.getExitAction() != null && ProcessOutputViewer.this.exit.getText().equals(ProcessOutputViewer.this.exitText)) {
                    ProcessOutputViewer.this.getExitAction().actionPerformed(e);
                }
            }
        });
        this.execute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessOutputViewer.this.executeButtonPressed();
            }
        });
        this.recompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessOutputViewer.this.recompileButtonPressed();
            }
        });
        this.clearHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessOutputViewer.this.commandLineBox.removeAllItems();
            }
        });
        this.clearDisplay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessOutputViewer.this.normalOutput.setText(null);
                if (ProcessOutputViewer.this.listeners != null) {
                    Iterator iter = ProcessOutputViewer.this.listeners.iterator();
                    while (iter.hasNext()) {
                        OutputListener listener = (OutputListener)iter.next();
                        listener.outputCleared();
                    }
                }
            }
        });
        JButton advanced = new JButton("more...");
        advanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessOutputViewer.this.advancedPanel.setVisible(!ProcessOutputViewer.this.advancedPanel.isVisible());
            }
        });
        Vector history = GeneralPreferences.get().getProcessHistory();
        if (history != null) {
            Iterator iter = history.iterator();
            while (iter.hasNext()) {
                this.commandLineBox.addItem(iter.next());
            }
        }
        JPanel advancedButtonPanel = new JPanel(new FlowLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        advancedButtonPanel.add(this.clearDisplay);
        advancedButtonPanel.add(this.clearHistory);
        advancedButtonPanel.add(this.execute);
        buttonPanel.add(this.recompile);
        buttonPanel.add(advanced);
        buttonPanel.add(this.exit);
        exitPanel.add((Component)advancedButtonPanel, "East");
        exitPanel.add((Component)new JSeparator(), "South");
        this.advancedPanel = new JPanel(new BorderLayout(5, 5));
        this.advancedPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel commandPanel = new JPanel(new BorderLayout());
        commandPanel.add((Component)this.processCommandLabel, "West");
        commandPanel.add((Component)this.commandLineBox, "Center");
        this.advancedPanel.add((Component)commandPanel, "North");
        this.advancedPanel.add((Component)exitPanel, "South");
        this.advancedPanel.setVisible(false);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)this.advancedPanel, "South");
        southPanel.add((Component)buttonPanel, "Center");
        container.add((Component)southPanel, "South");
        Font nonPropFont = new Font("Courier", 0, 12);
        JPanel tmpPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(22, 32);
        this.normalOutput = new AutoScrollTextArea(scrollPane);
        this.normalOutput.setFont(nonPropFont);
        this.normalOutput.setEditable(false);
        this.normalOutput.setWrapStyleWord(true);
        scrollPane.getViewport().add(this.normalOutput);
        tmpPanel.add((Component)scrollPane, "Center");
        container.add((Component)tmpPanel, "Center");
        this.getContentPane().add(container);
        this.resetProcessState();
        if (show) {
            FrameMain.get().getDesktop().add(this);
        }
        if (this.getParent() != null) {
            Dimension size = new Dimension(Math.min(Math.max((int)this.getPreferredSize().getWidth(), 500), this.getParent().getWidth()), Math.min(Math.max((int)this.getPreferredSize().getHeight(), 400), this.getParent().getHeight()));
            this.setSize(size);
            this.setLocation(this.getParent().getWidth() - this.getWidth(), this.getParent().getHeight() - this.getHeight());
        }
    }

    public void setMouseListener(MouseListener mouseListener) {
        if (mouseListener != null) {
            this.normalOutput.addMouseListener(mouseListener);
        }
    }

    public void switchProcessState() {
        this.curProcessState = (this.curProcessState + 1) % 4;
        this.processStateLabel.setText("state: " + states[this.curProcessState]);
        if (this.curProcessState == 1) {
            this.exit.setText("Abort");
            this.execute.setEnabled(false);
            this.recompile.setEnabled(false);
            this.clearHistory.setEnabled(false);
            this.clearDisplay.setEnabled(false);
            this.commandLineBox.setEnabled(false);
        }
        if (this.curProcessState == 3) {
            this.exit.setText(this.exitText);
            this.execute.setEnabled(true);
            this.recompile.setEnabled(true);
            this.clearHistory.setEnabled(true);
            this.clearDisplay.setEnabled(true);
            this.commandLineBox.setEnabled(true);
            this.commandLineBox.setEditable(true);
        }
    }

    public void resetProcessState() {
        this.curProcessState = 3;
        this.normalOutput.setText("");
        this.exit.setText(this.exitText);
        this.execute.setEnabled(true);
        this.recompile.setEnabled(true);
        this.clearHistory.setEnabled(true);
        this.commandLineBox.setEnabled(true);
        this.commandLineBox.setEditable(true);
        this.processStateLabel.setText("state: " + states[this.curProcessState]);
    }

    public void setExitAction(ActionListener act) {
        this.exitAction = act;
        this.exitText = act != null ? "Continue" : "Exit";
        this.exit.setText(this.exitText);
    }

    public ActionListener getExitAction() {
        return this.exitAction;
    }

    String getCommandLine() {
        return (String)this.commandLineBox.getSelectedItem();
    }

    private void setCommandLine(String commandLine) {
        boolean contains = false;
        commandLine = commandLine.trim();
        int i = 0;
        while (i < this.commandLineBox.getItemCount()) {
            if (commandLine.equals(this.commandLineBox.getItemAt(i))) {
                contains = true;
                this.commandLineBox.setSelectedItem(commandLine);
            }
            ++i;
        }
        if (!contains) {
            this.commandLineBox.addItem(commandLine);
            this.commandLineBox.setSelectedItem(commandLine);
        }
    }

    void notifyAllProcessListeners(ProcessEvent event) {
        Iterator iter = this.processListeners.iterator();
        while (iter.hasNext()) {
            ProcessListener tmpListener = (ProcessListener)iter.next();
            tmpListener.processFinished(event);
        }
    }

    public void addProcessListener(ProcessListener newListener) {
        this.processListeners.add(newListener);
    }

    public void executeCommand(String commandLine) {
        String commandName = commandLine;
        if (commandName != null) {
            int indexOfSeperator;
            int indexOfSpace = commandName.indexOf(32);
            if (indexOfSpace > 0) {
                commandName = commandName.substring(0, indexOfSpace);
            }
            if ((indexOfSeperator = commandName.indexOf(File.separatorChar)) > 0 && indexOfSeperator < commandName.length() - 1) {
                commandName = commandName.substring(indexOfSeperator + 1);
            }
            if (commandName.length() > 25) {
                commandName = String.valueOf(commandName.substring(0, 22)) + "...";
            }
        }
        this.executeCommand(commandLine, commandName);
    }

    public void executeCommand(String commandLine, String title) {
        if (!this.isShowing()) {
            this.setVisible(true);
            this.setTitle(title);
        }
        this.quietExecuteCommand(commandLine);
    }

    public void quietExecuteCommand(String commandLine) {
        if (this.process != null | commandLine == null) {
            return;
        }
        this.switchProcessState();
        this.setCommandLine(commandLine);
        this.switchProcessState();
        MyThread processThread = new MyThread(this);
        processThread.start();
    }

    public boolean compileAndWaitForResult(String cmdLine) {
        try {
            CommandLineParser parser = new CommandLineParser(cmdLine);
            cmdLine = parser.getCommandLine();
            log.info((Object)("Going to invoke: " + cmdLine));
            this.process = Runtime.getRuntime().exec(cmdLine, this.convertEnvironment(this.getEnvironment()));
            this.startThreads();
            this.process.waitFor();
            this.dispose();
            if (this.listeners != null) {
                Iterator iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    OutputListener listener = (OutputListener)iter.next();
                    listener.outputFinished(this.getOutput(), this.process.exitValue());
                }
            }
            return this.process.exitValue() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isRunning() {
        return this.curProcessState != 3;
    }

    public String getOutput() {
        return this.normalOutput.getText();
    }

    void startThreads() {
        if (this.process == null || this.normalOutputPoller != null || this.errorOutputPoller != null) {
            return;
        }
        this.normalOutputPoller = new StreamPoller(this.process.getInputStream(), this.normalOutput);
        this.errorOutputPoller = new StreamPoller(this.process.getErrorStream(), this.normalOutput);
        new Thread(this.normalOutputPoller).start();
        new Thread(this.errorOutputPoller).start();
    }

    void stopThreads() {
        if (this.normalOutputPoller != null) {
            this.normalOutputPoller.stop();
        }
        if (this.errorOutputPoller != null) {
            if (!this.isShowing()) {
                this.setVisible(true);
            }
            this.errorOutputPoller.stop();
        }
        this.normalOutputPoller = null;
        this.errorOutputPoller = null;
    }

    public void exitButtonPressed() {
        if (this.exit.getText().equals("Abort")) {
            this.process.destroy();
        } else {
            this.stopThreads();
            GeneralPreferences option = GeneralPreferences.get();
            Vector history = new Vector();
            int i = 0;
            while (i < this.commandLineBox.getItemCount()) {
                history.add(this.commandLineBox.getItemAt(i));
                ++i;
            }
            option.setProcessHistory(history);
            this.dispose();
        }
    }

    public void executeButtonPressed() {
        this.process = null;
        this.executeCommand(this.getCommandLine());
    }

    public void recompileButtonPressed() {
        this.normalOutput.setText(null);
        if (this.isAutoContinueEnabled()) {
            ExportFilesAction myexport = new ExportFilesAction();
            myexport.actionPerformed(null);
        }
        this.executeButtonPressed();
    }

    public boolean isAutoContinueEnabled() {
        return this.calledByCompileAction;
    }

    public static void main(String[] argv) {
        ProcessOutputViewer pv = new ProcessOutputViewer();
        pv.setCommandLine("java de.uni_paderborn.fujaba.app.FujabaApp");
        pv.show();
    }

    public void addOutputListener(OutputListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(listener);
    }

    public void removeOutputListener(OutputListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    class MyThread
    extends Thread {
        private JInternalFrame frame;

        public MyThread(JInternalFrame aframe) {
            this.frame = aframe;
        }

        public void run() {
            try {
                ProcessOutputViewer.this.switchProcessState();
                GeneralPreferences options = GeneralPreferences.get();
                if (options.isCommandLineParsing()) {
                    CommandLineParser myParser = new CommandLineParser(ProcessOutputViewer.this.getCommandLine());
                    ProcessOutputViewer.this.process = Runtime.getRuntime().exec(myParser.getCommandLine(), ProcessOutputViewer.this.convertEnvironment(ProcessOutputViewer.this.getEnvironment()));
                } else {
                    ProcessOutputViewer.this.process = Runtime.getRuntime().exec(ProcessOutputViewer.this.getCommandLine(), ProcessOutputViewer.this.convertEnvironment(ProcessOutputViewer.this.getEnvironment()));
                }
                ProcessOutputViewer.this.startThreads();
                ProcessOutputViewer.this.process.waitFor();
                ProcessOutputViewer.this.notifyAllProcessListeners(new ProcessEvent(ProcessOutputViewer.this.process.exitValue()));
                MyThread.sleep(1000L);
                ProcessOutputViewer.this.stopThreads();
                ProcessOutputViewer.this.switchProcessState();
                if (ProcessOutputViewer.this.listeners != null) {
                    Iterator iter = ProcessOutputViewer.this.listeners.iterator();
                    while (iter.hasNext()) {
                        OutputListener listener = (OutputListener)iter.next();
                        listener.outputFinished(ProcessOutputViewer.this.getOutput(), ProcessOutputViewer.this.process.exitValue());
                    }
                }
                if (ProcessOutputViewer.this.process.exitValue() == 0 && ProcessOutputViewer.this.calledByCompileAction && ProcessOutputViewer.this.getExitAction() != null) {
                    ProcessOutputViewer.this.normalOutput.append("Project compiled successfully!\n\nPlease be patient while starting Dobs.\n\n");
                    ProcessOutputViewer.this.exitButtonPressed();
                    ProcessOutputViewer.this.getExitAction().actionPerformed(null);
                } else {
                    ProcessOutputViewer.this.normalOutput.append("Process exit code = " + ProcessOutputViewer.this.process.exitValue() + "\n\n");
                }
                ProcessOutputViewer.this.process = null;
            }
            catch (Exception except) {
                if (!this.frame.isShowing()) {
                    this.frame.setVisible(true);
                }
                except.printStackTrace();
                JOptionPane.showMessageDialog(ProcessOutputViewer.this, "Error occurred starting process: " + except.toString(), "Process", 0);
                ProcessOutputViewer.this.stopThreads();
                ProcessOutputViewer.this.resetProcessState();
            }
        }
    }

    public static interface OutputListener {
        public void outputCleared();

        public void outputAppended(String var1);

        public void outputFinished(String var1, int var2);
    }

    class StreamPoller
    implements Runnable {
        private InputStreamReader in = null;
        private JTextArea out = null;
        private boolean stopped = false;

        public StreamPoller(InputStream in, JTextArea out) {
            this.in = new InputStreamReader(in);
            this.out = out;
        }

        public synchronized void stop() {
            this.stopped = true;
        }

        public void run() {
            StringBuffer buf = new StringBuffer();
            try {
                while (!this.stopped) {
                    char[] errorText = new char[4000];
                    int len = this.in.read(errorText, 0, 4000);
                    if (len > 0) {
                        String text = new String(errorText, 0, len);
                        this.out.append(text);
                        buf.append(text);
                    } else if (len < 0) {
                        return;
                    }
                    int index = buf.indexOf("\n");
                    while (index > 0) {
                        String newLine = buf.substring(0, index);
                        buf.delete(0, index + 1);
                        index = buf.indexOf("\n");
                        if (ProcessOutputViewer.this.listeners == null) continue;
                        Iterator iter = ProcessOutputViewer.this.listeners.iterator();
                        while (iter.hasNext()) {
                            OutputListener listener = (OutputListener)iter.next();
                            listener.outputAppended(newLine);
                        }
                    }
                }
            }
            catch (IOException except) {
                except.printStackTrace();
            }
        }
    }

    class AutoScrollTextArea
    extends JTextArea {
        private JScrollPane scrollPane;

        public AutoScrollTextArea(JScrollPane scrollPane) {
            this.scrollPane = scrollPane;
        }

        public void append(String str) {
            super.append(str);
            JScrollBar a = this.scrollPane.getVerticalScrollBar();
            a.setValue(a.getMaximum());
        }
    }
}

