/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListenerHelper;
import de.uni_paderborn.fujaba.metamodel.FDiagramItem;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.uni_paderborn.fujaba.uml.UMLTransitionGuard;
import de.upb.tools.fca.FLinkedList;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class IncrSelector {
    private static final transient Logger log;
    private FLinkedList lastSelected = null;
    private static IncrSelector selector;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.basic.IncrSelector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        selector = new IncrSelector();
    }

    public void selectIncrByID(String incrID) {
        UMLProject project = UMLProject.get();
        FrameMain.get().setCursorWait();
        try {
            if (incrID != null) {
                ASGElement incr = project.searchID(incrID);
                this.gotoElement(incr);
            }
            UMLProject.get().refreshDisplay();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FrameMain.get().setCursorDefault();
    }

    public void gotoElement(ASGElement element) {
        try {
            this.removeLastSelected();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error((Object)"Cannot deselect increment.");
        }
        if (element != null) {
            if (element instanceof UMLTransitionGuard) {
                element = ((UMLTransitionGuard)element).getRevGuard();
            }
            ASGDiagram diagram = null;
            FElement diagElement = element;
            while (diagElement != null && diagram == null) {
                if (diagElement instanceof ASGDiagram) {
                    diagram = (ASGDiagram)diagElement;
                } else if (diagElement instanceof FDiagramItem) {
                    FDiagramItem item = (FDiagramItem)diagElement;
                    diagram = (ASGDiagram)item.getFFirstFromDiagrams();
                }
                diagElement = diagElement.getParentElement();
            }
            if (diagram instanceof UMLStoryPattern) {
                UMLStoryActivity storyAct = ((UMLStoryPattern)diagram).getRevStoryPattern();
                if (element == diagram) {
                    element = storyAct;
                }
                diagram = storyAct.getFirstFromDiagrams();
            }
            if (diagram != null) {
                FrameMain.get().selectTreeItem(diagram);
                FrameMain.get().showDiagram(diagram);
            }
            this.lastSelected = new FLinkedList();
            Iterator iter = element.iteratorOfFsaObjects();
            JComponent comp = null;
            while (iter.hasNext()) {
                FSAObject fsaObject = (FSAObject)iter.next();
                comp = fsaObject.getJComponent();
                this.lastSelected.add(comp);
                SelectionListenerHelper.setSelected(comp, true);
                if (!element.getFSAInterface().getMainFsaName().equals(fsaObject.getPropertyName())) continue;
                comp.scrollRectToVisible(new Rectangle(0, 0, comp.getWidth(), comp.getHeight()));
            }
        }
    }

    private IncrSelector() {
    }

    public static IncrSelector get() {
        return selector;
    }

    private void removeLastSelected() {
        if (this.getLastSelected() != null) {
            Iterator iter = this.getLastSelected().iterator();
            while (iter.hasNext()) {
                JComponent comp = (JComponent)iter.next();
                SelectionListenerHelper.setSelected(comp, false);
            }
        }
        this.setLastSelected(null);
    }

    public void setLastSelected(FLinkedList lastSelected) {
        this.lastSelected = lastSelected;
    }

    public FLinkedList getLastSelected() {
        return this.lastSelected;
    }
}

