/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import de.uni_paderborn.fujaba.app.action.OpenRecentProjectAction;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import de.upb.lib.userinterface.UserInterfaceManager;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;

public class FileHistory {
    private static final transient Logger log;
    private Vector fileVector = new Vector();
    private static FileHistory singleton;
    private static String FILE_HISTORY;
    private static String FILE_HISTORY_KEY;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.basic.FileHistory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        FILE_HISTORY = "FileHistory";
        FILE_HISTORY_KEY = "core/FileHistory.properties";
    }

    public FileHistory() {
        this.loadHistoryFromProperties();
    }

    public static FileHistory get() {
        if (singleton == null) {
            singleton = new FileHistory();
        }
        return singleton;
    }

    public synchronized boolean addToHistory(File file) {
        if (file.exists() && !this.isInHistory(file)) {
            try {
                File newFile = new File(file.getCanonicalPath());
                this.fileVector.insertElementAt(newFile, 0);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isInHistory(File file) {
        int i = 0;
        while (i < this.fileVector.size()) {
            File fileVFile = (File)this.fileVector.elementAt(i);
            try {
                if (file.getCanonicalPath().equals(fileVFile.getCanonicalPath())) {
                    return true;
                }
            }
            catch (Exception e) {
                log.error((Object)"FileHistory.isInHistory: getCanonicalPath throws:");
                e.printStackTrace();
            }
            ++i;
        }
        return false;
    }

    public File firstOfHistory() {
        if (this.fileVector.size() > 0) {
            return (File)this.fileVector.get(0);
        }
        return null;
    }

    public synchronized void loadHistoryFromProperties() {
        PreferencesProperties props = PreferencesProperties.get(FILE_HISTORY_KEY);
        Vector fileNameVector = props.getVectorSetting(FILE_HISTORY);
        this.fileVector = new Vector();
        int i = 0;
        while (i < fileNameVector.size()) {
            File newFile = new File((String)fileNameVector.elementAt(i));
            this.fileVector.add(newFile);
            ++i;
        }
    }

    public synchronized void saveHistoryToProperties() {
        PreferencesProperties props = PreferencesProperties.get(FILE_HISTORY_KEY);
        Vector<String> fileNameVector = new Vector<String>();
        try {
            int i = 0;
            while (i < Math.min(9, this.fileVector.size())) {
                File file = (File)this.fileVector.elementAt(i);
                fileNameVector.add(file.getCanonicalPath());
                ++i;
            }
            props.putSetting(FILE_HISTORY, fileNameVector);
            props.save();
        }
        catch (Exception e) {
            log.error((Object)"FileHistory.saveHistoryToProperties: getCanonicalPath() throws");
            e.printStackTrace();
        }
    }

    public synchronized void updateActions() {
        UserInterfaceManager uiManager = UserInterfaceManager.get();
        int i = 0;
        AbstractAction action = uiManager.getFromActions("fileHistory" + i);
        while (action != null) {
            if (action instanceof OpenRecentProjectAction) {
                OpenRecentProjectAction oRPAction = (OpenRecentProjectAction)action;
                if (i < this.fileVector.size()) {
                    File file = (File)this.fileVector.elementAt(i);
                    oRPAction.setFile(file);
                } else {
                    oRPAction.setFile(null);
                }
            } else {
                log.error((Object)"FileHistory.updateActions: \nOnly OpenRecentProjectAction actions should have an id beginnig with fileHistory!");
            }
            action = uiManager.getFromActions("fileHistory" + ++i);
        }
    }

    public synchronized void removeNotExistingFiles() {
        int i = 0;
        while (i < this.fileVector.size()) {
            File file = (File)this.fileVector.elementAt(i);
            if (!file.exists()) {
                this.fileVector.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }
}

