/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app.action;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.basic.RuntimeExceptionWithContext;
import de.uni_paderborn.fujaba.codegen.CodeGenException;
import de.uni_paderborn.fujaba.codegen.CodeGenFactory;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.messages.ErrorMessage;
import de.uni_paderborn.fujaba.messages.MessageView;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.preferences.CodeGenPreferences;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ExportFilesAction
extends AbstractAction {
    private static final transient Logger log;
    private boolean success = false;
    public static final String MESSAGE_CLASS_EXPORT = "Export";
    private transient boolean askIfFilesShouldBeDeleted = false;
    private transient FrameMain frameMain = null;
    private transient String expPath = null;
    private transient boolean foundJava = false;
    private transient int choice = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.action.ExportFilesAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public void actionPerformed(final ActionEvent e) {
        MessageView messageView = FrameMain.get().getMessageView();
        messageView.deleteMessages(MESSAGE_CLASS_EXPORT);
        messageView.deleteMessages("Compiler error");
        messageView.deleteMessages("Compiler warning");
        Runnable runnable = new Runnable(){

            public void run() {
                ExportFilesAction.this.exportFiles(e);
            }
        };
        FujabaChangeManager.executeTransient(runnable);
    }

    public boolean exportFiles(ActionEvent e) {
        boolean askIfFilesShouldBeDeleted = e != null && !"./generated".equals(this.expPath);
        FPackage pkg = e != null && e.getSource() instanceof FPackage ? (FPackage)e.getSource() : null;
        return this.exportFiles(e != null, askIfFilesShouldBeDeleted, pkg);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exportFiles(boolean deleteExistingFiles, boolean askIfFilesShouldBeDeleted, FPackage pkg) {
        FrameMain frameMain = FrameMain.get();
        String expPath = GeneralPreferences.get().getExportFolder();
        String tmpTarget = CodeGenFactory.get().getCurrentTarget().getName();
        boolean exceptionOccured = false;
        try {
            try {
                if (deleteExistingFiles && !this.clearExportDirectory(expPath, askIfFilesShouldBeDeleted)) {
                    Object var14_8 = null;
                    CodeGenFactory.get().setCurrentTarget(tmpTarget);
                    UMLProject.get().refreshDisplay();
                    frameMain.setCursorDefault();
                    return false;
                }
                frameMain.setCursorWait();
                this.success = false;
                Map target = CodeGenPreferences.get().getSelectedCodeGenTargetNames();
                Iterator iter = target.keySet().iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        this.success = true;
                        frameMain.setStatusLabel("Java code created successfully!");
                    }
                    String key = (String)iter.next();
                    Boolean bool = (Boolean)target.get(key);
                    if (!bool.booleanValue()) continue;
                    CodeGenFactory.get().setCurrentTarget(key);
                    long time = System.currentTimeMillis();
                    if (pkg != null) {
                        CodeGenFactory.get().generateFElement(pkg);
                    } else {
                        CodeGenFactory.get().generateFProject();
                    }
                    time = System.currentTimeMillis() - time;
                    frameMain.setStatusLabel("Source for target " + key + " generated in " + (double)time / 1000.0 + "s.");
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof CodeGenException) || log.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                FrameMain.get().getMessageView().deleteMessages(MESSAGE_CLASS_EXPORT);
                this.showErrorMessageForException(ex);
                exceptionOccured = true;
            }
        }
        catch (Throwable throwable) {
            Object var14_9 = null;
            CodeGenFactory.get().setCurrentTarget(tmpTarget);
            UMLProject.get().refreshDisplay();
            frameMain.setCursorDefault();
            throw throwable;
        }
        {
            Object var14_10 = null;
            CodeGenFactory.get().setCurrentTarget(tmpTarget);
            UMLProject.get().refreshDisplay();
            frameMain.setCursorDefault();
            if (!exceptionOccured) {
                FrameMain.get().getMessageView().deleteMessages(MESSAGE_CLASS_EXPORT);
            }
            return this.success;
        }
    }

    private void showErrorMessageForException(Exception ex) {
        if (ex instanceof CodeGenException) {
            Iterator it = ((CodeGenException)ex).iteratorOfExceptions();
            while (it.hasNext()) {
                Exception exception = (Exception)it.next();
                this.showErrorMessageForException(exception);
            }
        } else {
            ex.printStackTrace();
            ErrorMessage errorMessage = new ErrorMessage();
            errorMessage.setThrowable(ex);
            if (ex instanceof RuntimeExceptionWithContext) {
                errorMessage.setText(ex.getMessage());
            } else {
                errorMessage.setText(ex.toString());
            }
            Throwable t = ex;
            while (t != null) {
                if (t instanceof RuntimeExceptionWithContext) {
                    RuntimeExceptionWithContext sdmException = (RuntimeExceptionWithContext)t;
                    errorMessage.addToContext(sdmException.getContext());
                }
                t = t.getCause();
            }
            errorMessage.setMessageCategory(MESSAGE_CLASS_EXPORT);
            FrameMain.get().getMessageView().addToMessages(errorMessage);
            FrameMain.get().showMessageView();
        }
    }

    private boolean clearExportDirectory(String expPath, boolean askIfFilesShouldBeDeleted) {
        this.frameMain = FrameMain.get();
        File currDir = new File(expPath);
        this.askIfFilesShouldBeDeleted = askIfFilesShouldBeDeleted;
        this.expPath = expPath;
        this.foundJava = false;
        this.choice = 0;
        this.success = true;
        File[] files = currDir.listFiles();
        if (files == null) {
            int answer;
            int n = answer = askIfFilesShouldBeDeleted ? JOptionPane.showConfirmDialog(FrameMain.get(), "The export directory (" + currDir.getAbsolutePath() + ") does not exist - create it?", MESSAGE_CLASS_EXPORT, 0) : 0;
            if (answer != 0) {
                return false;
            }
            currDir.mkdirs();
            return true;
        }
        boolean success = this.deleteFileOrDirectory(currDir, false);
        return success;
    }

    private boolean deleteFileOrDirectory(File f, boolean includingParam) {
        if (f.isDirectory()) {
            File[] fileList = f.listFiles();
            int i = 0;
            while (fileList != null && i < fileList.length) {
                this.deleteFileOrDirectory(fileList[i], true);
                if (this.foundJava && (!this.success || this.choice != 0)) {
                    return this.success;
                }
                ++i;
            }
        }
        if (includingParam && (f.getName().endsWith(".java") || f.getName().endsWith(".class") || f.getName().endsWith(".dlr") || f.getName().endsWith(".tmp"))) {
            if (this.askIfFilesShouldBeDeleted && !this.foundJava) {
                this.choice = JOptionPane.showConfirmDialog(this.frameMain, "There are already .java, .class or .dlr files in directory \n" + this.expPath + ". \n It is recommend to remove" + " all of these files to avoid problems while compiling the project. \n\n Do" + " you want to remove all .java, .class and .dlr files ?", "Export Java - Warning", 1, 2);
                this.foundJava = true;
            }
            if (this.askIfFilesShouldBeDeleted && this.choice == 2) {
                this.success = false;
                return this.success;
            }
            if (!this.askIfFilesShouldBeDeleted || this.choice == 0) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("deleting file: " + f));
                }
                f.delete();
            }
        }
        return this.success;
    }
}

