/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app.action;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.action.CompileAction;
import de.uni_paderborn.fujaba.basic.IncrSelector;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class CompileRunMouseListener
extends MouseAdapter {
    private static final transient Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.action.CompileRunMouseListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void mouseClicked(MouseEvent event) {
        JTextArea normalOutput = (JTextArea)event.getSource();
        int pos = normalOutput.getCaret().getDot();
        String line = "";
        int off = -1;
        try {
            off = normalOutput.getLineOfOffset(pos);
        }
        catch (BadLocationException e) {
            log.error((Object)"Error in CaretListener");
            return;
        }
        boolean done = false;
        while (off >= 0 && !done) {
            StringTokenizer st;
            try {
                int start = normalOutput.getLineStartOffset(off);
                int end = normalOutput.getLineEndOffset(off);
                line = normalOutput.getText(start, end - start).trim();
            }
            catch (BadLocationException e) {
                log.error((Object)"Error in CaretListener");
                return;
            }
            if (line.startsWith("at ")) {
                line = line.substring(line.lastIndexOf("(") + 1, line.indexOf(")"));
            }
            if ((st = new StringTokenizer(line, ":")).countTokens() >= 1) {
                String file = st.nextToken();
                if (file.length() == 1 && st.countTokens() > 1) {
                    file = String.valueOf(file) + ":" + st.nextToken();
                }
                try {
                    String error;
                    String lineNrSt = st.nextToken(" :");
                    if (st.hasMoreTokens()) {
                        error = st.nextToken().trim();
                    } else {
                        do {
                            try {
                                int start = normalOutput.getLineStartOffset(--off);
                                int end = normalOutput.getLineEndOffset(off);
                                line = normalOutput.getText(start, end - start).trim();
                            }
                            catch (BadLocationException e) {
                                log.error((Object)"Error in CaretListener");
                            }
                        } while (line.startsWith("at "));
                        error = line;
                    }
                    if (file.endsWith(".java")) {
                        try {
                            int lineNr = Integer.parseInt(lineNrSt);
                            String id = CompileAction.getIncrementIdForGeneratedCodeLine(file, lineNr);
                            IncrSelector.get().selectIncrByID(id);
                            FrameMain.get().setStatusLabel("Error: " + error);
                            done = true;
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            --off;
        }
    }
}

