/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.uni_paderborn.lib.classloader.UPBClassLoader;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Version {
    static final transient Logger log;
    private int major = 1;
    private int minor = 0;
    private int revision = 0;
    private int build = 0;
    private String release = "";
    private static volatile Version instance;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.Version");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    private Version() {
        try {
            VersionParser parser = new VersionParser();
            parser.parse("version.xml");
        }
        catch (Exception ex) {
            log.error((Object)"Could not parse version.xml.");
            ex.printStackTrace();
        }
    }

    public static Version get() {
        if (instance == null) {
            instance = new Version();
        }
        return instance;
    }

    public String toString() {
        return String.valueOf(this.getVersion()) + " " + this.release + "  Build " + this.build;
    }

    public String getVersion() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.revision;
    }

    public int getBuild() {
        return this.build;
    }

    void setBuild(int build) {
        this.build = build;
    }

    public int getMajor() {
        return this.major;
    }

    void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    void setMinor(int minor) {
        this.minor = minor;
    }

    public int getRevision() {
        return this.revision;
    }

    void setRevision(int revision) {
        this.revision = revision;
    }

    public String getRelease() {
        return this.release;
    }

    void setRelease(String release) {
        this.release = release;
    }

    class VersionParser
    extends DefaultHandler {
        private static final String VERSION_SYSTEM_ID = "http://www.upb.de/cs/fujaba/DTDs/Version.dtd";
        private static final String VERSION_SYSTEM_ID2 = "http://www.fujaba.de/DTDs/Version.dtd";
        private static final String VERSION_PUBLIC_ID = "-//Fujaba//Fujaba Plugin Definition//EN//1.0";
        private static final String VERSION_DTD_RESOURCE = "DTDs/Version.dtd";
        public static final String VERSION = "Version";
        public static final String MAJOR = "Major";
        public static final String MINOR = "Minor";
        public static final String REVISION = "Revision";
        public static final String BUILD = "Build";
        public static final String RELEASE = "Release";
        private static final int VERSION_STATE = 0;
        private static final int MAJOR_STATE = 1;
        private static final int MINOR_STATE = 2;
        private static final int REVISION_STATE = 3;
        private static final int BUILD_STATE = 4;
        private static final int RELEASE_STATE = 5;
        private URL versionDTD;
        private int state = -1;

        VersionParser() {
        }

        public void parse(String xmlFile) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(true);
                factory.setNamespaceAware(true);
                XMLReader xmlReader = factory.newSAXParser().getXMLReader();
                xmlReader.setContentHandler(this);
                xmlReader.setErrorHandler(this);
                xmlReader.setEntityResolver(this);
                URL url = UPBClassLoader.get().getResource(xmlFile);
                xmlReader.parse(new InputSource(url.toString()));
            }
            catch (SAXParseException e) {
                log.error((Object)("Parse error in line " + e.getLineNumber() + "\n" + e.getMessage()));
                e.printStackTrace();
            }
            catch (SAXException e) {
                log.error((Object)("SAXException:\n" + e.getMessage()));
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                log.error((Object)("ParserConfigurationException:\n" + e.getMessage()));
                e.printStackTrace();
            }
            catch (IOException e) {
                log.error((Object)("File " + xmlFile + " can not be opened:\n" + e.getMessage()));
                e.printStackTrace();
            }
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (VERSION_PUBLIC_ID.equals(publicId) || VERSION_SYSTEM_ID.equals(systemId) || VERSION_SYSTEM_ID2.equals(systemId)) {
                if (this.versionDTD == null) {
                    this.versionDTD = UPBClassLoader.get().getResource(VERSION_DTD_RESOURCE);
                }
                if (this.versionDTD != null) {
                    try {
                        return new InputSource(this.versionDTD.openStream());
                    }
                    catch (Exception e) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Could not solve SYSTEM or PUBLIC reference for DTD.");
                        }
                        throw new SAXException(e);
                    }
                }
            }
            InputSource result = null;
            try {
                result = super.resolveEntity(publicId, systemId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }

        public void startElement(String uri, String name, String qName, Attributes atts) {
            try {
                if (qName.equals(VERSION)) {
                    this.state = 0;
                } else if (qName.equals(MAJOR)) {
                    this.state = 1;
                } else if (qName.equals(MINOR)) {
                    this.state = 2;
                } else if (qName.equals(REVISION)) {
                    this.state = 3;
                } else if (qName.equals(BUILD)) {
                    this.state = 4;
                } else if (qName.equals(RELEASE)) {
                    this.state = 5;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void characters(char[] ch, int start, int length) {
            try {
                String data = new String(ch, start, length);
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        Version.this.setMajor(new Integer(data));
                        break;
                    }
                    case 2: {
                        Version.this.setMinor(new Integer(data));
                        break;
                    }
                    case 3: {
                        Version.this.setRevision(new Integer(data));
                        break;
                    }
                    case 4: {
                        Version.this.setBuild(new Integer(data));
                        break;
                    }
                    case 5: {
                        Version.this.setRelease(data);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void endElement(String uri, String name, String qName) {
            this.state = -1;
        }
    }
}

