/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class RemoveFragmentFromProject {
    private static final transient Logger log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.RemoveFragmentFromProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public final StringTokenizer createLineTokenizer(String line) {
        StringTokenizer st = new StringTokenizer(line, ";");
        st.nextToken();
        return st;
    }

    public boolean writeFile(String filename, StringBuffer content) {
        File tmpFile = new File(filename);
        boolean success = true;
        try {
            BufferedWriter tmpWriter = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(tmpFile))));
            tmpWriter.write(content.toString(), 0, content.length());
            tmpWriter.close();
        }
        catch (IOException exception) {
            log.error((Object)("can't write file " + filename));
            success = false;
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getClassOfField(String className, String fieldName) {
        try {
            Class<?> clazz;
            Class<?> currentClass = Class.forName(className);
            Field theField = null;
            while (theField == null) {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (currentClass == clazz2) break;
                try {
                    theField = currentClass.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    theField = null;
                    currentClass = currentClass.getSuperclass();
                }
                catch (SecurityException e) {
                    log.error((Object)e.getMessage());
                    log.error((Object)e.toString());
                }
            }
            if ((clazz = class$1) == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$1 = clazz3;
            }
            if (currentClass == clazz) {
                return null;
            }
            return currentClass.getName();
        }
        catch (Exception exception) {
            log.error((Object)exception.toString());
            log.error((Object)exception.getMessage());
            throw new Error("className=" + className + ",fieldName=" + fieldName);
        }
    }

    public StringBuffer removeFragmentsFor(String fileName) {
        File inputFile = new File(fileName);
        StringBuffer out = new StringBuffer();
        BufferedReader fr = null;
        boolean append = true;
        Vector<String> toBeRemovedAttr = new Vector<String>();
        Vector<String> toBeRemovedClasses = new Vector<String>();
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLClass::fragments");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLClass::proxies");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLFile::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLFile::fragments");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLProject::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLBaseTypes::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLTransitionGuard::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLStereotype::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLTypeList::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLStopActivity::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLTransition::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLStatementActivity::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLActivityDiagram::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLStartActivity::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLAttrExprPair::displayLevel");
        toBeRemovedAttr.add("de.uni_paderborn.fujaba.uml.UMLMethod::proxies");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.uml.UMLFragment");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.uml.UMLFragment$PackageDecl");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.uml.UMLFragment$ImportDecl");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisCanvasItem");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisObject");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisLine");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisColumn");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisComposite");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisGrab");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisRow");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisText");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisVisibilityIcon");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisCanvas");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisSeparator");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisFrame");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisResizeable");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisBend");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisIcon");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisPointingText");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.dis.DisConnector");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.sim.SimConnectorInstance");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.sim.SimObjectInstance");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.sim.SimConnector");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.sim.SimAttr");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.sim.SimAttrInstance");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.sim.SimObject");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.sim.SimTool");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.sim.SimState");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.sim.SimTopologyDiagram");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.pattern.DPAnnotation");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.pattern.DPAccessMethodAnnotation");
        toBeRemovedClasses.add("de.uni_paderborn.fujaba.pattern.DPLine");
        try {
            try {
                fr = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(inputFile))), 32768);
            }
            catch (IOException e) {
                fr = new BufferedReader(new FileReader(inputFile), 32768);
            }
            String line = fr.readLine();
            int lineNum = 0;
            StringBuffer header = new StringBuffer();
            int hashTableLength = 0;
            ++lineNum;
            if (!line.startsWith("# Fujaba-Project-File")) {
                throw new RuntimeException("This is not a Fujaba project file");
            }
            header.append(line);
            header.append("\n");
            boolean isFragment = false;
            boolean isHeader = true;
            String className = null;
            while (fr.ready()) {
                append = true;
                ++lineNum;
                line = fr.readLine();
                StringTokenizer lineTok = this.createLineTokenizer(line);
                switch (line.charAt(0)) {
                    case '#': {
                        break;
                    }
                    case '-': {
                        String name = lineTok.nextToken();
                        if (!name.equals("HashTableLength")) break;
                        hashTableLength = Integer.parseInt(lineTok.nextToken());
                        append = false;
                        isHeader = false;
                        break;
                    }
                    case '+': {
                        lineTok.nextToken();
                        className = lineTok.nextToken();
                        if (toBeRemovedClasses.contains(className)) {
                            append = false;
                        }
                        className = null;
                        break;
                    }
                    case '*': {
                        lineTok.nextToken();
                        className = lineTok.nextToken();
                        if (toBeRemovedClasses.contains(className)) {
                            --hashTableLength;
                            isFragment = true;
                            append = false;
                            break;
                        }
                        isFragment = false;
                        break;
                    }
                    case '~': {
                        if (isFragment) {
                            append = false;
                            break;
                        }
                        String shortAttrName = lineTok.nextToken();
                        String attrName = String.valueOf(className) + "::" + shortAttrName;
                        if (toBeRemovedAttr.contains(attrName)) {
                            append = false;
                            break;
                        }
                        String classOfField = this.getClassOfField(className, shortAttrName);
                        if (classOfField != null) {
                            line = "~;" + classOfField + "::" + shortAttrName;
                            while (lineTok.hasMoreTokens()) {
                                line = String.valueOf(line) + ";";
                                line = String.valueOf(line) + lineTok.nextToken();
                            }
                            break;
                        }
                        append = false;
                        break;
                    }
                }
                if (!append) continue;
                StringBuffer use = isHeader ? header : out;
                use.append(line);
                if (!fr.ready()) continue;
                use.append("\n");
            }
            header.append("-;HashTableLength;").append(hashTableLength).append("\n");
            out.insert(0, header.toString());
        }
        catch (IOException exception) {
            log.error((Object)("exception=" + exception));
        }
        return out;
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            log.error((Object)"Usage:");
            log.error((Object)"\tRemoveFragmentFromProject <filename>");
        } else {
            RemoveFragmentFromProject remove = new RemoveFragmentFromProject();
            StringBuffer result = remove.removeFragmentsFor(argv[0]);
            remove.writeFile(String.valueOf(argv[0].substring(0, argv[0].length() - 7)) + ".noFragment.fpr.gz", result);
        }
    }

    public String toString() {
        return "RemoveFragmentFromProject[]";
    }
}

