/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.uni_paderborn.fujaba.app.ProgressBar;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.Cursor;
import javax.swing.JFrame;

public class ProgressBarWrapper {
    private ProgressBar myProgress = null;
    private JFrame frame;
    private int max;
    private String title;

    public ProgressBarWrapper(JFrame frame, String title, int max) {
        if (frame == null) {
            try {
                frame = UMLProject.get().getGui().getFrame();
            }
            catch (Exception e) {
                frame = new JFrame();
            }
        }
        this.frame = frame;
        this.max = max;
        this.title = title;
        this.myProgress = null;
    }

    public void openWindow() {
        this.myProgress = new ProgressBar(this.frame, this.max, this.title);
        this.myProgress.pack();
        this.myProgress.centerDialog();
        this.myProgress.show();
        this.myProgress.setCursor(Cursor.getPredefinedCursor(3));
        this.myProgress.cancel.setCursor(Cursor.getPredefinedCursor(0));
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void increment(String statusText) {
        if (this.myProgress != null) {
            this.myProgress.increment(statusText);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isAborted() {
        return this.myProgress == null || this.myProgress.isAborted();
    }

    public void closeWindow() {
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
        if (this.myProgress != null) {
            this.myProgress.setCursor(Cursor.getPredefinedCursor(0));
            this.myProgress.setVisible(false);
        }
    }
}

