/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.Version;
import de.uni_paderborn.fujaba.basic.FD;
import de.uni_paderborn.fujaba.preferences.PlugInsPreferences;
import de.uni_paderborn.fujaba.preferences.gui.ServerListParser;
import de.upb.lib.plugins.KernelInterface;
import de.upb.lib.plugins.PluginManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;

public class KernelInterfaceImpl
implements KernelInterface {
    private Version fujabaVersion = Version.get();
    private PluginManager manager = PluginManager.getInstance(this);
    private static volatile KernelInterfaceImpl theInstance;

    private KernelInterfaceImpl() {
        if (FD.isOn(256)) {
            this.manager.setDebugLevel(1);
        }
    }

    public static KernelInterfaceImpl get() {
        if (theInstance == null) {
            theInstance = new KernelInterfaceImpl();
        }
        return theInstance;
    }

    public int getMajorVersion() {
        return this.fujabaVersion.getMajor();
    }

    public int getMinorVersion() {
        return this.fujabaVersion.getMinor();
    }

    public int getBuildNumber() {
        return this.fujabaVersion.getBuild();
    }

    public int getRevisionNumber() {
        return this.fujabaVersion.getRevision();
    }

    public Vector getPluginServerURLs() {
        Vector urls = PlugInsPreferences.get().getPluginDownloadURLs();
        if (urls.size() == 0) {
            try {
                ServerListParser serverListParser = new ServerListParser();
                Iterator urlIter = serverListParser.getURLs(new URL("http://www.uni-paderborn.de/cs/fujaba/downloads/plugins/PluginServer.xml"));
                if (urlIter != null) {
                    while (urlIter.hasNext()) {
                        urls.add(urlIter.next());
                    }
                    PlugInsPreferences.get().setPluginDownloadURLs(urls);
                } else {
                    JOptionPane.showMessageDialog(FrameMain.get(), "An error occurred while retrieving the server list. Are you connected to the Internet? Consult the console for a more detailed message.", "Error", 0);
                }
            }
            catch (MalformedURLException e) {
                JOptionPane.showMessageDialog(FrameMain.get(), "An internal error occurred while retrieving the server list. Please inform the Fujaba developers: " + e.toString(), "Error", 0);
            }
        }
        return urls;
    }

    public PluginManager getManager() {
        return this.manager;
    }
}

