/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.uni_paderborn.fujaba.app.FrameDecorator;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.fsa.FSALayeredPane;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.swing.JDiagramRootPane;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.tree.DefaultMutableTreeNode;

public class InternalFrame
extends JInternalFrame {
    final ASGDiagram diagram;
    final FrameMain frameMain;
    private JPanel toolbarsPanel;
    private JComponent diagramComponent;
    private JScrollPane scrollerPanel;
    private JDiagramRootPane diagramRootPane;

    public ASGDiagram getDiagram() {
        return this.diagram;
    }

    public InternalFrame(ASGDiagram shownDiagram, FrameMain frameMain) {
        this.frameMain = frameMain;
        this.setTitle(shownDiagram != null ? shownDiagram.getName() : "");
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.diagram = shownDiagram;
        if (shownDiagram != null) {
            Icon icon = null;
            Iterator it = frameMain.iteratorOfDecorators();
            while (it.hasNext() && icon == null) {
                FrameDecorator decorator = (FrameDecorator)it.next();
                try {
                    Component displayComp = decorator.getTreeCellRenderer().getTreeCellRendererComponent(new JTree(), new DefaultMutableTreeNode(shownDiagram), false, false, false, 0, false);
                    if (!(displayComp instanceof JLabel)) continue;
                    icon = ((JLabel)displayComp).getIcon();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setFrameIcon(icon);
            shownDiagram.addPropertyChangeListener("name", new DiagramNameListener());
        }
        this.createDiagramPanel();
        this.addInternalFrameListener(new ActivationAndCloseListener());
    }

    public Container getDiagramPanel() {
        return this.getContentPane();
    }

    public JScrollPane getScrollerPanel() {
        return this.scrollerPanel;
    }

    public JComponent getDiagramComponent() {
        return this.diagramComponent;
    }

    protected void setDiagramComponent(JComponent comp) {
        if (this.diagramComponent != null) {
            this.getContentPane().remove(this.diagramComponent);
        }
        this.diagramComponent = comp;
        this.getContentPane().add((Component)comp, "Center");
    }

    private void createDiagramPanel() {
        this.getContentPane().setLayout(new BorderLayout());
        this.scrollerPanel = new JScrollPane();
        this.scrollerPanel.setBackground(ColorsPreferences.get().DIAGRAM_BACKGROUND);
        this.scrollerPanel.getViewport().setBackground(ColorsPreferences.get().DIAGRAM_BACKGROUND);
        this.scrollerPanel.getViewport().setDoubleBuffered(true);
        this.scrollerPanel.getViewport().setScrollMode(1);
        this.scrollerPanel.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollerPanel.getHorizontalScrollBar().setUnitIncrement(20);
        this.scrollerPanel.getViewport().add(this.getDiagramRootPane());
        this.setDiagramComponent(this.scrollerPanel);
        this.toolbarsPanel = new JPanel();
        this.toolbarsPanel.setLayout(new GridLayout(1, 0));
        this.getContentPane().add((Component)this.toolbarsPanel, "West");
    }

    public JDiagramRootPane getDiagramRootPane() {
        if (this.diagramRootPane == null) {
            this.diagramRootPane = new JDiagramRootPane();
            this.diagramRootPane.setBackground(ColorsPreferences.get().DIAGRAM_BACKGROUND);
        }
        return this.diagramRootPane;
    }

    public FSALayeredPane getDiagramRoot() {
        FSAObject obj;
        JComponent comp;
        FSALayeredPane diagramRoot = null;
        if (this.diagramRootPane != null && (comp = this.diagramRootPane.getContentPane()) != null && (obj = FSAObject.getFSAObjectFromJComponent(comp)) != null && obj instanceof FSALayeredPane) {
            diagramRoot = (FSALayeredPane)obj;
        }
        return diagramRoot;
    }

    public void addDiagramToolBar(JToolBar toolBar) {
        if (toolBar != null) {
            toolBar.setVisible(true);
            toolBar.setOrientation(1);
            this.toolbarsPanel.add(toolBar);
        }
    }

    public void removeDiagramToolBar(JToolBar toolBar) {
        if (toolBar != null) {
            toolBar.setVisible(false);
            this.toolbarsPanel.remove(toolBar);
        }
    }

    public void removeAllDiagramToolBars() {
        this.toolbarsPanel.removeAll();
    }

    private class ActivationAndCloseListener
    extends InternalFrameAdapter {
        ActivationAndCloseListener() {
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            if (!InternalFrame.this.frameMain.isInShowDiagram() && InternalFrame.this.diagram != null && !InternalFrame.this.isIcon()) {
                InternalFrame.this.frameMain.showDiagram(InternalFrame.this.diagram);
            }
        }

        public void internalFrameClosed(InternalFrameEvent e) {
            if (InternalFrame.this.diagram != null) {
                if (UMLProject.get().getCurrentDiagram() == InternalFrame.this.diagram) {
                    InternalFrame.this.frameMain.showDiagram(null);
                }
                InternalFrame.this.frameMain.frames.remove(InternalFrame.this.diagram);
                Iterator iter = InternalFrame.this.diagram.iteratorOfFsaObjects();
                while (iter.hasNext()) {
                    FSAObject fsa = (FSAObject)iter.next();
                    fsa.removeYou();
                }
            }
        }

        public void internalFrameIconified(InternalFrameEvent e) {
            try {
                InternalFrame.this.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private class DiagramNameListener
    implements PropertyChangeListener {
        DiagramNameListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            InternalFrame.this.setTitle(InternalFrame.this.diagram.getName());
        }
    }
}

