/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.uni_paderborn.fujaba.app.AboutBox;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.FujabaPersistencySupport;
import de.uni_paderborn.fujaba.app.KernelInterfaceImpl;
import de.uni_paderborn.fujaba.app.Version;
import de.uni_paderborn.fujaba.basic.FileHistory;
import de.uni_paderborn.fujaba.coobra.RecoverDialog;
import de.uni_paderborn.fujaba.preferences.DebugPreferences;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;
import de.uni_paderborn.fujaba.preferences.LoggingPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;
import de.uni_paderborn.fujaba.project.PersistencySupport;
import de.uni_paderborn.fujaba.texteditor.TextEditor;
import de.uni_paderborn.lib.classloader.UPBClassLoader;
import de.upb.lib.plugins.PluginManager;
import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class FujabaApp {
    private static final transient Logger log;
    private static volatile FujabaApp fujabaApp;
    private static PluginManager pluginManager;
    private static PersistencySupport persistencySupport;
    public static final transient URI FUJABA_BASE;
    public static final String PROPERTIES_PATH;
    private static boolean started;
    public Vector javaFiles = new Vector();
    private String loadFprFile = null;
    private boolean showAboutBox = true;
    private boolean invisible = false;
    private boolean maximize = false;
    private boolean debugMode = false;
    private String desiredPropertyDir = null;
    private static boolean allowedToCallSystemExit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.FujabaApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        persistencySupport = new FujabaPersistencySupport();
        FUJABA_BASE = FujabaApp.findFujabaBase();
        PROPERTIES_PATH = String.valueOf(System.getProperty("user.home")) + File.separator + "fujaba.properties";
        started = false;
        allowedToCallSystemExit = true;
    }

    public static PersistencySupport getPersistencySupport() {
        return persistencySupport;
    }

    public static void setPersistencySupport(PersistencySupport value) {
        persistencySupport = value;
    }

    private static final URI findFujabaBase() {
        URI uri;
        block13: {
            URL url;
            uri = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.app.FujabaApp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((url = clazz.getResource("FujabaApp.class")) != null) {
                try {
                    URLConnection connection = url.openConnection();
                    if (connection instanceof JarURLConnection) {
                        JarURLConnection jarConnection = (JarURLConnection)connection;
                        url = jarConnection.getJarFileURL();
                        uri = new URI(url.toExternalForm());
                        uri = uri.resolve(".");
                        break block13;
                    }
                    uri = new URI(url.toExternalForm());
                    StringBuffer parentBuffer = new StringBuffer();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("de.uni_paderborn.fujaba.app.FujabaApp");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    StringTokenizer packTokens = new StringTokenizer(clazz2.getName(), ".");
                    while (packTokens.hasMoreTokens()) {
                        parentBuffer.append("../");
                        packTokens.nextToken();
                    }
                    uri = uri.resolve(parentBuffer.toString());
                }
                catch (IOException ioe) {
                    return null;
                }
                catch (URISyntaxException use) {
                    return null;
                }
            }
        }
        return uri;
    }

    private FujabaApp() {
    }

    public static FujabaApp get() {
        if (fujabaApp == null) {
            fujabaApp = new FujabaApp();
        }
        return fujabaApp;
    }

    private static void setStarted() {
        started = true;
    }

    public static FujabaApp start() {
        FujabaApp fujabaApp = FujabaApp.get();
        if (!started) {
            fujabaApp.run();
        }
        return fujabaApp;
    }

    private void initPropertyDir() {
        String propertyDir;
        block24: {
            boolean validPropertyDirFile;
            propertyDir = null;
            Properties propertyDirProperties = new Properties();
            boolean bPropertyDirModified = false;
            File propertyDirPropertiesFile = new File(PROPERTIES_PATH);
            if (this.desiredPropertyDir != null) {
                propertyDir = this.desiredPropertyDir;
                bPropertyDirModified = true;
            } else {
                try {
                    propertyDirProperties.load(new FileInputStream(propertyDirPropertiesFile));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String storedPropertyDir = null;
                if (propertyDirProperties != null) {
                    storedPropertyDir = propertyDirProperties.getProperty(PreferencesProperties.PROPERTY_DIR_PROPERTY);
                }
                if (storedPropertyDir != null) {
                    propertyDir = storedPropertyDir;
                } else {
                    propertyDir = PreferencesProperties.getProposedPropertyDir();
                    bPropertyDirModified = true;
                }
            }
            File propertyDirFile = new File(propertyDir);
            boolean bl = validPropertyDirFile = propertyDirFile != null && propertyDirFile.exists() && propertyDirFile.isDirectory();
            if (!validPropertyDirFile) {
                boolean proceed = false;
                do {
                    String title = "Fujaba " + Version.get().getVersion() + " - Specify property directory";
                    String message = null;
                    message = propertyDirFile.exists() ? "Do you want to use\n   '" + propertyDirFile + "'\nas property directory?" : "Do you want to create\n   '" + propertyDirFile + "'\nand use it as property directory?";
                    message = String.valueOf(message) + "\n\nOr do you want to browse for another property directory?\n\n";
                    Object[] options = new Object[]{"Yes", "Browse...", "Exit Fujaba"};
                    Object initialValue = options[0];
                    int iAnswer = JOptionPane.showOptionDialog(null, message, title, -1, 3, null, options, initialValue);
                    switch (iAnswer) {
                        case 0: {
                            PreferencesProperties.setPropertyDir(propertyDir);
                            break;
                        }
                        case 1: {
                            File choosePropertyDirFile = propertyDirFile.exists() ? propertyDirFile : new File(System.getProperty("user.home"));
                            JFileChooser fileChooser = new JFileChooser(choosePropertyDirFile);
                            fileChooser.setFileSelectionMode(1);
                            int chooserResult = fileChooser.showOpenDialog(null);
                            if (chooserResult != 0) break;
                            propertyDirFile = fileChooser.getSelectedFile();
                            break;
                        }
                        case -1: 
                        case 2: {
                            FujabaApp.exit(0);
                        }
                    }
                    boolean bl2 = proceed = iAnswer == 0 && propertyDirFile != null;
                    if (!proceed || propertyDirFile.exists()) continue;
                    try {
                        boolean success;
                        proceed = success = propertyDirFile.mkdirs();
                        if (log.isEnabledFor(Priority.ERROR) && !success) {
                            System.err.println("error creating directory '" + propertyDirFile + "': is the directory valid and do you have write access?");
                        }
                        if (!log.isEnabledFor(Priority.INFO) || !success) continue;
                        System.out.println("created directory '" + propertyDirFile + "'");
                    }
                    catch (Exception e) {
                        if (log.isEnabledFor(Priority.ERROR)) {
                            log.error((Object)("error creating directory '" + propertyDirFile + "': " + e.getMessage()));
                        }
                        proceed = false;
                    }
                } while (!(proceed = proceed && propertyDirFile.exists()));
                bPropertyDirModified = true;
            }
            PreferencesProperties.setPropertyDir(propertyDirFile.getAbsolutePath());
            propertyDir = PreferencesProperties.getPropertyDir();
            if (log.isInfoEnabled()) {
                log.info((Object)("using propertyDir '" + propertyDir + "'"));
            }
            if (bPropertyDirModified) {
                propertyDirProperties.put(PreferencesProperties.PROPERTY_DIR_PROPERTY, propertyDir);
                try {
                    propertyDirProperties.store(new FileOutputStream(propertyDirPropertiesFile), "Fujaba Properties, Do NOT edit!");
                    if (log.isInfoEnabled()) {
                        log.info((Object)("propertyDir stored in '" + propertyDirPropertiesFile + "'"));
                    }
                }
                catch (Exception e) {
                    if (propertyDir.equals(PreferencesProperties.getProposedPropertyDir()) || !log.isEnabledFor(Priority.ERROR)) break block24;
                    log.error((Object)("The propertyDir '" + propertyDir + "' could not be stored in file '" + propertyDirPropertiesFile + "': the propertyDir won't be recognized at the next fujaba-run and you will be asked again, which propertyDir to use."));
                    e.printStackTrace();
                }
            }
        }
        System.setProperty("log4j.defaultInitOverride", "true");
        if (propertyDir.endsWith(File.separator)) {
            propertyDir = propertyDir.substring(0, propertyDir.length() - 1);
        }
        System.setProperty("fujaba.propertydir", propertyDir);
    }

    public void run() {
        this.initPropertyDir();
        AboutBox aboutBox = null;
        if (this.getLoadFprFile() == null && this.isShowAboutBox()) {
            aboutBox = new AboutBox(null, true);
            aboutBox.setCursor(Cursor.getPredefinedCursor(3));
            aboutBox.setVisible(true);
        }
        LoggingPreferences.get();
        DebugPreferences.get().setDebugMode(this.isDebugMode());
        pluginManager = KernelInterfaceImpl.get().getManager();
        String lookAndFeel = GeneralPreferences.get().getLookAndFeel();
        String lafClassName = null;
        UIManager.LookAndFeelInfo[] installedLaFs = UIManager.getInstalledLookAndFeels();
        int i22 = 0;
        while (i22 < installedLaFs.length && lafClassName == null) {
            if (lookAndFeel.equals(installedLaFs[i22].getName())) {
                lafClassName = installedLaFs[i22].getClassName();
            }
            ++i22;
        }
        try {
            UIManager.setLookAndFeel(lafClassName);
        }
        catch (Exception i22) {
            // empty catch block
        }
        FrameMain frameMain = FrameMain.get();
        frameMain.init();
        try {
            if (this.getLoadFprFile() != null) {
                File myFile;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("opening " + this.getLoadFprFile()));
                }
                if ((myFile = new File(this.getLoadFprFile())).exists() && log.isDebugEnabled()) {
                    log.debug((Object)("loading " + this.getLoadFprFile()));
                }
                SwingUtilities.invokeLater(new ProjectLoader());
            }
            if (aboutBox != null) {
                aboutBox.setVisible(false);
            }
            TextEditor.get();
            frameMain.setVisible(!this.isInvisible());
            FujabaApp.setStarted();
            new RecoverDialog(frameMain).check();
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("uncaught exception: " + t));
            }
            t.printStackTrace();
        }
    }

    public void setLoadFprFile(String name) {
        this.loadFprFile = name;
    }

    public String getLoadFprFile() {
        return this.loadFprFile;
    }

    public void setShowAboutBox(boolean flag) {
        this.showAboutBox = flag;
    }

    public boolean isShowAboutBox() {
        return this.showAboutBox;
    }

    public void setInvisible(boolean flag) {
        this.invisible = flag;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setMaximize(boolean maximize) {
        this.maximize = maximize;
    }

    public boolean isMaximize() {
        return this.maximize;
    }

    public void setDebugMode(boolean value) {
        this.debugMode = value;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    private void setDesiredPropertyDir(String value) {
        this.desiredPropertyDir = value;
    }

    public static void main(String[] argv) {
        BasicConfigurator.configure();
        if (log.isInfoEnabled()) {
            log.info((Object)"Welcome to Fujaba");
        }
        Runtime.getRuntime().traceMethodCalls(false);
        FujabaApp app = FujabaApp.get();
        boolean parameterError = false;
        int i = 0;
        while (i < argv.length && !parameterError) {
            try {
                if (argv[i].equals("-noabout")) {
                    app.setShowAboutBox(false);
                } else if (argv[i].equals("-invisible")) {
                    app.setInvisible(true);
                } else if (argv[i].equals("-last")) {
                    File lastFile = FileHistory.get().firstOfHistory();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("-last loads: " + lastFile.getPath()));
                    }
                    app.setLoadFprFile(lastFile.getPath());
                } else if (argv[i].equals("-debug")) {
                    app.setDebugMode(true);
                } else if (argv[i].equals("-max")) {
                    app.setMaximize(true);
                } else if (argv[i].equals("-config")) {
                    app.setDesiredPropertyDir(argv[i + 1]);
                    ++i;
                } else if ((argv[i].endsWith(".fpr") || argv[i].endsWith(".fpr.gz") || argv[i].endsWith(".xml") || argv[i].endsWith(".xml.gz")) && app.getLoadFprFile() == null) {
                    app.setLoadFprFile(argv[i]);
                } else {
                    if (log.isEnabledFor(Priority.ERROR)) {
                        log.error((Object)("Parameter is unknown: " + argv[i]));
                    }
                    parameterError = true;
                }
            }
            catch (IndexOutOfBoundsException iex) {
                if (log.isEnabledFor(Priority.ERROR)) {
                    log.error((Object)("Too few arguments for: " + argv[i]));
                }
                parameterError = true;
            }
            ++i;
        }
        if (parameterError) {
            if (log.isInfoEnabled()) {
                log.info((Object)"The following parameters are valid:");
                log.info((Object)" -noabout : do not show the fujaba about box.");
                log.info((Object)" -invisible : makes frame invisible as soon as possible.");
                log.info((Object)" -last : loads the last project.");
                log.info((Object)" -debug : turns on the debug mode.");
                log.info((Object)" -max : starts fujaba in full screen mode.");
                log.info((Object)" -config <dir> : uses <dir> instead of $HOME/fujaba<version> as property dir.");
            }
            return;
        }
        Thread.currentThread().setContextClassLoader(UPBClassLoader.get("fujaba.core"));
        app.run();
    }

    public static PluginManager getPluginManager() {
        return pluginManager;
    }

    public static void setPluginManager(PluginManager manager) {
        pluginManager = manager;
    }

    public static boolean isAllowedToCallSystemExit() {
        return allowedToCallSystemExit;
    }

    public static void setAllowedToCallSystemExit(boolean allowedToCallSystemExit) {
        FujabaApp.allowedToCallSystemExit = allowedToCallSystemExit;
    }

    public static void exit(int status) {
        if (FujabaApp.isAllowedToCallSystemExit()) {
            System.exit(status);
        } else {
            FrameMain.get().dispose();
        }
    }

    class ProjectLoader
    implements Runnable {
        ProjectLoader() {
        }

        public void run() {
            FrameMain frameMain = FrameMain.get();
            File myFile = new File(FujabaApp.this.getLoadFprFile());
            frameMain.openFile(myFile);
        }
    }
}

