/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.app;

import de.uni_paderborn.fujaba.app.Block;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;

class BlockContainer {
    private Vector blockTable;
    private int width;
    private int wordStart = 0;
    private int wordEnd = 0;

    public BlockContainer(int w) {
        this.width = w;
        this.blockTable = new Vector();
    }

    private String getNextWord(String scriptLine) {
        this.wordEnd = scriptLine.indexOf(" ", this.wordStart);
        if (this.wordEnd == -1) {
            this.wordEnd = scriptLine.length();
        }
        String s = scriptLine.substring(this.wordStart, this.wordEnd);
        this.wordStart = this.wordEnd + 1;
        return s;
    }

    private void resetGNW() {
        this.wordEnd = 0;
        this.wordStart = 0;
    }

    public boolean readScript(String script, Font titleF, Font textF, Font subtitleF) throws Exception {
        int titleCount = -1;
        int lineWidth = 0;
        int blockHeight = 0;
        Block newBlock = null;
        String blockLine = "";
        boolean inBlock = false;
        boolean inTitle = false;
        BufferedReader in = null;
        BufferedImage fImg = new BufferedImage(1, 1, 1);
        Graphics fmap = fImg.getGraphics();
        fmap.setFont(textF);
        FontMetrics fMetric = fmap.getFontMetrics();
        try {
            URL url = ClassLoader.getSystemClassLoader().getResource(script);
            in = new BufferedReader(new InputStreamReader(url.openStream()));
        }
        catch (Exception e) {
            throw new IOException("Script does not exist:");
        }
        block4: while (true) {
            String scriptLine;
            try {
                scriptLine = in.readLine();
            }
            catch (Exception e) {
                throw new IOException("Script Read ERROR");
            }
            if (scriptLine == null) {
                in.close();
                return true;
            }
            scriptLine.trim();
            this.resetGNW();
            while (true) {
                if (this.wordEnd >= scriptLine.length()) continue block4;
                String word = this.getNextWord(scriptLine);
                if (inBlock) {
                    if (word.startsWith("</BLOCK>")) {
                        inBlock = false;
                        if (blockLine.length() > 0) {
                            newBlock.addLine(blockLine);
                            blockHeight += fMetric.getHeight();
                        }
                        newBlock.setBlockHeight(blockHeight);
                        newBlock.setTitleCount(titleCount);
                        this.blockTable.add(newBlock);
                        blockLine = "";
                        lineWidth = 0;
                        blockHeight = 0;
                        titleCount = -1;
                        inTitle = false;
                        continue;
                    }
                    if (word.startsWith("<TITLE>")) {
                        inTitle = true;
                        fmap.setFont(titleF);
                        fMetric = fmap.getFontMetrics();
                        continue;
                    }
                    if (word.startsWith("</TITLE>") || word.startsWith("<SUBTITLE>") || word.startsWith("</SUBTITLE>") || word.startsWith("<CR>")) {
                        if (word.startsWith("<CR>") || blockLine.length() != 0) {
                            newBlock.addLine(blockLine);
                            blockHeight += fMetric.getHeight();
                            blockLine = "";
                            lineWidth = 0;
                        }
                        if (inTitle) {
                            ++titleCount;
                        }
                        if (word.startsWith("<SUBTITLE>")) {
                            newBlock.setSubtitleLine(newBlock.getLineCount());
                            inTitle = false;
                            fmap.setFont(subtitleF);
                            fMetric = fmap.getFontMetrics();
                            continue;
                        }
                        if (!word.startsWith("</TITLE>") && !word.startsWith("</SUBTITLE>")) continue;
                        inTitle = false;
                        fmap.setFont(textF);
                        fMetric = fmap.getFontMetrics();
                        continue;
                    }
                    if (lineWidth + fMetric.stringWidth(String.valueOf(word) + " ") < this.width) {
                        blockLine = String.valueOf(blockLine) + word + " ";
                        lineWidth += fMetric.stringWidth(String.valueOf(word) + " ");
                        continue;
                    }
                    newBlock.addLine(blockLine);
                    blockLine = String.valueOf(word) + " ";
                    lineWidth = fMetric.stringWidth(String.valueOf(word) + " ");
                    blockHeight += fMetric.getHeight();
                    if (!inTitle) continue;
                    ++titleCount;
                    continue;
                }
                if (!word.startsWith("<BLOCK>")) continue;
                inBlock = true;
                newBlock = new Block();
                fmap.setFont(textF);
                fMetric = fmap.getFontMetrics();
            }
            break;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public Block getBlock(int i) {
        return (Block)this.blockTable.get(i);
    }

    public int getBlockCount() {
        return this.blockTable.size();
    }
}

